/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.workflow.catalog.resources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.registry.core.workflow.catalog.model.Workflow;
import org.apache.airavata.registry.core.workflow.catalog.model.WorkflowOutput;
import org.apache.airavata.registry.core.workflow.catalog.model.WorkflowOutput_PK;
import org.apache.airavata.registry.core.workflow.catalog.resources.WorkflowCatAbstractResource;
import org.apache.airavata.registry.core.workflow.catalog.resources.WorkflowCatalogResource;
import org.apache.airavata.registry.core.workflow.catalog.resources.WorkflowResource;
import org.apache.airavata.registry.core.workflow.catalog.utils.WorkflowCatalogJPAUtils;
import org.apache.airavata.registry.core.workflow.catalog.utils.WorkflowCatalogQueryGenerator;
import org.apache.airavata.registry.core.workflow.catalog.utils.WorkflowCatalogResourceType;
import org.apache.airavata.registry.cpi.WorkflowCatalogException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowOutputResource
extends WorkflowCatAbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowOutputResource.class);
    private String wfTemplateId;
    private String outputKey;
    private String outputVal;
    private String dataType;
    private boolean isRequired;
    private boolean dataMovement;
    private String dataNameLocation;
    private boolean requiredToCMD;
    private String searchQuery;
    private String appArgument;
    private boolean outputStreaming;
    private WorkflowResource workflowResource;

    @Override
    public void remove(Object identifier) throws WorkflowCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new WorkflowCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = WorkflowCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            WorkflowCatalogQueryGenerator generator = new WorkflowCatalogQueryGenerator("WorkflowOutput", new Object[0][]);
            generator.setParameter("templateId", ids.get("templateId"));
            generator.setParameter("outputKey", ids.get("outputKey"));
            Query q = generator.deleteQuery(em);
            q.executeUpdate();
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new WorkflowCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public WorkflowCatalogResource get(Object identifier) throws WorkflowCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new WorkflowCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = WorkflowCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            WorkflowCatalogQueryGenerator generator = new WorkflowCatalogQueryGenerator("WorkflowOutput", new Object[0][]);
            generator.setParameter("templateId", ids.get("templateId"));
            generator.setParameter("outputKey", ids.get("outputKey"));
            Query q = generator.selectQuery(em);
            WorkflowOutput wfOutput = (WorkflowOutput)q.getSingleResult();
            WorkflowOutputResource workflowOutputResource = (WorkflowOutputResource)WorkflowCatalogJPAUtils.getResource(WorkflowCatalogResourceType.WORKFLOW_OUTPUT, wfOutput);
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            WorkflowOutputResource workflowOutputResource2 = workflowOutputResource;
            return workflowOutputResource2;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new WorkflowCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<WorkflowCatalogResource> get(String fieldName, Object value) throws WorkflowCatalogException {
        ArrayList<WorkflowCatalogResource> wfOutputResources = new ArrayList<WorkflowCatalogResource>();
        EntityManager em = null;
        try {
            em = WorkflowCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            WorkflowCatalogQueryGenerator generator = new WorkflowCatalogQueryGenerator("WorkflowOutput", new Object[0][]);
            if (fieldName.equals("templateId")) {
                generator.setParameter("templateId", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        WorkflowOutput wfOutput = (WorkflowOutput)result;
                        WorkflowOutputResource workflowOutputResource = (WorkflowOutputResource)WorkflowCatalogJPAUtils.getResource(WorkflowCatalogResourceType.WORKFLOW_OUTPUT, wfOutput);
                        wfOutputResources.add(workflowOutputResource);
                    }
                }
            } else if (fieldName.equals("outputKey")) {
                generator.setParameter("outputKey", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        WorkflowOutput workflowOutput = (WorkflowOutput)result;
                        WorkflowOutputResource workflowOutputResource = (WorkflowOutputResource)WorkflowCatalogJPAUtils.getResource(WorkflowCatalogResourceType.WORKFLOW_OUTPUT, workflowOutput);
                        wfOutputResources.add(workflowOutputResource);
                    }
                }
            } else if (fieldName.equals("dataType")) {
                generator.setParameter("dataType", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        WorkflowOutput workflowOutput = (WorkflowOutput)result;
                        WorkflowOutputResource workflowOutputResource = (WorkflowOutputResource)WorkflowCatalogJPAUtils.getResource(WorkflowCatalogResourceType.WORKFLOW_OUTPUT, workflowOutput);
                        wfOutputResources.add(workflowOutputResource);
                    }
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for WF Output Resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for WF Output Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new WorkflowCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return wfOutputResources;
    }

    @Override
    public List<WorkflowCatalogResource> getAll() throws WorkflowCatalogException {
        return null;
    }

    @Override
    public List<String> getAllIds() throws WorkflowCatalogException {
        return null;
    }

    @Override
    public List<String> getIds(String fieldName, Object value) throws WorkflowCatalogException {
        ArrayList<String> wfOutputResourceIDs = new ArrayList<String>();
        EntityManager em = null;
        try {
            WorkflowOutput workflowOutput;
            List results;
            Query q;
            em = WorkflowCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            WorkflowCatalogQueryGenerator generator = new WorkflowCatalogQueryGenerator("WorkflowOutput", new Object[0][]);
            if (fieldName.equals("templateId")) {
                generator.setParameter("templateId", value);
                q = generator.selectQuery(em);
                results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        workflowOutput = (WorkflowOutput)result;
                        wfOutputResourceIDs.add(workflowOutput.getTemplateId());
                    }
                }
            }
            if (fieldName.equals("outputKey")) {
                generator.setParameter("outputKey", value);
                q = generator.selectQuery(em);
                results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        workflowOutput = (WorkflowOutput)result;
                        wfOutputResourceIDs.add(workflowOutput.getTemplateId());
                    }
                }
            } else if (fieldName.equals("dataType")) {
                generator.setParameter("dataType", value);
                q = generator.selectQuery(em);
                results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        workflowOutput = (WorkflowOutput)result;
                        wfOutputResourceIDs.add(workflowOutput.getTemplateId());
                    }
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for WF Output resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for WF Output Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new WorkflowCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return wfOutputResourceIDs;
    }

    @Override
    public void save() throws WorkflowCatalogException {
        EntityManager em = null;
        try {
            em = WorkflowCatalogJPAUtils.getEntityManager();
            WorkflowOutput existingWorkflowOutput = (WorkflowOutput)em.find(WorkflowOutput.class, (Object)new WorkflowOutput_PK(this.wfTemplateId, this.outputKey));
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            em = WorkflowCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            if (existingWorkflowOutput != null) {
                existingWorkflowOutput.setTemplateId(this.wfTemplateId);
                Workflow workflow = (Workflow)em.find(Workflow.class, (Object)this.wfTemplateId);
                existingWorkflowOutput.setWorkflow(workflow);
                existingWorkflowOutput.setDataType(this.dataType);
                existingWorkflowOutput.setOutputKey(this.outputKey);
                if (this.outputVal != null) {
                    existingWorkflowOutput.setOutputVal(this.outputVal.toCharArray());
                }
                existingWorkflowOutput.setDataMovement(this.dataMovement);
                existingWorkflowOutput.setDataNameLocation(this.dataNameLocation);
                em.merge((Object)existingWorkflowOutput);
            } else {
                WorkflowOutput workflowOutput = new WorkflowOutput();
                workflowOutput.setTemplateId(this.wfTemplateId);
                Workflow workflow = (Workflow)em.find(Workflow.class, (Object)this.wfTemplateId);
                workflowOutput.setWorkflow(workflow);
                workflowOutput.setDataType(this.dataType);
                workflowOutput.setOutputKey(this.outputKey);
                if (this.outputVal != null) {
                    workflowOutput.setOutputVal(this.outputVal.toCharArray());
                }
                workflowOutput.setDataMovement(this.dataMovement);
                workflowOutput.setDataNameLocation(this.dataNameLocation);
                em.persist((Object)workflowOutput);
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new WorkflowCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public boolean isExists(Object identifier) throws WorkflowCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new WorkflowCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = WorkflowCatalogJPAUtils.getEntityManager();
            WorkflowOutput workflowOutput = (WorkflowOutput)em.find(WorkflowOutput.class, (Object)new WorkflowOutput_PK((String)ids.get("templateId"), (String)ids.get("outputKey")));
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            boolean bl = workflowOutput != null;
            return bl;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new WorkflowCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public String getWfTemplateId() {
        return this.wfTemplateId;
    }

    public void setWfTemplateId(String wfTemplateId) {
        this.wfTemplateId = wfTemplateId;
    }

    public String getOutputKey() {
        return this.outputKey;
    }

    public void setOutputKey(String outputKey) {
        this.outputKey = outputKey;
    }

    public String getOutputVal() {
        return this.outputVal;
    }

    public void setOutputVal(String outputVal) {
        this.outputVal = outputVal;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public WorkflowResource getWorkflowResource() {
        return this.workflowResource;
    }

    public void setWorkflowResource(WorkflowResource workflowResource) {
        this.workflowResource = workflowResource;
    }

    public boolean isDataMovement() {
        return this.dataMovement;
    }

    public void setDataMovement(boolean dataMovement) {
        this.dataMovement = dataMovement;
    }

    public String getDataNameLocation() {
        return this.dataNameLocation;
    }

    public void setDataNameLocation(String dataNameLocation) {
        this.dataNameLocation = dataNameLocation;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public void setRequired(boolean isRequired) {
        this.isRequired = isRequired;
    }

    public boolean isRequiredToCMD() {
        return this.requiredToCMD;
    }

    public void setRequiredToCMD(boolean requiredToCMD) {
        this.requiredToCMD = requiredToCMD;
    }

    public String getSearchQuery() {
        return this.searchQuery;
    }

    public void setSearchQuery(String searchQuery) {
        this.searchQuery = searchQuery;
    }

    public String getAppArgument() {
        return this.appArgument;
    }

    public void setAppArgument(String appArgument) {
        this.appArgument = appArgument;
    }

    public boolean isOutputStreaming() {
        return this.outputStreaming;
    }

    public void setOutputStreaming(boolean outputStreaming) {
        this.outputStreaming = outputStreaming;
    }
}

