/*
 * Decompiled with CFR 0.152.
 */
package org.apache.custos.service.federated.client.keycloak;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.KeycloakBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeycloakUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeycloakUtils.class);
    private static final String SSL_PROTOCOL = "TLS";

    public static Keycloak getClient(String serverURL, String realm, String accessToken) {
        return KeycloakBuilder.builder().serverUrl(serverURL).realm(realm).authorization(accessToken).resteasyClient(KeycloakUtils.getRestClient()).build();
    }

    public static Keycloak getClient(String serverURL, String realm, String loginUsername, String password, String clientId) {
        return KeycloakBuilder.builder().serverUrl(serverURL).realm(realm).username(loginUsername).password(password).clientId(clientId).resteasyClient(KeycloakUtils.getRestClient()).build();
    }

    private static Client getRestClient() {
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init((KeyStore)null);
            SSLContext sslContext = SSLContext.getInstance(SSL_PROTOCOL);
            sslContext.init(null, tmf.getTrustManagers(), null);
            return ClientBuilder.newBuilder().sslContext(sslContext).connectTimeout(100L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).build();
        }
        catch (Exception e) {
            LOGGER.error("Error configuring the rest client", (Throwable)e);
            throw new RuntimeException("Failed to configure the REST client", e);
        }
    }

    public static void initializeTrustStoreManager() throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustFactory.init((KeyStore)null);
        TrustManager[] trustManagers = trustFactory.getTrustManagers();
        SSLContext sslContext = SSLContext.getInstance(SSL_PROTOCOL);
        sslContext.init(null, trustManagers, new SecureRandom());
        SSLContext.setDefault(sslContext);
    }
}

