/*
 * Decompiled with CFR 0.152.
 */
package org.apache.custos.core.mapper.user;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.custos.core.model.user.Group;
import org.apache.custos.core.model.user.GroupAttribute;
import org.apache.custos.core.model.user.GroupRole;
import org.apache.custos.core.model.user.GroupToGroupMembership;
import org.apache.custos.core.user.profile.api.Group;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupMapper.class);

    public static Group createGroupEntity(org.apache.custos.core.user.profile.api.Group group, long tenantId) {
        Group groupEntity = new Group();
        String id = group.getId() + "@" + tenantId;
        Object parentId = group.getParentId();
        if (!((String)parentId).trim().isEmpty()) {
            parentId = group.getParentId() + "@" + tenantId;
        }
        groupEntity.setId(id);
        groupEntity.setExternalId(group.getId());
        groupEntity.setName(group.getName());
        groupEntity.setTenantId(tenantId);
        groupEntity.setParentId((String)parentId);
        group.getDescription();
        if (!group.getDescription().trim().isEmpty()) {
            groupEntity.setDescription(group.getDescription());
        }
        HashSet<GroupAttribute> groupList = new HashSet<GroupAttribute>();
        if (!group.getAttributesList().isEmpty()) {
            group.getAttributesList().forEach(atr -> {
                for (String value : atr.getValueList()) {
                    GroupAttribute groupAttribute = new GroupAttribute();
                    groupAttribute.setKeyValue(atr.getKey());
                    groupAttribute.setValue(value);
                    groupAttribute.setGroup(groupEntity);
                    groupList.add(groupAttribute);
                }
            });
        }
        groupEntity.setGroupAttribute(groupList);
        HashSet<GroupRole> groupRoles = new HashSet<GroupRole>();
        if (!group.getClientRolesList().isEmpty()) {
            group.getClientRolesList().forEach(role -> {
                GroupRole userRole = new GroupRole();
                userRole.setValue((String)role);
                userRole.setType("client");
                userRole.setGroup(groupEntity);
                groupRoles.add(userRole);
            });
        }
        if (!group.getRealmRolesList().isEmpty()) {
            group.getRealmRolesList().forEach(role -> {
                GroupRole userRole = new GroupRole();
                userRole.setValue((String)role);
                userRole.setType("realm");
                userRole.setGroup(groupEntity);
                groupRoles.add(userRole);
            });
        }
        groupEntity.setGroupRole(groupRoles);
        return groupEntity;
    }

    public static org.apache.custos.core.user.profile.api.Group createGroup(Group groupEntity, String ownerId, int totalMembers, String requesterRole) {
        return GroupMapper.createGroup(groupEntity, ownerId).toBuilder().setTotalMembers(totalMembers).setRequesterRole(requesterRole).build();
    }

    public static org.apache.custos.core.user.profile.api.Group createGroup(Group group, String ownerId) {
        Group.Builder groupBuilder = org.apache.custos.core.user.profile.api.Group.newBuilder().setId(group.getExternalId()).setName(group.getName()).setParentId(group.getParentId()).setCreatedTime(group.getCreatedAt().getTime()).setLastModifiedTime(group.getLastModifiedAt().getTime()).setOwnerId(ownerId);
        if (group.getDescription() != null) {
            groupBuilder.setDescription(group.getDescription());
        }
        ArrayList<String> clientRoles = new ArrayList<String>();
        ArrayList<String> realmRoles = new ArrayList<String>();
        if (group.getGroupRole() != null && !group.getGroupRole().isEmpty()) {
            group.getGroupRole().forEach(role -> {
                if (role.getType().equals("client")) {
                    clientRoles.add(role.getValue());
                } else {
                    realmRoles.add(role.getValue());
                }
            });
            groupBuilder.addAllClientRoles(clientRoles).addAllRealmRoles(realmRoles);
        }
        ArrayList attributeList = new ArrayList();
        HashMap atrMap = new HashMap();
        if (group.getGroupAttribute() != null && !group.getGroupAttribute().isEmpty()) {
            group.getGroupAttribute().forEach(atr -> {
                atrMap.computeIfAbsent(atr.getKeyValue(), k -> new ArrayList());
                ((List)atrMap.get(atr.getKeyValue())).add(atr.getValue());
            });
        }
        atrMap.keySet().forEach(key -> {
            org.apache.custos.core.user.profile.api.GroupAttribute attribute = org.apache.custos.core.user.profile.api.GroupAttribute.newBuilder().setKey((String)key).addAllValue((Iterable)atrMap.get(key)).build();
            attributeList.add(attribute);
        });
        return groupBuilder.addAllAttributes(attributeList).build();
    }

    public static Group setParentGroupMembership(Group parent, Group child) {
        GroupToGroupMembership groupToGroupMembership = new GroupToGroupMembership();
        groupToGroupMembership.setChild(child);
        groupToGroupMembership.setParent(parent);
        groupToGroupMembership.setTenantId(child.getTenantId());
        HashSet<GroupToGroupMembership> groupList = new HashSet<GroupToGroupMembership>();
        groupList.add(groupToGroupMembership);
        child.setParentGroups(groupList);
        return child;
    }

    public static GroupToGroupMembership groupToGroupMembership(Group child, Group parent) {
        GroupToGroupMembership groupToGroupMembership = new GroupToGroupMembership();
        groupToGroupMembership.setChild(child);
        groupToGroupMembership.setParent(parent);
        groupToGroupMembership.setTenantId(child.getTenantId());
        return groupToGroupMembership;
    }
}

