/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.event.consumers;

import com.couchbase.client.core.event.CouchbaseEvent;
import com.couchbase.client.core.logging.CouchbaseLogLevel;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.utils.Events;
import rx.Subscriber;

public class LoggingConsumer
extends Subscriber<CouchbaseEvent> {
    public static final OutputFormat DEFAULT_FORMAT = OutputFormat.JSON;
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(LoggingConsumer.class);
    private final CouchbaseLogLevel level;
    private final OutputFormat outputFormat;

    private LoggingConsumer(CouchbaseLogLevel level, OutputFormat outputFormat) {
        this.level = level;
        this.outputFormat = outputFormat;
    }

    public static LoggingConsumer create() {
        return LoggingConsumer.create(CouchbaseLogLevel.INFO, DEFAULT_FORMAT);
    }

    public static LoggingConsumer create(CouchbaseLogLevel level, OutputFormat outputFormat) {
        return new LoggingConsumer(level, outputFormat);
    }

    public void onCompleted() {
        LOGGER.trace("Event stream completed in logging consumer.");
    }

    public void onError(Throwable ex) {
        LOGGER.warn("Received error in logging consumer.", ex);
    }

    public void onNext(CouchbaseEvent event) {
        try {
            switch (this.outputFormat) {
                case JSON: {
                    LOGGER.log(this.level, Events.toJson(event, false));
                    break;
                }
                case JSON_PRETTY: {
                    LOGGER.log(this.level, Events.toJson(event, true));
                    break;
                }
                case TO_STRING: {
                    LOGGER.log(this.level, event.toString());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported output format: " + this.outputFormat.toString());
                }
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Received error while logging event in logging consumer.", ex);
        }
    }

    public static enum OutputFormat {
        JSON,
        JSON_PRETTY,
        TO_STRING;

    }
}

