/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.result.fields;

import java.io.PrintWriter;
import java.util.List;
import org.apache.asterix.api.http.server.ResultUtil;
import org.apache.asterix.app.message.ExecuteStatementResponseMessage;
import org.apache.asterix.app.result.ResponsePrinter;
import org.apache.asterix.app.result.ResultReader;
import org.apache.asterix.common.api.IApplicationContext;
import org.apache.asterix.common.api.IResponseFieldPrinter;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.translator.IStatementExecutor;
import org.apache.asterix.translator.SessionOutput;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.result.IResultSet;
import org.apache.hyracks.api.result.ResultSetId;

public class NcResultPrinter
implements IResponseFieldPrinter {
    private final IStatementExecutor.ResultDelivery delivery;
    private final ExecuteStatementResponseMessage responseMsg;
    private final IApplicationContext appCtx;
    private final IResultSet resultSet;
    private final SessionOutput sessionOutput;
    private final IStatementExecutor.Stats stats;

    public NcResultPrinter(IApplicationContext appCtx, ExecuteStatementResponseMessage responseMsg, IResultSet resultSet, IStatementExecutor.ResultDelivery delivery, SessionOutput sessionOutput, IStatementExecutor.Stats stats) {
        this.appCtx = appCtx;
        this.responseMsg = responseMsg;
        this.delivery = delivery;
        this.resultSet = resultSet;
        this.sessionOutput = sessionOutput;
        this.stats = stats;
    }

    public void print(PrintWriter pw) throws HyracksDataException {
        IStatementExecutor.ResultMetadata resultMetadata = this.responseMsg.getMetadata();
        List resultSets = resultMetadata.getResultSets();
        if (this.delivery == IStatementExecutor.ResultDelivery.IMMEDIATE && !resultSets.isEmpty()) {
            for (int i = 0; i < resultSets.size(); ++i) {
                Triple rsmd = (Triple)resultSets.get(i);
                ResultReader resultReader = new ResultReader(this.resultSet, (JobId)rsmd.getLeft(), (ResultSetId)rsmd.getMiddle());
                ResultUtil.printResults(this.appCtx, resultReader, this.sessionOutput, this.stats, (ARecordType)rsmd.getRight());
                if (i + 1 == resultSets.size()) continue;
                ResponsePrinter.printFieldSeparator(pw);
            }
        } else {
            pw.append(this.responseMsg.getResult());
        }
    }

    public String getName() {
        return "results";
    }
}

