/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.format;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.parquet.format.Encoding;
import org.apache.parquet.format.Statistics;
import shaded.parquet.org.apache.thrift.TBase;
import shaded.parquet.org.apache.thrift.TBaseHelper;
import shaded.parquet.org.apache.thrift.TException;
import shaded.parquet.org.apache.thrift.TFieldIdEnum;
import shaded.parquet.org.apache.thrift.meta_data.EnumMetaData;
import shaded.parquet.org.apache.thrift.meta_data.FieldMetaData;
import shaded.parquet.org.apache.thrift.meta_data.FieldValueMetaData;
import shaded.parquet.org.apache.thrift.meta_data.StructMetaData;
import shaded.parquet.org.apache.thrift.protocol.TCompactProtocol;
import shaded.parquet.org.apache.thrift.protocol.TField;
import shaded.parquet.org.apache.thrift.protocol.TProtocol;
import shaded.parquet.org.apache.thrift.protocol.TProtocolException;
import shaded.parquet.org.apache.thrift.protocol.TProtocolUtil;
import shaded.parquet.org.apache.thrift.protocol.TStruct;
import shaded.parquet.org.apache.thrift.transport.TIOStreamTransport;

public class DataPageHeaderV2
implements TBase<DataPageHeaderV2, _Fields>,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("DataPageHeaderV2");
    private static final TField NUM_VALUES_FIELD_DESC = new TField("num_values", 8, 1);
    private static final TField NUM_NULLS_FIELD_DESC = new TField("num_nulls", 8, 2);
    private static final TField NUM_ROWS_FIELD_DESC = new TField("num_rows", 8, 3);
    private static final TField ENCODING_FIELD_DESC = new TField("encoding", 8, 4);
    private static final TField DEFINITION_LEVELS_BYTE_LENGTH_FIELD_DESC = new TField("definition_levels_byte_length", 8, 5);
    private static final TField REPETITION_LEVELS_BYTE_LENGTH_FIELD_DESC = new TField("repetition_levels_byte_length", 8, 6);
    private static final TField IS_COMPRESSED_FIELD_DESC = new TField("is_compressed", 2, 7);
    private static final TField STATISTICS_FIELD_DESC = new TField("statistics", 12, 8);
    public int num_values;
    public int num_nulls;
    public int num_rows;
    public Encoding encoding;
    public int definition_levels_byte_length;
    public int repetition_levels_byte_length;
    public boolean is_compressed;
    public Statistics statistics;
    private static final int __NUM_VALUES_ISSET_ID = 0;
    private static final int __NUM_NULLS_ISSET_ID = 1;
    private static final int __NUM_ROWS_ISSET_ID = 2;
    private static final int __DEFINITION_LEVELS_BYTE_LENGTH_ISSET_ID = 3;
    private static final int __REPETITION_LEVELS_BYTE_LENGTH_ISSET_ID = 4;
    private static final int __IS_COMPRESSED_ISSET_ID = 5;
    private BitSet __isset_bit_vector = new BitSet(6);
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public DataPageHeaderV2() {
        this.is_compressed = true;
    }

    public DataPageHeaderV2(int num_values, int num_nulls, int num_rows, Encoding encoding, int definition_levels_byte_length, int repetition_levels_byte_length) {
        this();
        this.num_values = num_values;
        this.setNum_valuesIsSet(true);
        this.num_nulls = num_nulls;
        this.setNum_nullsIsSet(true);
        this.num_rows = num_rows;
        this.setNum_rowsIsSet(true);
        this.encoding = encoding;
        this.definition_levels_byte_length = definition_levels_byte_length;
        this.setDefinition_levels_byte_lengthIsSet(true);
        this.repetition_levels_byte_length = repetition_levels_byte_length;
        this.setRepetition_levels_byte_lengthIsSet(true);
    }

    public DataPageHeaderV2(DataPageHeaderV2 other) {
        this.__isset_bit_vector.clear();
        this.__isset_bit_vector.or(other.__isset_bit_vector);
        this.num_values = other.num_values;
        this.num_nulls = other.num_nulls;
        this.num_rows = other.num_rows;
        if (other.isSetEncoding()) {
            this.encoding = other.encoding;
        }
        this.definition_levels_byte_length = other.definition_levels_byte_length;
        this.repetition_levels_byte_length = other.repetition_levels_byte_length;
        this.is_compressed = other.is_compressed;
        if (other.isSetStatistics()) {
            this.statistics = new Statistics(other.statistics);
        }
    }

    public DataPageHeaderV2 deepCopy() {
        return new DataPageHeaderV2(this);
    }

    @Override
    public void clear() {
        this.setNum_valuesIsSet(false);
        this.num_values = 0;
        this.setNum_nullsIsSet(false);
        this.num_nulls = 0;
        this.setNum_rowsIsSet(false);
        this.num_rows = 0;
        this.encoding = null;
        this.setDefinition_levels_byte_lengthIsSet(false);
        this.definition_levels_byte_length = 0;
        this.setRepetition_levels_byte_lengthIsSet(false);
        this.repetition_levels_byte_length = 0;
        this.is_compressed = true;
        this.statistics = null;
    }

    public int getNum_values() {
        return this.num_values;
    }

    public DataPageHeaderV2 setNum_values(int num_values) {
        this.num_values = num_values;
        this.setNum_valuesIsSet(true);
        return this;
    }

    public void unsetNum_values() {
        this.__isset_bit_vector.clear(0);
    }

    public boolean isSetNum_values() {
        return this.__isset_bit_vector.get(0);
    }

    public void setNum_valuesIsSet(boolean value) {
        this.__isset_bit_vector.set(0, value);
    }

    public int getNum_nulls() {
        return this.num_nulls;
    }

    public DataPageHeaderV2 setNum_nulls(int num_nulls) {
        this.num_nulls = num_nulls;
        this.setNum_nullsIsSet(true);
        return this;
    }

    public void unsetNum_nulls() {
        this.__isset_bit_vector.clear(1);
    }

    public boolean isSetNum_nulls() {
        return this.__isset_bit_vector.get(1);
    }

    public void setNum_nullsIsSet(boolean value) {
        this.__isset_bit_vector.set(1, value);
    }

    public int getNum_rows() {
        return this.num_rows;
    }

    public DataPageHeaderV2 setNum_rows(int num_rows) {
        this.num_rows = num_rows;
        this.setNum_rowsIsSet(true);
        return this;
    }

    public void unsetNum_rows() {
        this.__isset_bit_vector.clear(2);
    }

    public boolean isSetNum_rows() {
        return this.__isset_bit_vector.get(2);
    }

    public void setNum_rowsIsSet(boolean value) {
        this.__isset_bit_vector.set(2, value);
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public DataPageHeaderV2 setEncoding(Encoding encoding) {
        this.encoding = encoding;
        return this;
    }

    public void unsetEncoding() {
        this.encoding = null;
    }

    public boolean isSetEncoding() {
        return this.encoding != null;
    }

    public void setEncodingIsSet(boolean value) {
        if (!value) {
            this.encoding = null;
        }
    }

    public int getDefinition_levels_byte_length() {
        return this.definition_levels_byte_length;
    }

    public DataPageHeaderV2 setDefinition_levels_byte_length(int definition_levels_byte_length) {
        this.definition_levels_byte_length = definition_levels_byte_length;
        this.setDefinition_levels_byte_lengthIsSet(true);
        return this;
    }

    public void unsetDefinition_levels_byte_length() {
        this.__isset_bit_vector.clear(3);
    }

    public boolean isSetDefinition_levels_byte_length() {
        return this.__isset_bit_vector.get(3);
    }

    public void setDefinition_levels_byte_lengthIsSet(boolean value) {
        this.__isset_bit_vector.set(3, value);
    }

    public int getRepetition_levels_byte_length() {
        return this.repetition_levels_byte_length;
    }

    public DataPageHeaderV2 setRepetition_levels_byte_length(int repetition_levels_byte_length) {
        this.repetition_levels_byte_length = repetition_levels_byte_length;
        this.setRepetition_levels_byte_lengthIsSet(true);
        return this;
    }

    public void unsetRepetition_levels_byte_length() {
        this.__isset_bit_vector.clear(4);
    }

    public boolean isSetRepetition_levels_byte_length() {
        return this.__isset_bit_vector.get(4);
    }

    public void setRepetition_levels_byte_lengthIsSet(boolean value) {
        this.__isset_bit_vector.set(4, value);
    }

    public boolean isIs_compressed() {
        return this.is_compressed;
    }

    public DataPageHeaderV2 setIs_compressed(boolean is_compressed) {
        this.is_compressed = is_compressed;
        this.setIs_compressedIsSet(true);
        return this;
    }

    public void unsetIs_compressed() {
        this.__isset_bit_vector.clear(5);
    }

    public boolean isSetIs_compressed() {
        return this.__isset_bit_vector.get(5);
    }

    public void setIs_compressedIsSet(boolean value) {
        this.__isset_bit_vector.set(5, value);
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    public DataPageHeaderV2 setStatistics(Statistics statistics) {
        this.statistics = statistics;
        return this;
    }

    public void unsetStatistics() {
        this.statistics = null;
    }

    public boolean isSetStatistics() {
        return this.statistics != null;
    }

    public void setStatisticsIsSet(boolean value) {
        if (!value) {
            this.statistics = null;
        }
    }

    @Override
    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case NUM_VALUES: {
                if (value == null) {
                    this.unsetNum_values();
                    break;
                }
                this.setNum_values((Integer)value);
                break;
            }
            case NUM_NULLS: {
                if (value == null) {
                    this.unsetNum_nulls();
                    break;
                }
                this.setNum_nulls((Integer)value);
                break;
            }
            case NUM_ROWS: {
                if (value == null) {
                    this.unsetNum_rows();
                    break;
                }
                this.setNum_rows((Integer)value);
                break;
            }
            case ENCODING: {
                if (value == null) {
                    this.unsetEncoding();
                    break;
                }
                this.setEncoding((Encoding)value);
                break;
            }
            case DEFINITION_LEVELS_BYTE_LENGTH: {
                if (value == null) {
                    this.unsetDefinition_levels_byte_length();
                    break;
                }
                this.setDefinition_levels_byte_length((Integer)value);
                break;
            }
            case REPETITION_LEVELS_BYTE_LENGTH: {
                if (value == null) {
                    this.unsetRepetition_levels_byte_length();
                    break;
                }
                this.setRepetition_levels_byte_length((Integer)value);
                break;
            }
            case IS_COMPRESSED: {
                if (value == null) {
                    this.unsetIs_compressed();
                    break;
                }
                this.setIs_compressed((Boolean)value);
                break;
            }
            case STATISTICS: {
                if (value == null) {
                    this.unsetStatistics();
                    break;
                }
                this.setStatistics((Statistics)value);
            }
        }
    }

    @Override
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case NUM_VALUES: {
                return this.getNum_values();
            }
            case NUM_NULLS: {
                return this.getNum_nulls();
            }
            case NUM_ROWS: {
                return this.getNum_rows();
            }
            case ENCODING: {
                return this.getEncoding();
            }
            case DEFINITION_LEVELS_BYTE_LENGTH: {
                return this.getDefinition_levels_byte_length();
            }
            case REPETITION_LEVELS_BYTE_LENGTH: {
                return this.getRepetition_levels_byte_length();
            }
            case IS_COMPRESSED: {
                return this.isIs_compressed();
            }
            case STATISTICS: {
                return this.getStatistics();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case NUM_VALUES: {
                return this.isSetNum_values();
            }
            case NUM_NULLS: {
                return this.isSetNum_nulls();
            }
            case NUM_ROWS: {
                return this.isSetNum_rows();
            }
            case ENCODING: {
                return this.isSetEncoding();
            }
            case DEFINITION_LEVELS_BYTE_LENGTH: {
                return this.isSetDefinition_levels_byte_length();
            }
            case REPETITION_LEVELS_BYTE_LENGTH: {
                return this.isSetRepetition_levels_byte_length();
            }
            case IS_COMPRESSED: {
                return this.isSetIs_compressed();
            }
            case STATISTICS: {
                return this.isSetStatistics();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof DataPageHeaderV2) {
            return this.equals((DataPageHeaderV2)that);
        }
        return false;
    }

    public boolean equals(DataPageHeaderV2 that) {
        if (that == null) {
            return false;
        }
        boolean this_present_num_values = true;
        boolean that_present_num_values = true;
        if (this_present_num_values || that_present_num_values) {
            if (!this_present_num_values || !that_present_num_values) {
                return false;
            }
            if (this.num_values != that.num_values) {
                return false;
            }
        }
        boolean this_present_num_nulls = true;
        boolean that_present_num_nulls = true;
        if (this_present_num_nulls || that_present_num_nulls) {
            if (!this_present_num_nulls || !that_present_num_nulls) {
                return false;
            }
            if (this.num_nulls != that.num_nulls) {
                return false;
            }
        }
        boolean this_present_num_rows = true;
        boolean that_present_num_rows = true;
        if (this_present_num_rows || that_present_num_rows) {
            if (!this_present_num_rows || !that_present_num_rows) {
                return false;
            }
            if (this.num_rows != that.num_rows) {
                return false;
            }
        }
        boolean this_present_encoding = this.isSetEncoding();
        boolean that_present_encoding = that.isSetEncoding();
        if (this_present_encoding || that_present_encoding) {
            if (!this_present_encoding || !that_present_encoding) {
                return false;
            }
            if (!this.encoding.equals(that.encoding)) {
                return false;
            }
        }
        boolean this_present_definition_levels_byte_length = true;
        boolean that_present_definition_levels_byte_length = true;
        if (this_present_definition_levels_byte_length || that_present_definition_levels_byte_length) {
            if (!this_present_definition_levels_byte_length || !that_present_definition_levels_byte_length) {
                return false;
            }
            if (this.definition_levels_byte_length != that.definition_levels_byte_length) {
                return false;
            }
        }
        boolean this_present_repetition_levels_byte_length = true;
        boolean that_present_repetition_levels_byte_length = true;
        if (this_present_repetition_levels_byte_length || that_present_repetition_levels_byte_length) {
            if (!this_present_repetition_levels_byte_length || !that_present_repetition_levels_byte_length) {
                return false;
            }
            if (this.repetition_levels_byte_length != that.repetition_levels_byte_length) {
                return false;
            }
        }
        boolean this_present_is_compressed = this.isSetIs_compressed();
        boolean that_present_is_compressed = that.isSetIs_compressed();
        if (this_present_is_compressed || that_present_is_compressed) {
            if (!this_present_is_compressed || !that_present_is_compressed) {
                return false;
            }
            if (this.is_compressed != that.is_compressed) {
                return false;
            }
        }
        boolean this_present_statistics = this.isSetStatistics();
        boolean that_present_statistics = that.isSetStatistics();
        if (this_present_statistics || that_present_statistics) {
            if (!this_present_statistics || !that_present_statistics) {
                return false;
            }
            if (!this.statistics.equals(that.statistics)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        boolean present_num_values = true;
        builder.append(present_num_values);
        if (present_num_values) {
            builder.append(this.num_values);
        }
        boolean present_num_nulls = true;
        builder.append(present_num_nulls);
        if (present_num_nulls) {
            builder.append(this.num_nulls);
        }
        boolean present_num_rows = true;
        builder.append(present_num_rows);
        if (present_num_rows) {
            builder.append(this.num_rows);
        }
        boolean present_encoding = this.isSetEncoding();
        builder.append(present_encoding);
        if (present_encoding) {
            builder.append(this.encoding.getValue());
        }
        boolean present_definition_levels_byte_length = true;
        builder.append(present_definition_levels_byte_length);
        if (present_definition_levels_byte_length) {
            builder.append(this.definition_levels_byte_length);
        }
        boolean present_repetition_levels_byte_length = true;
        builder.append(present_repetition_levels_byte_length);
        if (present_repetition_levels_byte_length) {
            builder.append(this.repetition_levels_byte_length);
        }
        boolean present_is_compressed = this.isSetIs_compressed();
        builder.append(present_is_compressed);
        if (present_is_compressed) {
            builder.append(this.is_compressed);
        }
        boolean present_statistics = this.isSetStatistics();
        builder.append(present_statistics);
        if (present_statistics) {
            builder.append((Object)this.statistics);
        }
        return builder.toHashCode();
    }

    @Override
    public int compareTo(DataPageHeaderV2 other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        DataPageHeaderV2 typedOther = other;
        lastComparison = Boolean.valueOf(this.isSetNum_values()).compareTo(typedOther.isSetNum_values());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetNum_values() && (lastComparison = TBaseHelper.compareTo(this.num_values, typedOther.num_values)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetNum_nulls()).compareTo(typedOther.isSetNum_nulls());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetNum_nulls() && (lastComparison = TBaseHelper.compareTo(this.num_nulls, typedOther.num_nulls)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetNum_rows()).compareTo(typedOther.isSetNum_rows());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetNum_rows() && (lastComparison = TBaseHelper.compareTo(this.num_rows, typedOther.num_rows)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetEncoding()).compareTo(typedOther.isSetEncoding());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetEncoding() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.encoding), (Comparable)((Object)typedOther.encoding))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDefinition_levels_byte_length()).compareTo(typedOther.isSetDefinition_levels_byte_length());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDefinition_levels_byte_length() && (lastComparison = TBaseHelper.compareTo(this.definition_levels_byte_length, typedOther.definition_levels_byte_length)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetRepetition_levels_byte_length()).compareTo(typedOther.isSetRepetition_levels_byte_length());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRepetition_levels_byte_length() && (lastComparison = TBaseHelper.compareTo(this.repetition_levels_byte_length, typedOther.repetition_levels_byte_length)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetIs_compressed()).compareTo(typedOther.isSetIs_compressed());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetIs_compressed() && (lastComparison = TBaseHelper.compareTo(this.is_compressed, typedOther.is_compressed)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetStatistics()).compareTo(typedOther.isSetStatistics());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetStatistics() && (lastComparison = TBaseHelper.compareTo(this.statistics, typedOther.statistics)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin();
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 8) {
                        this.num_values = iprot.readI32();
                        this.setNum_valuesIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 2: {
                    if (field.type == 8) {
                        this.num_nulls = iprot.readI32();
                        this.setNum_nullsIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 3: {
                    if (field.type == 8) {
                        this.num_rows = iprot.readI32();
                        this.setNum_rowsIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 4: {
                    if (field.type == 8) {
                        this.encoding = Encoding.findByValue(iprot.readI32());
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 5: {
                    if (field.type == 8) {
                        this.definition_levels_byte_length = iprot.readI32();
                        this.setDefinition_levels_byte_lengthIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 6: {
                    if (field.type == 8) {
                        this.repetition_levels_byte_length = iprot.readI32();
                        this.setRepetition_levels_byte_lengthIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 7: {
                    if (field.type == 2) {
                        this.is_compressed = iprot.readBool();
                        this.setIs_compressedIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 8: {
                    if (field.type == 12) {
                        this.statistics = new Statistics();
                        this.statistics.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        if (!this.isSetNum_values()) {
            throw new TProtocolException("Required field 'num_values' was not found in serialized data! Struct: " + this.toString());
        }
        if (!this.isSetNum_nulls()) {
            throw new TProtocolException("Required field 'num_nulls' was not found in serialized data! Struct: " + this.toString());
        }
        if (!this.isSetNum_rows()) {
            throw new TProtocolException("Required field 'num_rows' was not found in serialized data! Struct: " + this.toString());
        }
        if (!this.isSetDefinition_levels_byte_length()) {
            throw new TProtocolException("Required field 'definition_levels_byte_length' was not found in serialized data! Struct: " + this.toString());
        }
        if (!this.isSetRepetition_levels_byte_length()) {
            throw new TProtocolException("Required field 'repetition_levels_byte_length' was not found in serialized data! Struct: " + this.toString());
        }
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(NUM_VALUES_FIELD_DESC);
        oprot.writeI32(this.num_values);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(NUM_NULLS_FIELD_DESC);
        oprot.writeI32(this.num_nulls);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(NUM_ROWS_FIELD_DESC);
        oprot.writeI32(this.num_rows);
        oprot.writeFieldEnd();
        if (this.encoding != null) {
            oprot.writeFieldBegin(ENCODING_FIELD_DESC);
            oprot.writeI32(this.encoding.getValue());
            oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(DEFINITION_LEVELS_BYTE_LENGTH_FIELD_DESC);
        oprot.writeI32(this.definition_levels_byte_length);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(REPETITION_LEVELS_BYTE_LENGTH_FIELD_DESC);
        oprot.writeI32(this.repetition_levels_byte_length);
        oprot.writeFieldEnd();
        if (this.isSetIs_compressed()) {
            oprot.writeFieldBegin(IS_COMPRESSED_FIELD_DESC);
            oprot.writeBool(this.is_compressed);
            oprot.writeFieldEnd();
        }
        if (this.statistics != null && this.isSetStatistics()) {
            oprot.writeFieldBegin(STATISTICS_FIELD_DESC);
            this.statistics.write(oprot);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DataPageHeaderV2(");
        boolean first = true;
        sb.append("num_values:");
        sb.append(this.num_values);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("num_nulls:");
        sb.append(this.num_nulls);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("num_rows:");
        sb.append(this.num_rows);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("encoding:");
        if (this.encoding == null) {
            sb.append("null");
        } else {
            sb.append(this.encoding);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("definition_levels_byte_length:");
        sb.append(this.definition_levels_byte_length);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("repetition_levels_byte_length:");
        sb.append(this.repetition_levels_byte_length);
        first = false;
        if (this.isSetIs_compressed()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("is_compressed:");
            sb.append(this.is_compressed);
            first = false;
        }
        if (this.isSetStatistics()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("statistics:");
            if (this.statistics == null) {
                sb.append("null");
            } else {
                sb.append(this.statistics);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.encoding == null) {
            throw new TProtocolException("Required field 'encoding' was not present! Struct: " + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bit_vector = new BitSet(1);
            this.read(new TCompactProtocol(new TIOStreamTransport(in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.NUM_VALUES, new FieldMetaData("num_values", 1, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.NUM_NULLS, new FieldMetaData("num_nulls", 1, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.NUM_ROWS, new FieldMetaData("num_rows", 1, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.ENCODING, new FieldMetaData("encoding", 1, new EnumMetaData(16, Encoding.class)));
        tmpMap.put(_Fields.DEFINITION_LEVELS_BYTE_LENGTH, new FieldMetaData("definition_levels_byte_length", 1, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.REPETITION_LEVELS_BYTE_LENGTH, new FieldMetaData("repetition_levels_byte_length", 1, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.IS_COMPRESSED, new FieldMetaData("is_compressed", 2, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.STATISTICS, new FieldMetaData("statistics", 2, new StructMetaData(12, Statistics.class)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(DataPageHeaderV2.class, metaDataMap);
    }

    public static enum _Fields implements TFieldIdEnum
    {
        NUM_VALUES(1, "num_values"),
        NUM_NULLS(2, "num_nulls"),
        NUM_ROWS(3, "num_rows"),
        ENCODING(4, "encoding"),
        DEFINITION_LEVELS_BYTE_LENGTH(5, "definition_levels_byte_length"),
        REPETITION_LEVELS_BYTE_LENGTH(6, "repetition_levels_byte_length"),
        IS_COMPRESSED(7, "is_compressed"),
        STATISTICS(8, "statistics");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return NUM_VALUES;
                }
                case 2: {
                    return NUM_NULLS;
                }
                case 3: {
                    return NUM_ROWS;
                }
                case 4: {
                    return ENCODING;
                }
                case 5: {
                    return DEFINITION_LEVELS_BYTE_LENGTH;
                }
                case 6: {
                    return REPETITION_LEVELS_BYTE_LENGTH;
                }
                case 7: {
                    return IS_COMPRESSED;
                }
                case 8: {
                    return STATISTICS;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

