/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.typecomputer.impl;

import org.apache.asterix.om.typecomputer.base.AbstractResultTypeComputer;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.ConstantExpressionUtil;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;

public class FieldAccessByNameResultType
extends AbstractResultTypeComputer {
    public static final FieldAccessByNameResultType INSTANCE = new FieldAccessByNameResultType();

    private FieldAccessByNameResultType() {
    }

    @Override
    protected IAType getResultType(ILogicalExpression expr, IAType ... strippedInputTypes) throws AlgebricksException {
        IAType firstArgType = strippedInputTypes[0];
        if (firstArgType.getTypeTag() != ATypeTag.OBJECT) {
            return BuiltinType.ANY;
        }
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)expr;
        String fieldName = ConstantExpressionUtil.getStringArgument(funcExpr, 1);
        if (fieldName == null) {
            return BuiltinType.ANY;
        }
        ARecordType recType = (ARecordType)firstArgType;
        IAType fieldType = recType.getFieldType(fieldName);
        return fieldType == null ? BuiltinType.ANY : fieldType;
    }
}

