/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.common;

import java.util.Arrays;

public class DoubleArray {
    private static final int SIZE = 1;
    private double[] data = new double[1];
    private int length = 0;

    public void add(double d) {
        if (this.length == this.data.length) {
            this.data = Arrays.copyOf(this.data, this.data.length << 1);
        }
        this.data[this.length++] = d;
    }

    public double[] get() {
        return this.data;
    }

    public double get(int i) {
        return this.data[i];
    }

    public int length() {
        return this.length;
    }

    public void reset() {
        this.length = 0;
    }

    public void sort() {
        this.sort(0, this.length);
    }

    public void sort(int start, int end) {
        Arrays.sort(this.data, start, end);
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append('[');
        for (int i = 0; i < this.length; ++i) {
            out.append(this.data[i]);
            if (i >= this.length - 1) continue;
            out.append(',');
            out.append(' ');
        }
        out.append(']');
        return out.toString();
    }
}

