/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.job;

import java.io.Serializable;
import org.apache.hyracks.api.dataflow.TaskAttemptId;
import org.apache.hyracks.api.partitions.PartitionId;
import org.apache.hyracks.control.common.job.PartitionState;

public class PartitionDescriptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final PartitionId pid;
    private final String nodeId;
    private final TaskAttemptId producingTaskAttemptId;
    private final boolean reusable;
    private PartitionState state;

    public PartitionDescriptor(PartitionId pid, String nodeId, TaskAttemptId producingTaskAttemptId, boolean reusable) {
        this.pid = pid;
        this.nodeId = nodeId;
        this.producingTaskAttemptId = producingTaskAttemptId;
        this.reusable = reusable;
    }

    public PartitionId getPartitionId() {
        return this.pid;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public TaskAttemptId getProducingTaskAttemptId() {
        return this.producingTaskAttemptId;
    }

    public PartitionState getState() {
        return this.state;
    }

    public void setState(PartitionState state) {
        this.state = state;
    }

    public boolean isReusable() {
        return this.reusable;
    }

    public String toString() {
        return "[" + this.pid + ":" + this.nodeId + ":" + this.producingTaskAttemptId + (this.reusable ? "reusable" : "non-reusable") + " " + this.state + "]";
    }
}

