/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.work;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.result.ResultJobRecord;
import org.apache.hyracks.api.result.ResultSetId;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.common.work.IResultCallback;
import org.apache.hyracks.control.common.work.SynchronizableWork;

public class GetResultStatusWork
extends SynchronizableWork {
    private final ClusterControllerService ccs;
    private final JobId jobId;
    private final ResultSetId rsId;
    private final IResultCallback<ResultJobRecord.Status> callback;

    public GetResultStatusWork(ClusterControllerService ccs, JobId jobId, ResultSetId rsId, IResultCallback<ResultJobRecord.Status> callback) {
        this.ccs = ccs;
        this.jobId = jobId;
        this.rsId = rsId;
        this.callback = callback;
    }

    public void doRun() {
        try {
            ResultJobRecord.Status status = this.ccs.getResultDirectoryService().getResultStatus(this.jobId, this.rsId);
            this.callback.setValue((Object)status);
        }
        catch (HyracksDataException e) {
            this.callback.setException((Exception)((Object)e));
        }
    }

    public String toString() {
        return this.getName() + ": JobId@" + this.jobId + " ResultSetId@" + this.rsId;
    }
}

