/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.cbo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.annotations.IndexedNLJoinExpressionAnnotation;
import org.apache.asterix.common.annotations.SkipSecondaryIndexSearchExpressionAnnotation;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.optimizer.rules.cbo.JoinEnum;
import org.apache.asterix.optimizer.rules.cbo.PlanNode;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.BroadcastExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.HashJoinExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.IPlanPrettyPrinter;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.algebricks.core.rewriter.base.PhysicalOptimizationConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EnumerateJoinsRule
implements IAlgebraicRewriteRule {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final JoinEnum joinEnum;

    public EnumerateJoinsRule(JoinEnum joinEnum) {
        this.joinEnum = joinEnum;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        int cheapestPlan;
        boolean cboMode = this.getCBOMode(context);
        boolean cboTestMode = this.getCBOTestMode(context);
        if (!cboMode && !cboTestMode) {
            return false;
        }
        ILogicalOperator op = (ILogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.INNERJOIN && op.getOperatorTag() != LogicalOperatorTag.DISTRIBUTE_RESULT) {
            return false;
        }
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, op)) {
            return false;
        }
        ArrayList<ILogicalOperator> joinOps = new ArrayList<ILogicalOperator>();
        ArrayList<ILogicalOperator> internalEdges = new ArrayList<ILogicalOperator>();
        HashMap<EmptyTupleSourceOperator, ILogicalOperator> joinLeafInputsHashMap = new HashMap<EmptyTupleSourceOperator, ILogicalOperator>();
        ArrayList<Pair<EmptyTupleSourceOperator, DataSourceScanOperator>> emptyTupleAndDataSourceOps = new ArrayList<Pair<EmptyTupleSourceOperator, DataSourceScanOperator>>();
        HashMap<DataSourceScanOperator, EmptyTupleSourceOperator> dataSourceEmptyTupleHashMap = new HashMap<DataSourceScanOperator, EmptyTupleSourceOperator>();
        IPlanPrettyPrinter pp = context.getPrettyPrinter();
        EnumerateJoinsRule.printPlan(pp, (AbstractLogicalOperator)op, "Original Whole plan1");
        boolean canTransform = this.getJoinOpsAndLeafInputs(op, emptyTupleAndDataSourceOps, joinLeafInputsHashMap, dataSourceEmptyTupleHashMap, internalEdges, joinOps);
        if (!canTransform) {
            return false;
        }
        if (emptyTupleAndDataSourceOps.size() != joinLeafInputsHashMap.size()) {
            throw new IllegalStateException("ETS " + emptyTupleAndDataSourceOps.size() + " != LI " + joinLeafInputsHashMap.size());
        }
        EnumerateJoinsRule.printPlan(pp, (AbstractLogicalOperator)op, "Original Whole plan2");
        int numberOfFromTerms = emptyTupleAndDataSourceOps.size();
        this.joinEnum.initEnum((AbstractLogicalOperator)op, cboMode, cboTestMode, numberOfFromTerms, emptyTupleAndDataSourceOps, joinLeafInputsHashMap, dataSourceEmptyTupleHashMap, internalEdges, joinOps, context);
        if (cboMode && !this.doAllDataSourcesHaveSamples(emptyTupleAndDataSourceOps, context)) {
            return false;
        }
        if (internalEdges.size() > 0) {
            this.pushAssignsIntoLeafInputs(joinLeafInputsHashMap, internalEdges);
        }
        if ((cheapestPlan = this.joinEnum.enumerateJoins()) == PlanNode.NO_PLAN) {
            return false;
        }
        PlanNode cheapestPlanNode = this.joinEnum.allPlans.get(cheapestPlan);
        if (numberOfFromTerms > 1) {
            this.buildNewTree(cheapestPlanNode, joinLeafInputsHashMap, joinOps, new MutableInt(0), context);
            EnumerateJoinsRule.printPlan(pp, (AbstractLogicalOperator)joinOps.get(0), "New Whole Plan after buildNewTree 1");
            ILogicalOperator root = this.addConstantInternalEdgesAtTheTop((ILogicalOperator)joinOps.get(0), internalEdges);
            EnumerateJoinsRule.printPlan(pp, (AbstractLogicalOperator)joinOps.get(0), "New Whole Plan after buildNewTree 2");
            EnumerateJoinsRule.printPlan(pp, (AbstractLogicalOperator)root, "New Whole Plan after buildNewTree");
            opRef.setValue((Object)root);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("---------------------------- Printing Leaf Inputs");
                this.printLeafPlans(pp, joinLeafInputsHashMap);
                for (int i = joinOps.size() - 1; i >= 0; --i) {
                    EnumerateJoinsRule.printPlan(pp, (AbstractLogicalOperator)joinOps.get(i), "join " + i);
                }
                EnumerateJoinsRule.printPlan(pp, (AbstractLogicalOperator)joinOps.get(0), "New Whole Plan");
                EnumerateJoinsRule.printPlan(pp, (AbstractLogicalOperator)root, "New Whole Plan");
            }
            for (ILogicalOperator joinOp : joinOps) {
                context.addToDontApplySet((IAlgebraicRewriteRule)this, joinOp);
            }
        } else {
            this.buildNewTree(cheapestPlanNode, joinLeafInputsHashMap);
        }
        return true;
    }

    private boolean getCBOMode(IOptimizationContext context) {
        PhysicalOptimizationConfig physOptConfig = context.getPhysicalOptimizationConfig();
        return physOptConfig.getCBOMode();
    }

    private boolean getCBOTestMode(IOptimizationContext context) {
        PhysicalOptimizationConfig physOptConfig = context.getPhysicalOptimizationConfig();
        return physOptConfig.getCBOTestMode();
    }

    private Pair<EmptyTupleSourceOperator, DataSourceScanOperator> containsLeafInputOnly(ILogicalOperator op) {
        DataSourceScanOperator dataSourceOp = null;
        ILogicalOperator currentOp = op;
        while (currentOp.getInputs().size() == 1) {
            if (currentOp.getOperatorTag() == LogicalOperatorTag.DATASOURCESCAN) {
                if (dataSourceOp != null) {
                    return null;
                }
                dataSourceOp = (DataSourceScanOperator)currentOp;
            }
            currentOp = (ILogicalOperator)((Mutable)currentOp.getInputs().get(0)).getValue();
        }
        if (currentOp.getOperatorTag() == LogicalOperatorTag.EMPTYTUPLESOURCE) {
            return new Pair((Object)((EmptyTupleSourceOperator)currentOp), (Object)dataSourceOp);
        }
        return null;
    }

    private boolean onlyOneAssign(ILogicalOperator nextOp) {
        if (nextOp.getOperatorTag() != LogicalOperatorTag.ASSIGN) {
            return false;
        }
        List nextOpInputs = nextOp.getInputs();
        return ((ILogicalOperator)((Mutable)nextOpInputs.get(0)).getValue()).getOperatorTag() == LogicalOperatorTag.INNERJOIN;
    }

    private ILogicalOperator findSelectOrDataScan(ILogicalOperator op) {
        while (op.getInputs().size() <= 1) {
            LogicalOperatorTag tag = op.getOperatorTag();
            if (tag == LogicalOperatorTag.EMPTYTUPLESOURCE) {
                return null;
            }
            if (tag == LogicalOperatorTag.SELECT || tag == LogicalOperatorTag.DATASOURCESCAN) {
                return op;
            }
            op = (ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
        }
        return null;
    }

    private boolean getJoinOpsAndLeafInputs(ILogicalOperator op, List<Pair<EmptyTupleSourceOperator, DataSourceScanOperator>> emptyTupleAndDataSourceOps, HashMap<EmptyTupleSourceOperator, ILogicalOperator> joinLeafInputsHashMap, HashMap<DataSourceScanOperator, EmptyTupleSourceOperator> dataSourceEmptyTupleHashMap, List<ILogicalOperator> internalEdges, List<ILogicalOperator> joinOps) {
        if (op.getOperatorTag() == LogicalOperatorTag.LEFTOUTERJOIN) {
            return false;
        }
        if (op.getOperatorTag() == LogicalOperatorTag.INNERJOIN) {
            joinOps.add(op);
            for (int i = 0; i < 2; ++i) {
                ILogicalOperator nextOp = (ILogicalOperator)((Mutable)op.getInputs().get(i)).getValue();
                boolean canTransform = this.getJoinOpsAndLeafInputs(nextOp, emptyTupleAndDataSourceOps, joinLeafInputsHashMap, dataSourceEmptyTupleHashMap, internalEdges, joinOps);
                if (canTransform) continue;
                return false;
            }
        } else {
            Pair<EmptyTupleSourceOperator, DataSourceScanOperator> etsDataSource = this.containsLeafInputOnly(op);
            if (etsDataSource != null) {
                EmptyTupleSourceOperator etsOp = (EmptyTupleSourceOperator)etsDataSource.first;
                DataSourceScanOperator dataSourceOp = (DataSourceScanOperator)etsDataSource.second;
                emptyTupleAndDataSourceOps.add((Pair<EmptyTupleSourceOperator, DataSourceScanOperator>)new Pair((Object)etsOp, (Object)dataSourceOp));
                if (op.getOperatorTag().equals((Object)LogicalOperatorTag.DISTRIBUTE_RESULT)) {
                    ILogicalOperator selectOp = this.findSelectOrDataScan(op);
                    if (selectOp == null) {
                        return false;
                    }
                    joinLeafInputsHashMap.put(etsOp, selectOp);
                } else {
                    joinLeafInputsHashMap.put(etsOp, op);
                }
                dataSourceEmptyTupleHashMap.put(dataSourceOp, etsOp);
            } else if (this.onlyOneAssign(op)) {
                internalEdges.add(op);
                boolean canTransform = this.getJoinOpsAndLeafInputs((ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue(), emptyTupleAndDataSourceOps, joinLeafInputsHashMap, dataSourceEmptyTupleHashMap, internalEdges, joinOps);
                if (!canTransform) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private void addCardCostAnnotations(ILogicalOperator op, PlanNode plan) {
        op.getAnnotations().put("OUTPUT_CARDINALITY", (double)Math.round(plan.getJoinNode().getCardinality() * 100.0) / 100.0);
        op.getAnnotations().put("TOTAL_COST", (double)Math.round(plan.computeTotalCost() * 100.0) / 100.0);
        if (plan.IsScanNode()) {
            op.getAnnotations().put("INPUT_CARDINALITY", (double)Math.round(plan.getJoinNode().getOrigCardinality() * 100.0) / 100.0);
            op.getAnnotations().put("OP_COST", (double)Math.round(plan.computeOpCost() * 100.0) / 100.0);
        } else {
            op.getAnnotations().put("LEFT_EXCHANGE_COST", (double)Math.round(plan.getLeftExchangeCost().computeTotalCost() * 100.0) / 100.0);
            op.getAnnotations().put("RIGHT_EXCHANGE_COST", (double)Math.round(plan.getRightExchangeCost().computeTotalCost() * 100.0) / 100.0);
            op.getAnnotations().put("OP_COST", (double)Math.round(plan.computeOpCost() * 100.0) / 100.0);
        }
        if (op.getOperatorTag().equals((Object)LogicalOperatorTag.SELECT)) {
            op.getAnnotations().put("OP_COST", 0.0);
        }
    }

    private ILogicalOperator findDataSourceScanOperator(ILogicalOperator op) {
        ILogicalOperator origOp = op;
        while (op != null && op.getOperatorTag() != LogicalOperatorTag.EMPTYTUPLESOURCE) {
            if (op.getOperatorTag().equals((Object)LogicalOperatorTag.DATASOURCESCAN)) {
                return op;
            }
            op = (ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
        }
        return origOp;
    }

    private void removeJoinAnnotations(AbstractFunctionCallExpression afcExpr) {
        afcExpr.removeAnnotation(BroadcastExpressionAnnotation.class);
        afcExpr.removeAnnotation(IndexedNLJoinExpressionAnnotation.class);
        afcExpr.removeAnnotation(HashJoinExpressionAnnotation.class);
    }

    private void setAnnotation(AbstractFunctionCallExpression afcExpr, IExpressionAnnotation anno) {
        FunctionIdentifier fi = afcExpr.getFunctionIdentifier();
        List arguments = afcExpr.getArguments();
        if (fi.equals((Object)AlgebricksBuiltinFunctions.AND)) {
            for (Mutable iLogicalExpressionMutable : arguments) {
                ILogicalExpression argument = (ILogicalExpression)iLogicalExpressionMutable.getValue();
                AbstractFunctionCallExpression expr = (AbstractFunctionCallExpression)argument;
                expr.putAnnotation(anno);
            }
        } else {
            afcExpr.putAnnotation(anno);
        }
    }

    private int findInternalEdge(ILogicalOperator leafInput, List<ILogicalOperator> internalEdges) throws AlgebricksException {
        int i = -1;
        for (ILogicalOperator ie : internalEdges) {
            ++i;
            AssignOperator aOp = (AssignOperator)ie;
            ArrayList vars = new ArrayList();
            ((ILogicalExpression)((Mutable)aOp.getExpressions().get(0)).getValue()).getUsedVariables(vars);
            HashSet vars2 = new HashSet();
            VariableUtilities.getLiveVariables((ILogicalOperator)leafInput, vars2);
            if (!vars2.containsAll(vars)) continue;
            return i;
        }
        return -1;
    }

    private ILogicalOperator addAssignToLeafInput(ILogicalOperator leafInput, ILogicalOperator internalEdge) {
        ILogicalOperator root = leafInput;
        AssignOperator aOp = (AssignOperator)internalEdge;
        ((Mutable)aOp.getInputs().get(0)).setValue((Object)root);
        return aOp;
    }

    private void skipAllIndexes(PlanNode plan, ILogicalOperator leafInput) {
        if (plan.scanOp == PlanNode.ScanMethod.TABLE_SCAN && leafInput.getOperatorTag() == LogicalOperatorTag.SELECT) {
            SelectOperator selOper = (SelectOperator)leafInput;
            ILogicalExpression expr = (ILogicalExpression)selOper.getCondition().getValue();
            ArrayList conjs = new ArrayList();
            conjs.clear();
            if (expr.splitIntoConjuncts(conjs)) {
                conjs.remove(new MutableObject((Object)ConstantExpression.TRUE));
                for (Mutable conj : conjs) {
                    if (!((ILogicalExpression)conj.getValue()).getExpressionTag().equals((Object)LogicalExpressionTag.FUNCTION_CALL)) continue;
                    AbstractFunctionCallExpression afce = (AbstractFunctionCallExpression)conj.getValue();
                    afce.removeAnnotation(SkipSecondaryIndexSearchExpressionAnnotation.class);
                    afce.putAnnotation((IExpressionAnnotation)SkipSecondaryIndexSearchExpressionAnnotation.INSTANCE_ANY_INDEX);
                }
            } else if (expr.getExpressionTag().equals((Object)LogicalExpressionTag.FUNCTION_CALL)) {
                AbstractFunctionCallExpression afce = (AbstractFunctionCallExpression)expr;
                afce.removeAnnotation(SkipSecondaryIndexSearchExpressionAnnotation.class);
                afce.putAnnotation((IExpressionAnnotation)SkipSecondaryIndexSearchExpressionAnnotation.INSTANCE_ANY_INDEX);
            }
        }
    }

    private void buildNewTree(PlanNode plan, HashMap<EmptyTupleSourceOperator, ILogicalOperator> joinLeafInputsHashMap) {
        ILogicalOperator leftInput = joinLeafInputsHashMap.get(plan.getEmptyTupleSourceOp());
        this.skipAllIndexes(plan, leftInput);
        ILogicalOperator selOp = this.findSelectOrDataScan(leftInput);
        if (selOp != null) {
            this.addCardCostAnnotations(selOp, plan);
        }
        this.addCardCostAnnotations(this.findDataSourceScanOperator(leftInput), plan);
    }

    private void buildNewTree(PlanNode plan, HashMap<EmptyTupleSourceOperator, ILogicalOperator> joinLeafInputsHashMap, List<ILogicalOperator> joinOps, MutableInt totalNumberOfJoins, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator rightInput;
        ILogicalOperator selOp;
        ILogicalOperator leftInput;
        List<PlanNode> allPlans = this.joinEnum.getAllPlans();
        int leftIndex = plan.getLeftPlanIndex();
        int rightIndex = plan.getRightPlanIndex();
        PlanNode leftPlan = allPlans.get(leftIndex);
        PlanNode rightPlan = allPlans.get(rightIndex);
        ILogicalOperator joinOp = joinOps.get(totalNumberOfJoins.intValue());
        if (plan.IsJoinNode()) {
            AbstractBinaryJoinOperator abJoinOp = (AbstractBinaryJoinOperator)joinOp;
            ILogicalExpression expr = plan.getJoinExpr();
            abJoinOp.getCondition().setValue((Object)expr);
            if (plan.getJoinOp() == PlanNode.JoinMethod.INDEX_NESTED_LOOP_JOIN) {
                AbstractFunctionCallExpression afcExpr = (AbstractFunctionCallExpression)expr;
                this.removeJoinAnnotations(afcExpr);
                this.setAnnotation(afcExpr, (IExpressionAnnotation)IndexedNLJoinExpressionAnnotation.INSTANCE_ANY_INDEX);
            } else if (plan.getJoinOp() == PlanNode.JoinMethod.HYBRID_HASH_JOIN || plan.getJoinOp() == PlanNode.JoinMethod.BROADCAST_HASH_JOIN || plan.getJoinOp() == PlanNode.JoinMethod.CARTESIAN_PRODUCT_JOIN) {
                if (plan.getJoinOp() == PlanNode.JoinMethod.BROADCAST_HASH_JOIN) {
                    BroadcastExpressionAnnotation bcast = new BroadcastExpressionAnnotation(plan.side == HashJoinExpressionAnnotation.BuildSide.RIGHT ? BroadcastExpressionAnnotation.BroadcastSide.RIGHT : BroadcastExpressionAnnotation.BroadcastSide.LEFT);
                    AbstractFunctionCallExpression afcExpr = (AbstractFunctionCallExpression)expr;
                    this.removeJoinAnnotations(afcExpr);
                    this.setAnnotation(afcExpr, (IExpressionAnnotation)bcast);
                } else if (plan.getJoinOp() == PlanNode.JoinMethod.HYBRID_HASH_JOIN) {
                    HashJoinExpressionAnnotation hjAnnotation = new HashJoinExpressionAnnotation(plan.side);
                    AbstractFunctionCallExpression afcExpr = (AbstractFunctionCallExpression)expr;
                    this.removeJoinAnnotations(afcExpr);
                    this.setAnnotation(afcExpr, (IExpressionAnnotation)hjAnnotation);
                } else if (expr != ConstantExpression.TRUE) {
                    AbstractFunctionCallExpression afcExpr = (AbstractFunctionCallExpression)expr;
                    this.removeJoinAnnotations(afcExpr);
                }
            }
            this.addCardCostAnnotations(joinOp, plan);
        }
        if (leftPlan.IsScanNode()) {
            leftInput = joinLeafInputsHashMap.get(leftPlan.getEmptyTupleSourceOp());
            this.skipAllIndexes(leftPlan, leftInput);
            selOp = this.findSelectOrDataScan(leftInput);
            if (selOp != null) {
                this.addCardCostAnnotations(selOp, leftPlan);
            }
            ((Mutable)joinOp.getInputs().get(0)).setValue((Object)leftInput);
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)((Mutable)joinOp.getInputs().get(0)).getValue());
            this.addCardCostAnnotations(this.findDataSourceScanOperator(leftInput), leftPlan);
        } else {
            totalNumberOfJoins.increment();
            leftInput = joinOps.get(totalNumberOfJoins.intValue());
            ((Mutable)joinOp.getInputs().get(0)).setValue((Object)leftInput);
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)((Mutable)joinOp.getInputs().get(0)).getValue());
            this.buildNewTree(allPlans.get(leftIndex), joinLeafInputsHashMap, joinOps, totalNumberOfJoins, context);
        }
        if (rightPlan.IsScanNode()) {
            rightInput = joinLeafInputsHashMap.get(rightPlan.getEmptyTupleSourceOp());
            this.skipAllIndexes(rightPlan, rightInput);
            selOp = this.findSelectOrDataScan(rightInput);
            if (selOp != null) {
                this.addCardCostAnnotations(selOp, rightPlan);
            }
            ((Mutable)joinOp.getInputs().get(1)).setValue((Object)rightInput);
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)((Mutable)joinOp.getInputs().get(1)).getValue());
            this.addCardCostAnnotations(this.findDataSourceScanOperator(rightInput), rightPlan);
        } else {
            totalNumberOfJoins.increment();
            rightInput = joinOps.get(totalNumberOfJoins.intValue());
            ((Mutable)joinOp.getInputs().get(1)).setValue((Object)rightInput);
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)((Mutable)joinOp.getInputs().get(1)).getValue());
            this.buildNewTree(allPlans.get(rightIndex), joinLeafInputsHashMap, joinOps, totalNumberOfJoins, context);
        }
    }

    private ILogicalOperator addConstantInternalEdgesAtTheTop(ILogicalOperator op, List<ILogicalOperator> internalEdges) {
        if (internalEdges.size() == 0) {
            return op;
        }
        ILogicalOperator root = op;
        for (ILogicalOperator ie : internalEdges) {
            AssignOperator aOp = (AssignOperator)ie;
            ((Mutable)aOp.getInputs().get(0)).setValue((Object)root);
            root = aOp;
        }
        return root;
    }

    public static void printPlan(IPlanPrettyPrinter pp, AbstractLogicalOperator op, String text) throws AlgebricksException {
        if (LOGGER.isTraceEnabled()) {
            pp.reset();
            pp.printOperator(op, true, false);
            LOGGER.trace("---------------------------- {}\n{}\n----------------------------", (Object)text, (Object)pp);
        }
    }

    private void printLeafPlans(IPlanPrettyPrinter pp, HashMap<EmptyTupleSourceOperator, ILogicalOperator> joinLeafInputsHashMap) throws AlgebricksException {
        Iterator<Map.Entry<EmptyTupleSourceOperator, ILogicalOperator>> li = joinLeafInputsHashMap.entrySet().iterator();
        int i = 0;
        while (li.hasNext()) {
            Map.Entry<EmptyTupleSourceOperator, ILogicalOperator> pair = li.next();
            ILogicalOperator element = pair.getValue();
            EnumerateJoinsRule.printPlan(pp, (AbstractLogicalOperator)element, "Printing Leaf Input" + i);
            ++i;
        }
    }

    private void pushAssignsIntoLeafInputs(HashMap<EmptyTupleSourceOperator, ILogicalOperator> joinLeafInputsHashMap, List<ILogicalOperator> internalEdges) throws AlgebricksException {
        for (Map.Entry<EmptyTupleSourceOperator, ILogicalOperator> mapElement : joinLeafInputsHashMap.entrySet()) {
            ILogicalOperator joinLeafInput = mapElement.getValue();
            EmptyTupleSourceOperator ets = mapElement.getKey();
            int internalEdgeNumber = this.findInternalEdge(joinLeafInput, internalEdges);
            if (internalEdgeNumber == -1) continue;
            joinLeafInput = this.addAssignToLeafInput(joinLeafInput, internalEdges.get(internalEdgeNumber));
            joinLeafInputsHashMap.put(ets, joinLeafInput);
            internalEdges.remove(internalEdgeNumber);
        }
    }

    private boolean substituteVarOnce(ILogicalExpression exp, LogicalVariable oldVar, LogicalVariable newVar) {
        switch (exp.getExpressionTag()) {
            case FUNCTION_CALL: {
                AbstractFunctionCallExpression fun = (AbstractFunctionCallExpression)exp;
                for (int i = 0; i < fun.getArguments().size(); ++i) {
                    ILogicalExpression arg = (ILogicalExpression)((Mutable)fun.getArguments().get(i)).getValue();
                    if (!this.substituteVarOnce(arg, oldVar, newVar)) continue;
                    return true;
                }
                return false;
            }
            case VARIABLE: {
                VariableReferenceExpression varExpr = (VariableReferenceExpression)exp;
                if (varExpr.getVariableReference().equals((Object)oldVar)) {
                    varExpr.setVariable(newVar);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private boolean doAllDataSourcesHaveSamples(List<Pair<EmptyTupleSourceOperator, DataSourceScanOperator>> emptyTupleAndDataSourceOps, IOptimizationContext context) throws AlgebricksException {
        for (Pair<EmptyTupleSourceOperator, DataSourceScanOperator> emptyTupleAndDataSourceOp : emptyTupleAndDataSourceOps) {
            if (emptyTupleAndDataSourceOp.getSecond() == null) continue;
            DataSourceScanOperator scanOp = (DataSourceScanOperator)emptyTupleAndDataSourceOp.getSecond();
            Index index = this.joinEnum.getStatsHandle().findSampleIndex(scanOp, context);
            if (index != null) continue;
            return false;
        }
        return true;
    }
}

