/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.hdfs.protocol.ZoneReencryptionStatus;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.thirdparty.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class ReencryptionStatus {
    public static final Logger LOG = LoggerFactory.getLogger(ReencryptionStatus.class);
    public static final BatchedRemoteIterator.BatchedListEntries<ZoneReencryptionStatus> EMPTY_LIST = new BatchedRemoteIterator.BatchedListEntries((List)Lists.newArrayList(), false);
    private final TreeMap<Long, ZoneReencryptionStatus> zoneStatuses;
    private long zonesReencrypted;

    public ReencryptionStatus() {
        this.zoneStatuses = new TreeMap();
    }

    @VisibleForTesting
    public ReencryptionStatus(ReencryptionStatus rhs) {
        if (rhs != null) {
            this.zoneStatuses = new TreeMap<Long, ZoneReencryptionStatus>((SortedMap<Long, ZoneReencryptionStatus>)rhs.zoneStatuses);
            this.zonesReencrypted = rhs.zonesReencrypted;
        } else {
            this.zoneStatuses = new TreeMap();
        }
    }

    @VisibleForTesting
    public void resetMetrics() {
        this.zonesReencrypted = 0L;
        for (Map.Entry<Long, ZoneReencryptionStatus> entry : this.zoneStatuses.entrySet()) {
            entry.getValue().resetMetrics();
        }
    }

    public ZoneReencryptionStatus getZoneStatus(Long zondId) {
        return this.zoneStatuses.get(zondId);
    }

    public void markZoneForRetry(Long zoneId) {
        ZoneReencryptionStatus zs = this.zoneStatuses.get(zoneId);
        Preconditions.checkNotNull((Object)zs, (Object)("Cannot find zone " + zoneId));
        LOG.info("Zone {} will retry re-encryption", (Object)zoneId);
        zs.setState(ZoneReencryptionStatus.State.Submitted);
    }

    public void markZoneStarted(Long zoneId) {
        ZoneReencryptionStatus zs = this.zoneStatuses.get(zoneId);
        Preconditions.checkNotNull((Object)zs, (Object)("Cannot find zone " + zoneId));
        LOG.info("Zone {} starts re-encryption processing", (Object)zoneId);
        zs.setState(ZoneReencryptionStatus.State.Processing);
    }

    public void markZoneCompleted(Long zoneId) {
        ZoneReencryptionStatus zs = this.zoneStatuses.get(zoneId);
        Preconditions.checkNotNull((Object)zs, (Object)("Cannot find zone " + zoneId));
        LOG.info("Zone {} completed re-encryption.", (Object)zoneId);
        zs.setState(ZoneReencryptionStatus.State.Completed);
        ++this.zonesReencrypted;
    }

    public Long getNextUnprocessedZone() {
        for (Map.Entry<Long, ZoneReencryptionStatus> entry : this.zoneStatuses.entrySet()) {
            if (entry.getValue().getState() != ZoneReencryptionStatus.State.Submitted) continue;
            return entry.getKey();
        }
        return null;
    }

    public boolean hasRunningZone(Long zoneId) {
        return this.zoneStatuses.containsKey(zoneId) && this.zoneStatuses.get(zoneId).getState() != ZoneReencryptionStatus.State.Completed;
    }

    private boolean addZoneIfNecessary(Long zoneId, String name, HdfsProtos.ReencryptionInfoProto reProto) {
        if (!this.zoneStatuses.containsKey(zoneId)) {
            LOG.debug("Adding zone {} for re-encryption status", (Object)zoneId);
            Preconditions.checkNotNull((Object)reProto);
            ZoneReencryptionStatus.Builder builder = new ZoneReencryptionStatus.Builder();
            builder.id(zoneId).zoneName(name).ezKeyVersionName(reProto.getEzKeyVersionName()).submissionTime(reProto.getSubmissionTime()).canceled(reProto.getCanceled()).filesReencrypted(reProto.getNumReencrypted()).fileReencryptionFailures(reProto.getNumFailures());
            if (reProto.hasCompletionTime()) {
                builder.completionTime(reProto.getCompletionTime());
                builder.state(ZoneReencryptionStatus.State.Completed);
                ++this.zonesReencrypted;
            } else {
                builder.state(ZoneReencryptionStatus.State.Submitted);
            }
            if (reProto.hasLastFile()) {
                builder.lastCheckpointFile(reProto.getLastFile());
            }
            return this.zoneStatuses.put(zoneId, builder.build()) == null;
        }
        return false;
    }

    public void updateZoneStatus(Long zoneId, String zonePath, HdfsProtos.ReencryptionInfoProto reProto) {
        Preconditions.checkArgument((zoneId != null ? 1 : 0) != 0, (Object)"zoneId can't be null");
        if (this.addZoneIfNecessary(zoneId, zonePath, reProto)) {
            return;
        }
        ZoneReencryptionStatus zs = this.getZoneStatus(zoneId);
        assert (zs != null);
        if (reProto.hasCompletionTime()) {
            zs.markZoneCompleted(reProto);
        } else if (!reProto.hasLastFile() && !reProto.hasCompletionTime()) {
            zs.markZoneSubmitted(reProto);
        } else {
            zs.updateZoneProcess(reProto);
        }
    }

    public boolean removeZone(Long zoneId) {
        LOG.debug("Removing re-encryption status of zone {} ", (Object)zoneId);
        return this.zoneStatuses.remove(zoneId) != null;
    }

    @VisibleForTesting
    public int zonesQueued() {
        int ret = 0;
        for (Map.Entry<Long, ZoneReencryptionStatus> entry : this.zoneStatuses.entrySet()) {
            if (entry.getValue().getState() != ZoneReencryptionStatus.State.Submitted) continue;
            ++ret;
        }
        return ret;
    }

    @VisibleForTesting
    public int zonesTotal() {
        return this.zoneStatuses.size();
    }

    @VisibleForTesting
    public long getNumZonesReencrypted() {
        return this.zonesReencrypted;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Long, ZoneReencryptionStatus> entry : this.zoneStatuses.entrySet()) {
            sb.append("[zone:" + entry.getKey()).append(" state:" + (Object)((Object)entry.getValue().getState())).append(" lastProcessed:" + entry.getValue().getLastCheckpointFile()).append(" filesReencrypted:" + entry.getValue().getFilesReencrypted()).append(" fileReencryptionFailures:" + entry.getValue().getNumReencryptionFailures() + "]");
        }
        return sb.toString();
    }

    public NavigableMap<Long, ZoneReencryptionStatus> getZoneStatuses() {
        return this.zoneStatuses;
    }
}

