/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.bitwise;

import java.io.IOException;
import java.io.Serializable;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.exceptions.ExceptionUtil;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.common.ListAccessor;
import org.apache.asterix.runtime.evaluators.functions.AbstractScalarEval;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.exceptions.Warning;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

abstract class AbstractBitValuePositionEvaluator
extends AbstractScalarEval {
    private long longResult;
    private final AMutableInt64 resultMutableInt64 = new AMutableInt64(0L);
    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private final IScalarEvaluator valueEvaluator;
    private final IScalarEvaluator positionEvaluator;
    private final IPointable valuePointable = new VoidPointable();
    private final IPointable positionPointable = new VoidPointable();
    private final ListAccessor listAccessor = new ListAccessor();
    private final IPointable listItemPointable = new VoidPointable();
    private final ISerializerDeserializer aInt64Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
    private final IEvaluatorContext context;
    private static final byte[] secondArgumentExpectedTypes = new byte[]{ATypeTag.SERIALIZED_INT64_TYPE_TAG, ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG};

    AbstractBitValuePositionEvaluator(IEvaluatorContext context, IScalarEvaluatorFactory[] argEvaluatorFactories, FunctionIdentifier functionIdentifier, SourceLocation sourceLocation) throws HyracksDataException {
        super(sourceLocation, functionIdentifier);
        this.context = context;
        this.valueEvaluator = argEvaluatorFactories[0].createScalarEvaluator(context);
        this.positionEvaluator = argEvaluatorFactories[1].createScalarEvaluator(context);
    }

    abstract long applyBitwiseOperation(long var1, long var3);

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        int positionStartOffset;
        int valueStartOffset;
        this.valueEvaluator.evaluate(tuple, this.valuePointable);
        this.positionEvaluator.evaluate(tuple, this.positionPointable);
        if (PointableHelper.checkAndSetMissingOrNull(result, this.valuePointable, this.positionPointable)) {
            return;
        }
        byte[] valueBytes = this.valuePointable.getByteArray();
        if (!PointableHelper.isValidLongValue(valueBytes, valueStartOffset = this.valuePointable.getStartOffset(), true)) {
            ExceptionUtil.warnTypeMismatch((IEvaluatorContext)this.context, (SourceLocation)this.srcLoc, (FunctionIdentifier)this.funID, (byte)valueBytes[valueStartOffset], (int)0, (ATypeTag)ATypeTag.BIGINT);
            PointableHelper.setNull(result);
            return;
        }
        byte[] positionBytes = this.positionPointable.getByteArray();
        ATypeTag positionTypeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(positionBytes[positionStartOffset = this.positionPointable.getStartOffset()]);
        if (!ATypeHierarchy.canPromote((ATypeTag)positionTypeTag, (ATypeTag)ATypeTag.DOUBLE) && positionTypeTag != ATypeTag.ARRAY) {
            ExceptionUtil.warnTypeMismatch((IEvaluatorContext)this.context, (SourceLocation)this.srcLoc, (FunctionIdentifier)this.funID, (byte)positionBytes[positionStartOffset], (int)1, (byte[])secondArgumentExpectedTypes);
            PointableHelper.setNull(result);
            return;
        }
        this.longResult = ATypeHierarchy.getLongValue((String)this.funID.getName(), (int)0, (byte[])valueBytes, (int)valueStartOffset);
        boolean isSuccessfulOperation = positionTypeTag != ATypeTag.ARRAY ? this.applyBitWiseOperationWithNumericAsPosition(positionBytes, positionStartOffset) : this.applyBitWiseOperationWithArrayAsPosition(positionBytes, positionStartOffset);
        if (!isSuccessfulOperation) {
            PointableHelper.setNull(result);
            return;
        }
        this.resultStorage.reset();
        this.resultMutableInt64.setValue(this.longResult);
        this.aInt64Serde.serialize((Object)this.resultMutableInt64, this.resultStorage.getDataOutput());
        result.set((IValueReference)this.resultStorage);
    }

    private boolean applyBitWiseOperationWithArrayAsPosition(byte[] bytes, int startOffset) throws HyracksDataException {
        this.listAccessor.reset(bytes, startOffset);
        if (this.listAccessor.size() == 0) {
            return true;
        }
        try {
            for (int i = 0; i < this.listAccessor.size(); ++i) {
                this.resultStorage.reset();
                this.listAccessor.getOrWriteItem(i, this.listItemPointable, this.resultStorage);
                byte[] itemBytes = this.listItemPointable.getByteArray();
                int itemStartOffset = this.listItemPointable.getStartOffset();
                if (this.applyBitWiseOperationWithNumericAsPosition(itemBytes, itemStartOffset)) continue;
                return false;
            }
            return true;
        }
        catch (IOException ex) {
            throw HyracksDataException.create((Throwable)ex);
        }
    }

    private boolean applyBitWiseOperationWithNumericAsPosition(byte[] bytes, int startOffset) throws HyracksDataException {
        if (!PointableHelper.isValidLongValue(bytes, startOffset, true)) {
            ExceptionUtil.warnTypeMismatch((IEvaluatorContext)this.context, (SourceLocation)this.srcLoc, (FunctionIdentifier)this.funID, (byte)bytes[startOffset], (int)1, (ATypeTag)ATypeTag.BIGINT);
            return false;
        }
        long position = ATypeHierarchy.getLongValue((String)this.funID.getName(), (int)1, (byte[])bytes, (int)startOffset);
        if (position < 1L || position > 64L) {
            this.handleOutOfRangeInput(1, 1, 64, position);
            return false;
        }
        this.longResult = this.applyBitwiseOperation(this.longResult, position);
        return true;
    }

    private void handleOutOfRangeInput(int inputPosition, int startLimit, int endLimit, long actual) {
        IWarningCollector warningCollector = this.context.getWarningCollector();
        if (warningCollector.shouldWarn()) {
            warningCollector.warn(Warning.of((SourceLocation)this.srcLoc, (IError)ErrorCode.VALUE_OUT_OF_RANGE, (Serializable[])new Serializable[]{this.funID, ExceptionUtil.indexToPosition((int)inputPosition), Integer.valueOf(startLimit), Integer.valueOf(endLimit), Long.valueOf(actual)}));
        }
    }
}

