/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.hdfs.parquet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.asterix.external.input.filter.embedder.IExternalFilterValueEmbedder;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.AsterixTypeToParquetTypeVisitor;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.ParquetConverterContext;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.nested.RootConverter;
import org.apache.asterix.external.util.HDFSUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.runtime.projection.FunctionCallInformation;
import org.apache.hadoop.conf.Configuration;
import org.apache.hyracks.api.exceptions.Warning;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.parquet.hadoop.api.InitContext;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;

public class ParquetReadSupport
extends ReadSupport<IValueReference> {
    private IExternalFilterValueEmbedder valueEmbedder;

    public ReadSupport.ReadContext init(InitContext context) {
        MessageType requestedSchema = ParquetReadSupport.getRequestedSchema(context);
        return new ReadSupport.ReadContext(requestedSchema);
    }

    public RecordMaterializer<IValueReference> prepareForRead(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema, ReadSupport.ReadContext readContext) {
        try {
            return new ADMRecordMaterializer(configuration, this.valueEmbedder, readContext);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static MessageType getRequestedSchema(InitContext initContext) {
        Configuration configuration = initContext.getConfiguration();
        MessageType fileSchema = initContext.getFileSchema();
        ArrayList<Warning> warnings = new ArrayList<Warning>();
        ParquetConverterContext context = new ParquetConverterContext(configuration, warnings);
        AsterixTypeToParquetTypeVisitor visitor = new AsterixTypeToParquetTypeVisitor(context);
        try {
            ARecordType expectedType = HDFSUtils.getExpectedType(configuration);
            Map<String, FunctionCallInformation> functionCallInformationMap = HDFSUtils.getFunctionCallInformationMap(configuration);
            MessageType requestedType = visitor.clipType(expectedType, fileSchema, functionCallInformationMap);
            if (!warnings.isEmpty()) {
                HDFSUtils.setWarnings(warnings, configuration);
                HDFSUtils.setFunctionCallInformationMap(functionCallInformationMap, configuration);
            }
            return requestedType;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    void setValueEmbedder(IExternalFilterValueEmbedder valueEmbedder) {
        this.valueEmbedder = valueEmbedder;
    }

    private static class ADMRecordMaterializer
    extends RecordMaterializer<IValueReference> {
        private final RootConverter rootConverter;
        private final List<Warning> warnings = new ArrayList<Warning>();
        private final Configuration configuration;

        public ADMRecordMaterializer(Configuration configuration, IExternalFilterValueEmbedder valueEmbedder, ReadSupport.ReadContext readContext) throws IOException {
            this.rootConverter = new RootConverter((GroupType)readContext.getRequestedSchema(), valueEmbedder, configuration, this.warnings);
            this.configuration = configuration;
        }

        public IValueReference getCurrentRecord() {
            try {
                if (!this.warnings.isEmpty()) {
                    HDFSUtils.setWarnings(this.warnings, this.configuration);
                    this.warnings.clear();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            return this.rootConverter.getRecord();
        }

        public GroupConverter getRootConverter() {
            return this.rootConverter;
        }
    }
}

