/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.column.impls.btree;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.btree.impls.BTreeNSMBulkLoader;
import org.apache.hyracks.storage.am.btree.impls.BTreeSplitKey;
import org.apache.hyracks.storage.am.common.api.ISplitKey;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrame;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import org.apache.hyracks.storage.am.common.impls.NodeFrontier;
import org.apache.hyracks.storage.am.lsm.btree.column.api.AbstractColumnTupleWriter;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnWriteMultiPageOp;
import org.apache.hyracks.storage.am.lsm.btree.column.impls.btree.ColumnBTreeWriteLeafFrame;
import org.apache.hyracks.storage.common.buffercache.CachedPage;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.buffercache.IPageWriteCallback;
import org.apache.hyracks.storage.common.file.BufferedFileHandle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ColumnBTreeBulkloader
extends BTreeNSMBulkLoader
implements IColumnWriteMultiPageOp {
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<CachedPage> columnsPages = new ArrayList<CachedPage>();
    private final List<CachedPage> tempConfiscatedPages = new ArrayList<CachedPage>();
    private final ColumnBTreeWriteLeafFrame columnarFrame;
    private final AbstractColumnTupleWriter columnWriter;
    private final ISplitKey lowKey;
    private boolean setLowKey;
    private int tupleCount;
    private int numberOfLeafNodes;
    private int numberOfPagesInCurrentLeafNode;
    private int maxNumberOfPagesForAColumn;
    private int maxNumberOfPagesInALeafNode;
    private int maxTupleCount;

    public ColumnBTreeBulkloader(float fillFactor, boolean verifyInput, IPageWriteCallback callback, ITreeIndex index, ITreeIndexFrame leafFrame) throws HyracksDataException {
        super(fillFactor, verifyInput, callback, index, leafFrame);
        this.columnarFrame = (ColumnBTreeWriteLeafFrame)leafFrame;
        this.columnWriter = this.columnarFrame.getColumnTupleWriter();
        this.columnWriter.init(this);
        this.lowKey = new BTreeSplitKey(this.tupleWriter.createTupleReference());
        this.lowKey.getTuple().setFieldCount(this.cmp.getKeyFieldCount());
        this.setLowKey = true;
        this.numberOfPagesInCurrentLeafNode = 1;
        this.maxNumberOfPagesForAColumn = 0;
        this.maxNumberOfPagesInALeafNode = 0;
        this.numberOfLeafNodes = 1;
        this.maxTupleCount = 0;
    }

    public void add(ITupleReference tuple) throws HyracksDataException {
        if (this.isFull(tuple)) {
            this.writeFullLeafPage();
            this.confiscateNewLeafPage();
        }
        this.setMinMaxKeys(tuple);
        this.columnWriter.writeTuple(tuple);
        ++this.tupleCount;
    }

    protected ITreeIndexTupleReference createTupleReference() {
        return this.tupleWriter.createTupleReference();
    }

    private boolean isFull(ITupleReference tuple) {
        if (this.tupleCount == 0) {
            return false;
        }
        if (this.tupleCount >= this.columnWriter.getMaxNumberOfTuples()) {
            return true;
        }
        int requiredFreeSpace = 30;
        requiredFreeSpace += this.columnWriter.getColumnOffsetsSize();
        requiredFreeSpace += this.columnWriter.getOccupiedSpace();
        requiredFreeSpace += this.lowKey.getTuple().getTupleSize() + this.splitKey.getTuple().getTupleSize();
        return this.bufferCache.getPageSize() <= (requiredFreeSpace += this.columnWriter.bytesRequired(tuple));
    }

    private void setMinMaxKeys(ITupleReference tuple) {
        this.setSplitKey(this.splitKey, tuple);
        if (this.setLowKey) {
            this.setSplitKey(this.lowKey, tuple);
            this.lowKey.getTuple().resetByTupleOffset(this.lowKey.getBuffer().array(), 0);
            this.setLowKey = false;
        }
    }

    public void end() throws HyracksDataException {
        if (this.tupleCount > 0) {
            this.splitKey.getTuple().resetByTupleOffset(this.splitKey.getBuffer().array(), 0);
            this.columnarFrame.flush(this.columnWriter, this.tupleCount, this, (ITupleReference)this.lowKey.getTuple(), (ITupleReference)this.splitKey.getTuple());
        }
        this.columnWriter.close();
        for (ICachedPage iCachedPage : this.tempConfiscatedPages) {
            this.bufferCache.returnPage(iCachedPage, false);
        }
        int numberOfTempConfiscatedPages = this.tempConfiscatedPages.size();
        this.tempConfiscatedPages.clear();
        super.end();
        this.log("Finished", numberOfTempConfiscatedPages);
    }

    protected void writeFullLeafPage() throws HyracksDataException {
        NodeFrontier leafFrontier = (NodeFrontier)this.nodeFrontiers.get(0);
        this.splitKey.getTuple().resetByTupleOffset(this.splitKey.getBuffer().array(), 0);
        this.splitKey.setLeftPage(leafFrontier.pageId);
        if (this.tupleCount > 0) {
            this.columnarFrame.flush(this.columnWriter, this.tupleCount, this, (ITupleReference)this.lowKey.getTuple(), (ITupleReference)this.splitKey.getTuple());
        }
        this.propagateBulk(1, this.pagesToWrite);
        leafFrontier.pageId = this.freePageManager.takePage(this.metaFrame);
        this.columnarFrame.setNextLeaf(leafFrontier.pageId);
        this.writeColumnsPages();
        this.write(leafFrontier.page);
        for (ICachedPage c : this.pagesToWrite) {
            this.write(c);
        }
        this.maxNumberOfPagesInALeafNode = Math.max(this.maxNumberOfPagesInALeafNode, this.numberOfPagesInCurrentLeafNode);
        this.maxTupleCount = Math.max(this.maxTupleCount, this.tupleCount);
        this.numberOfPagesInCurrentLeafNode = 1;
        ++this.numberOfLeafNodes;
        this.pagesToWrite.clear();
        this.splitKey.setRightPage(leafFrontier.pageId);
        this.setLowKey = true;
        this.tupleCount = 0;
    }

    protected void writeLastLeaf(ICachedPage page) throws HyracksDataException {
        this.writeColumnsPages();
        super.writeLastLeaf(page);
    }

    private void writeColumnsPages() throws HyracksDataException {
        for (ICachedPage iCachedPage : this.columnsPages) {
            this.write(iCachedPage);
        }
        int numberOfPagesInPersistedColumn = this.columnsPages.size();
        this.maxNumberOfPagesForAColumn = Math.max(this.maxNumberOfPagesForAColumn, numberOfPagesInPersistedColumn);
        this.numberOfPagesInCurrentLeafNode += numberOfPagesInPersistedColumn;
        this.columnsPages.clear();
    }

    public void abort() throws HyracksDataException {
        for (ICachedPage iCachedPage : this.columnsPages) {
            this.bufferCache.returnPage(iCachedPage, false);
        }
        for (ICachedPage iCachedPage : this.tempConfiscatedPages) {
            this.bufferCache.returnPage(iCachedPage, false);
        }
        super.abort();
        this.log("Aborted", this.tempConfiscatedPages.size());
    }

    private void setSplitKey(ISplitKey splitKey, ITupleReference tuple) {
        int splitKeySize = this.tupleWriter.bytesRequired(tuple, 0, this.cmp.getKeyFieldCount());
        splitKey.initData(splitKeySize);
        this.tupleWriter.writeTupleFields(tuple, 0, this.cmp.getKeyFieldCount(), splitKey.getBuffer().array(), 0);
    }

    private void log(String status, int numberOfTempConfiscatedPages) {
        if (!LOGGER.isDebugEnabled()) {
            return;
        }
        LOGGER.debug("{} columnar bulkloader wrote maximum {} and last {} and used leafNodes: {}, tempPagesAllocated: {}, maxPagesPerColumn: {}, and maxLeafNodePages: {}", (Object)status, (Object)this.maxTupleCount, (Object)this.tupleCount, (Object)this.numberOfLeafNodes, (Object)numberOfTempConfiscatedPages, (Object)this.maxNumberOfPagesForAColumn, (Object)this.maxNumberOfPagesInALeafNode);
    }

    @Override
    public ByteBuffer confiscatePersistent() throws HyracksDataException {
        int pageId = this.freePageManager.takePage(this.metaFrame);
        long dpid = BufferedFileHandle.getDiskPageId((int)this.fileId, (int)pageId);
        CachedPage page = (CachedPage)this.bufferCache.confiscatePage(dpid);
        this.columnsPages.add(page);
        return page.getBuffer();
    }

    @Override
    public void persist() throws HyracksDataException {
        this.writeColumnsPages();
    }

    @Override
    public int getNumberOfPersistentBuffers() {
        return this.columnsPages.size();
    }

    @Override
    public ByteBuffer confiscateTemporary() throws HyracksDataException {
        CachedPage page = (CachedPage)this.bufferCache.confiscatePage(-1L);
        this.tempConfiscatedPages.add(page);
        return page.getBuffer();
    }
}

