/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.column.impls.btree;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.btree.api.IDiskBTreeStatefulPointSearchCursor;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrame;
import org.apache.hyracks.storage.am.common.ophelpers.FindTupleMode;
import org.apache.hyracks.storage.am.common.ophelpers.FindTupleNoExactMatchPolicy;
import org.apache.hyracks.storage.am.lsm.btree.column.impls.btree.ColumnBTreeRangeSearchCursor;
import org.apache.hyracks.storage.am.lsm.btree.column.impls.btree.ColumnBTreeReadLeafFrame;
import org.apache.hyracks.storage.common.IIndexCursorStats;
import org.apache.hyracks.storage.common.ISearchPredicate;

public class ColumnBTreePointSearchCursor
extends ColumnBTreeRangeSearchCursor
implements IDiskBTreeStatefulPointSearchCursor {
    public ColumnBTreePointSearchCursor(ColumnBTreeReadLeafFrame frame, IIndexCursorStats stats, int index) {
        super(frame, stats, index);
    }

    @Override
    public boolean doHasNext() {
        return this.yieldFirstCall;
    }

    @Override
    protected boolean shouldYieldFirstCall() throws HyracksDataException {
        return this.pred.getLowKeyComparator().compare(this.lowKey, (ITupleReference)this.frameTuple) == 0;
    }

    @Override
    public void doClose() throws HyracksDataException {
        this.pageId = -1;
        super.doClose();
    }

    public int getLastPageId() {
        return this.pageId;
    }

    public void setCursorToNextKey(ISearchPredicate searchPred) throws HyracksDataException {
        int index = this.getLowKeyIndex();
        if (index == this.frame.getTupleCount()) {
            this.frameTuple.consume();
            this.yieldFirstCall = false;
            return;
        }
        this.frameTuple.setAt(index);
        this.yieldFirstCall = true;
    }

    @Override
    protected void setSearchPredicate(ISearchPredicate searchPred) {
        this.pred = (RangePredicate)searchPred;
        this.lowKey = this.pred.getLowKey();
        this.lowKeyFtm = FindTupleMode.EXACT;
        this.lowKeyFtp = FindTupleNoExactMatchPolicy.NONE;
        this.reusablePredicate.setLowKeyComparator(this.originalKeyCmp);
    }

    @Override
    protected int getLowKeyIndex() throws HyracksDataException {
        int index = this.frameTuple.findTupleIndex(this.pred.getLowKey(), this.pred.getLowKeyComparator(), this.lowKeyFtm, this.lowKeyFtp);
        return index < 0 ? this.frame.getTupleCount() : index;
    }

    public ITreeIndexFrame getFrame() {
        return this.frame;
    }
}

