/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.assembler;

import org.apache.asterix.column.assembler.AbstractNestedValueAssembler;
import org.apache.asterix.column.assembler.EmptyAssembler;
import org.apache.asterix.om.typecomputer.impl.TypeComputeUtils;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;

public class AssemblerInfo {
    private final AbstractNestedValueAssembler parent;
    private final IAType declaredType;
    private final boolean delegate;
    private final IValueReference fieldName;
    private final int fieldIndex;

    public AssemblerInfo() {
        this((IAType)BuiltinType.ANY, null, false);
    }

    public AssemblerInfo(IAType declaredType, EmptyAssembler parent) {
        this(declaredType, parent, false);
    }

    public AssemblerInfo(IAType declaredType, AbstractNestedValueAssembler parent, boolean delegate) {
        this(declaredType, parent, delegate, null, -1);
    }

    public AssemblerInfo(IAType declaredType, AbstractNestedValueAssembler parent, boolean delegate, IValueReference fieldName) {
        this(declaredType, parent, delegate, fieldName, -1);
    }

    public AssemblerInfo(IAType declaredType, AbstractNestedValueAssembler parent, boolean delegate, int fieldIndex) {
        this(declaredType, parent, delegate, null, fieldIndex);
    }

    public AssemblerInfo(IAType declaredType, AbstractNestedValueAssembler parent, boolean delegate, IValueReference fieldName, int fieldIndex) {
        this(declaredType, parent, delegate, fieldName, fieldIndex, false);
    }

    public AssemblerInfo(IAType declaredType, AbstractNestedValueAssembler parent, boolean delegate, IValueReference fieldName, int fieldIndex, boolean fieldNameTagged) {
        this.parent = parent;
        this.declaredType = TypeComputeUtils.getActualType((IAType)declaredType);
        this.delegate = delegate;
        this.fieldName = fieldNameTagged ? fieldName : this.createTaggedFieldName(fieldName);
        this.fieldIndex = fieldIndex;
    }

    private IValueReference createTaggedFieldName(IValueReference fieldName) {
        if (fieldName == null) {
            return null;
        }
        byte[] storage = new byte[1 + fieldName.getLength()];
        storage[0] = ATypeTag.STRING.serialize();
        System.arraycopy(fieldName.getByteArray(), fieldName.getStartOffset(), storage, 1, fieldName.getLength());
        VoidPointable taggedFieldName = new VoidPointable();
        taggedFieldName.set(storage, 0, storage.length);
        return taggedFieldName;
    }

    public AbstractNestedValueAssembler getParent() {
        return this.parent;
    }

    public IAType getDeclaredType() {
        return this.declaredType;
    }

    public boolean isDelegate() {
        return this.delegate;
    }

    public IValueReference getFieldName() {
        return this.fieldName;
    }

    public int getFieldIndex() {
        return this.fieldIndex;
    }
}

