/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.values.writer;

import java.nio.ByteBuffer;
import java.util.PriorityQueue;
import org.apache.asterix.column.bytes.stream.out.ByteBufferOutputStream;
import org.apache.asterix.column.bytes.stream.out.MultiPersistentBufferBytesOutputStream;
import org.apache.asterix.column.bytes.stream.out.pointer.IReservedPointer;
import org.apache.asterix.column.values.IColumnBatchWriter;
import org.apache.asterix.column.values.IColumnValuesWriter;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnWriteMultiPageOp;

public final class ColumnBatchWriter
implements IColumnBatchWriter {
    private final ByteBufferOutputStream primaryKeys;
    private final MultiPersistentBufferBytesOutputStream columns;
    private final int pageSize;
    private final double tolerance;
    private final IReservedPointer columnLengthPointer;
    private ByteBuffer pageZero;
    private int columnsOffset;
    private int filtersOffset;
    private int primaryKeysOffset;
    private int nonKeyColumnStartOffset;

    public ColumnBatchWriter(Mutable<IColumnWriteMultiPageOp> multiPageOpRef, int pageSize, double tolerance) {
        this.pageSize = pageSize;
        this.tolerance = tolerance;
        this.primaryKeys = new ByteBufferOutputStream();
        this.columns = new MultiPersistentBufferBytesOutputStream(multiPageOpRef);
        this.columnLengthPointer = this.columns.createPointer();
    }

    @Override
    public void setPageZeroBuffer(ByteBuffer pageZero, int numberOfColumns, int numberOfPrimaryKeys) {
        int offset;
        this.pageZero = pageZero;
        this.columnsOffset = offset = pageZero.position();
        this.filtersOffset = offset += numberOfColumns * 4;
        pageZero.position(offset += numberOfColumns * 16);
        this.primaryKeysOffset = offset;
        this.primaryKeys.reset(pageZero);
        this.nonKeyColumnStartOffset = pageZero.capacity();
    }

    @Override
    public int writePrimaryKeyColumns(IColumnValuesWriter[] primaryKeyWriters) throws HyracksDataException {
        int allocatedSpace = 0;
        for (int i = 0; i < primaryKeyWriters.length; ++i) {
            IColumnValuesWriter writer = primaryKeyWriters[i];
            this.setColumnOffset(i, this.primaryKeysOffset + this.primaryKeys.size());
            writer.flush(this.primaryKeys);
            allocatedSpace += writer.getAllocatedSpace();
        }
        return allocatedSpace;
    }

    @Override
    public int writeColumns(PriorityQueue<IColumnValuesWriter> nonKeysColumnWriters) throws HyracksDataException {
        int allocatedSpace = 0;
        this.columns.reset();
        while (!nonKeysColumnWriters.isEmpty()) {
            IColumnValuesWriter writer = nonKeysColumnWriters.poll();
            this.writeColumn(writer);
            allocatedSpace += writer.getAllocatedSpace();
        }
        return allocatedSpace;
    }

    private void writeColumn(IColumnValuesWriter writer) throws HyracksDataException {
        if (!this.hasEnoughSpace(this.columns.getCurrentBufferPosition(), writer)) {
            this.nonKeyColumnStartOffset += this.columns.capacity();
            this.columns.reset();
        }
        int columnRelativeOffset = this.columns.size();
        this.columns.reserveInteger(this.columnLengthPointer);
        this.setColumnOffset(writer.getColumnIndex(), this.nonKeyColumnStartOffset + columnRelativeOffset);
        this.writeFilter(writer);
        writer.flush(this.columns);
        int length = this.columns.size() - columnRelativeOffset;
        this.columnLengthPointer.setInteger(length);
    }

    private boolean hasEnoughSpace(int bufferPosition, IColumnValuesWriter columnWriter) {
        int columnSize = columnWriter.getEstimatedSize();
        float remainingPercentage = (float)(this.pageSize - bufferPosition) / (float)this.pageSize;
        if (columnSize > this.pageSize) {
            return (double)remainingPercentage >= this.tolerance;
        }
        int freeSpace = this.pageSize - (bufferPosition + columnSize);
        return freeSpace > columnSize || (double)remainingPercentage >= this.tolerance;
    }

    private void setColumnOffset(int columnIndex, int offset) {
        this.pageZero.putInt(this.columnsOffset + 4 * columnIndex, offset);
    }

    private void writeFilter(IColumnValuesWriter writer) {
        int offset = this.filtersOffset + writer.getColumnIndex() * 16;
        this.pageZero.putLong(offset, writer.getNormalizedMinValue());
        this.pageZero.putLong(offset + 8, writer.getNormalizedMaxValue());
    }
}

