/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.jdbc.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.asterix.jdbc.core.ADBColumn;
import org.apache.asterix.jdbc.core.ADBDatatype;
import org.apache.asterix.jdbc.core.ADBDriverContext;
import org.apache.asterix.jdbc.core.ADBErrorReporter;
import org.apache.asterix.jdbc.core.ADBResultSetMetaData;
import org.apache.asterix.jdbc.core.ADBRowStore;
import org.apache.asterix.jdbc.core.ADBWrapperSupport;
import org.apache.asterix.jdbc.core.deps.com.fasterxml.jackson.core.JsonParser;
import org.apache.asterix.jdbc.core.deps.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.asterix.jdbc.core.deps.com.fasterxml.jackson.core.JsonToken;
import org.apache.asterix.jdbc.core.deps.com.fasterxml.jackson.databind.ObjectReader;

public class ADBResultSet
extends ADBWrapperSupport
implements ResultSet {
    static final int RESULT_SET_HOLDABILITY = 1;
    static final int ST_BEFORE_FIRST = 0;
    static final int ST_NEXT = 1;
    static final int ST_AFTER_LAST = 2;
    final AtomicBoolean closed = new AtomicBoolean(false);
    final ADBResultSetMetaData metadata;
    final JsonParser rowParser;
    final boolean rowParserOwnsResources;
    final long maxRows;
    int state;
    long rowNumber;
    ADBRowStore rowStore;
    ObjectReader complexColumnReader;
    int columnIndexOfLatestGet;

    public ADBResultSet(ADBResultSetMetaData metadata, JsonParser rowParser, boolean rowParserOwnsResources, long maxRows) {
        this.metadata = Objects.requireNonNull(metadata);
        this.rowParser = Objects.requireNonNull(rowParser);
        this.rowParserOwnsResources = rowParserOwnsResources;
        this.maxRows = maxRows;
        this.state = 0;
    }

    @Override
    public void close() throws SQLException {
        this.closeImpl(true);
    }

    void closeImpl(boolean notifyStatement) throws SQLException {
        boolean wasClosed = this.closed.getAndSet(true);
        if (wasClosed) {
            return;
        }
        try {
            this.rowParser.close();
        }
        catch (IOException e) {
            throw this.getErrorReporter().errorClosingResource(e);
        }
        finally {
            if (notifyStatement) {
                this.metadata.statement.deregisterResultSet(this);
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed()) {
            throw this.getErrorReporter().errorObjectClosed(ResultSet.class);
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return this.metadata;
    }

    @Override
    public boolean next() throws SQLException {
        this.checkClosed();
        try {
            switch (this.state) {
                case 0: {
                    JsonToken token;
                    JsonToken jsonToken = token = this.rowParser.hasCurrentToken() ? this.rowParser.currentToken() : this.rowParser.nextToken();
                    if (token != JsonToken.START_ARRAY) {
                        throw this.getErrorReporter().errorInProtocol(String.valueOf((Object)token));
                    }
                    this.initRowStore();
                    this.state = 1;
                }
                case 1: {
                    JsonToken token = this.rowParser.nextToken();
                    switch (token) {
                        case START_OBJECT: {
                            if (this.maxRows > 0L && this.rowNumber == this.maxRows) {
                                this.state = 2;
                                return false;
                            }
                            this.readRow();
                            ++this.rowNumber;
                            return true;
                        }
                        case END_ARRAY: {
                            this.state = 2;
                            return false;
                        }
                    }
                    throw this.getErrorReporter().errorInProtocol(String.valueOf((Object)token));
                }
                case 2: {
                    return false;
                }
            }
            throw new IllegalStateException(String.valueOf(this.state));
        }
        catch (JsonProcessingException e) {
            throw this.getErrorReporter().errorInProtocol(e);
        }
        catch (IOException e) {
            throw this.getErrorReporter().errorInConnection(e);
        }
    }

    private void initRowStore() {
        this.rowStore = this.createRowStore(this.metadata.getColumnCount());
    }

    protected ADBRowStore createRowStore(int columnCount) {
        return new ADBRowStore(this, columnCount);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readRow() throws SQLException {
        this.rowStore.reset();
        this.columnIndexOfLatestGet = -1;
        if (this.rowParser.currentToken() != JsonToken.START_OBJECT) {
            throw new IllegalStateException();
        }
        try {
            block12: while (this.rowParser.nextToken() == JsonToken.FIELD_NAME) {
                String fieldName = this.rowParser.getCurrentName();
                int columnIndex = this.metadata.findColumnIndexByName(fieldName);
                boolean isKnownColumn = columnIndex >= 0;
                ADBColumn column = isKnownColumn ? this.metadata.getColumnByIndex(columnIndex) : null;
                switch (this.rowParser.nextToken()) {
                    case VALUE_NULL: {
                        if (!isKnownColumn) continue block12;
                        this.typeCheck(column, ADBDatatype.NULL);
                        this.rowStore.putNullColumn(columnIndex);
                        continue block12;
                    }
                    case VALUE_TRUE: {
                        if (!isKnownColumn) continue block12;
                        this.typeCheck(column, ADBDatatype.BOOLEAN);
                        this.rowStore.putBooleanColumn(columnIndex, true);
                        continue block12;
                    }
                    case VALUE_FALSE: {
                        if (!isKnownColumn) continue block12;
                        this.typeCheck(column, ADBDatatype.BOOLEAN);
                        this.rowStore.putBooleanColumn(columnIndex, false);
                        continue block12;
                    }
                    case VALUE_NUMBER_INT: {
                        if (!isKnownColumn) continue block12;
                        this.typeCheck(column, ADBDatatype.BIGINT);
                        long v = this.rowParser.getLongValue();
                        this.rowStore.putInt64Column(columnIndex, v);
                        continue block12;
                    }
                    case VALUE_STRING: {
                        if (!isKnownColumn) continue block12;
                        this.typeCheck(column, ADBDatatype.STRING);
                        char[] textChars = this.rowParser.getTextCharacters();
                        int textOffset = this.rowParser.getTextOffset();
                        int textLength = this.rowParser.getTextLength();
                        this.rowStore.putColumn(columnIndex, textChars, textOffset, textLength);
                        continue block12;
                    }
                    case START_OBJECT: {
                        if (isKnownColumn) {
                            this.typeCheck(column, ADBDatatype.OBJECT);
                            Map valueMap = this.getComplexColumnReader().readValue(this.rowParser, Map.class);
                            this.rowStore.putRecordColumn(columnIndex, valueMap);
                            continue block12;
                        }
                        this.rowParser.skipChildren();
                        continue block12;
                    }
                    case START_ARRAY: {
                        if (isKnownColumn) {
                            this.typeCheck(column, ADBDatatype.ARRAY);
                            List valueList = this.getComplexColumnReader().readValue(this.rowParser, List.class);
                            this.rowStore.putArrayColumn(columnIndex, valueList);
                            continue block12;
                        }
                        this.rowParser.skipChildren();
                        continue block12;
                    }
                }
            }
            return;
            throw this.getErrorReporter().errorInProtocol(String.valueOf((Object)this.rowParser.currentToken()));
        }
        catch (JsonProcessingException e) {
            throw this.getErrorReporter().errorInProtocol(e);
        }
        catch (IOException e) {
            throw this.getErrorReporter().errorInConnection(e);
        }
    }

    private void typeCheck(ADBColumn column, ADBDatatype parsedType) throws SQLException {
        boolean typeMatch;
        ADBDatatype columnType = column.getType();
        switch (parsedType) {
            case NULL: {
                typeMatch = column.isOptional();
                break;
            }
            case STRING: {
                typeMatch = !columnType.isDerived();
                break;
            }
            case ARRAY: {
                typeMatch = columnType == ADBDatatype.ANY || columnType.isList();
                break;
            }
            case BOOLEAN: 
            case BIGINT: 
            case OBJECT: {
                typeMatch = columnType == ADBDatatype.ANY || columnType == parsedType;
                break;
            }
            default: {
                throw this.getErrorReporter().errorInProtocol(parsedType.toString());
            }
        }
        if (!typeMatch) {
            throw this.getErrorReporter().errorUnexpectedColumnValue(parsedType, column.getName());
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkClosed();
        throw this.getErrorReporter().errorIncompatibleMode("FORWARD_ONLY");
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkClosed();
        throw this.getErrorReporter().errorIncompatibleMode("FORWARD_ONLY");
    }

    @Override
    public boolean first() throws SQLException {
        this.checkClosed();
        throw this.getErrorReporter().errorIncompatibleMode("FORWARD_ONLY");
    }

    @Override
    public boolean last() throws SQLException {
        this.checkClosed();
        throw this.getErrorReporter().errorIncompatibleMode("FORWARD_ONLY");
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkClosed();
        throw this.getErrorReporter().errorIncompatibleMode("FORWARD_ONLY");
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.checkClosed();
        throw this.getErrorReporter().errorIncompatibleMode("FORWARD_ONLY");
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.checkClosed();
        throw this.getErrorReporter().errorIncompatibleMode("FORWARD_ONLY");
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkClosed();
        return this.state == 0;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkClosed();
        return this.state == 2;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkClosed();
        return this.state == 1 && this.rowNumber == 1L;
    }

    @Override
    public boolean isLast() throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "isLast");
    }

    @Override
    public int getRow() throws SQLException {
        this.checkClosed();
        return this.state == 1 ? (int)this.rowNumber : 0;
    }

    private void checkCursorPosition() throws SQLException {
        if (this.state != 1) {
            throw this.getErrorReporter().errorNoCurrentRow();
        }
    }

    private ObjectReader getComplexColumnReader() {
        if (this.complexColumnReader == null) {
            ADBDriverContext ctx = this.metadata.statement.connection.protocol.getDriverContext();
            ADBRowStore tmpStore = this.createRowStore(1);
            this.complexColumnReader = tmpStore.createComplexColumnObjectReader(ctx.getAdmFormatObjectReader());
        }
        return this.complexColumnReader;
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        this.checkClosed();
        int columnIndex = this.metadata.findColumnIndexByName(columnLabel);
        if (columnIndex < 0) {
            throw this.getErrorReporter().errorColumnNotFound(columnLabel);
        }
        return columnIndex + 1;
    }

    private int fetchColumnIndex(int columnNumber) throws SQLException {
        if (columnNumber < 1 || columnNumber > this.metadata.getColumnCount()) {
            throw this.getErrorReporter().errorColumnNotFound(String.valueOf(columnNumber));
        }
        return columnNumber - 1;
    }

    private int fetchColumnIndex(String columnLabel) throws SQLException {
        int columnIndex = this.metadata.findColumnIndexByName(columnLabel);
        if (columnIndex < 0) {
            throw this.getErrorReporter().errorColumnNotFound(columnLabel);
        }
        return columnIndex;
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        if (this.columnIndexOfLatestGet < 0) {
            return false;
        }
        ADBDatatype columnValueType = this.rowStore.getColumnType(this.columnIndexOfLatestGet);
        return columnValueType == ADBDatatype.NULL || columnValueType == ADBDatatype.MISSING;
    }

    @Override
    public boolean getBoolean(int columnNumber) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        return this.getBooleanImpl(this.fetchColumnIndex(columnNumber));
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        return this.getBooleanImpl(this.fetchColumnIndex(columnLabel));
    }

    private boolean getBooleanImpl(int columnIndex) throws SQLException {
        boolean v = this.rowStore.getBoolean(columnIndex);
        this.columnIndexOfLatestGet = columnIndex;
        return v;
    }

    @Override
    public byte getByte(int columnNumber) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        return this.getByteImpl(this.fetchColumnIndex(columnNumber));
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        return this.getByteImpl(this.fetchColumnIndex(columnLabel));
    }

    private byte getByteImpl(int columnIndex) throws SQLException {
        byte v = this.rowStore.getByte(columnIndex);
        this.columnIndexOfLatestGet = columnIndex;
        return v;
    }

    @Override
    public short getShort(int columnNumber) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        return this.getShortImpl(this.fetchColumnIndex(columnNumber));
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        return this.getShortImpl(this.fetchColumnIndex(columnLabel));
    }

    private short getShortImpl(int columnIndex) throws SQLException {
        short v = this.rowStore.getShort(columnIndex);
        this.columnIndexOfLatestGet = columnIndex;
        return v;
    }

    @Override
    public int getInt(int columnNumber) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        return this.getIntImpl(this.fetchColumnIndex(columnNumber));
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        return this.getIntImpl(this.fetchColumnIndex(columnLabel));
    }

    private int getIntImpl(int columnIndex) throws SQLException {
        int v = this.rowStore.getInt(columnIndex);
        this.columnIndexOfLatestGet = columnIndex;
        return v;
    }

    @Override
    public long getLong(int columnNumber) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        return this.getLongImpl(this.fetchColumnIndex(columnNumber));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        return this.getLongImpl(this.fetchColumnIndex(columnLabel));
    }

    private long getLongImpl(int columnIndex) throws SQLException {
        long v = this.rowStore.getLong(columnIndex);
        this.columnIndexOfLatestGet = columnIndex;
        return v;
    }

    @Override
    public float getFloat(int columnNumber) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        return this.getFloatImpl(this.fetchColumnIndex(columnNumber));
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        return this.getFloatImpl(this.fetchColumnIndex(columnLabel));
    }

    private float getFloatImpl(int columnIndex) throws SQLException {
        float v = this.rowStore.getFloat(columnIndex);
        this.columnIndexOfLatestGet = columnIndex;
        return v;
    }

    @Override
    public double getDouble(int columnNumber) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        return this.getDoubleImpl(this.fetchColumnIndex(columnNumber));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        return this.getDoubleImpl(this.fetchColumnIndex(columnLabel));
    }

    private double getDoubleImpl(int columnIndex) throws SQLException {
        double v = this.rowStore.getDouble(columnIndex);
        this.columnIndexOfLatestGet = columnIndex;
        return v;
    }

    @Override
    public BigDecimal getBigDecimal(int columnNumber) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        return this.getBigDecimalImpl(this.fetchColumnIndex(columnNumber), false, -1);
    }

    @Override
    public BigDecimal getBigDecimal(int columnNumber, int scale) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        return this.getBigDecimalImpl(this.fetchColumnIndex(columnNumber), true, scale);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        return this.getBigDecimalImpl(this.fetchColumnIndex(columnLabel), false, -1);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        return this.getBigDecimalImpl(this.fetchColumnIndex(columnLabel), true, scale);
    }

    private BigDecimal getBigDecimalImpl(int columnIndex, boolean setScale, int scale) throws SQLException {
        BigDecimal v = this.rowStore.getBigDecimal(columnIndex, setScale, scale);
        this.columnIndexOfLatestGet = columnIndex;
        return v;
    }

    @Override
    public Date getDate(int columnNumber) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        return this.getDateImpl(this.fetchColumnIndex(columnNumber), null);
    }

    @Override
    public Date getDate(int columnNumber, Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        return this.getDateImpl(this.fetchColumnIndex(columnNumber), cal);
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        return this.getDateImpl(this.fetchColumnIndex(columnLabel), null);
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        return this.getDateImpl(this.fetchColumnIndex(columnLabel), cal);
    }

    private Date getDateImpl(int columnIndex, Calendar cal) throws SQLException {
        Date v = this.rowStore.getDate(columnIndex, cal);
        this.columnIndexOfLatestGet = columnIndex;
        return v;
    }

    @Override
    public Time getTime(int columnNumber) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        return this.getTimeImpl(this.fetchColumnIndex(columnNumber), null);
    }

    @Override
    public Time getTime(int columnNumber, Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        return this.getTimeImpl(this.fetchColumnIndex(columnNumber), cal);
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        return this.getTimeImpl(this.fetchColumnIndex(columnLabel), null);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        return this.getTimeImpl(this.fetchColumnIndex(columnLabel), cal);
    }

    private Time getTimeImpl(int columnIndex, Calendar cal) throws SQLException {
        Time v = this.rowStore.getTime(columnIndex, cal);
        this.columnIndexOfLatestGet = columnIndex;
        return v;
    }

    @Override
    public Timestamp getTimestamp(int columnNumber) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        return this.getTimestampImpl(this.fetchColumnIndex(columnNumber), null);
    }

    @Override
    public Timestamp getTimestamp(int columnNumber, Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        return this.getTimestampImpl(this.fetchColumnIndex(columnNumber), cal);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        return this.getTimestampImpl(this.fetchColumnIndex(columnLabel), null);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        return this.getTimestampImpl(this.fetchColumnIndex(columnLabel), cal);
    }

    private Timestamp getTimestampImpl(int columnIndex, Calendar cal) throws SQLException {
        Timestamp v = this.rowStore.getTimestamp(columnIndex, cal);
        this.columnIndexOfLatestGet = columnIndex;
        return v;
    }

    @Override
    public String getString(int columnNumber) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        return this.getStringImpl(this.fetchColumnIndex(columnNumber));
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        return this.getStringImpl(this.fetchColumnIndex(columnLabel));
    }

    @Override
    public String getNString(int columnNumber) throws SQLException {
        return this.getString(columnNumber);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getString(columnLabel);
    }

    private String getStringImpl(int columnIndex) throws SQLException {
        String v = this.rowStore.getString(columnIndex);
        this.columnIndexOfLatestGet = columnIndex;
        return v;
    }

    @Override
    public byte[] getBytes(int columnNumber) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        return this.getBytesImpl(this.fetchColumnIndex(columnNumber));
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        return this.getBytesImpl(this.fetchColumnIndex(columnLabel));
    }

    private byte[] getBytesImpl(int columnIndex) throws SQLException {
        byte[] v = this.rowStore.getBinary(columnIndex);
        this.columnIndexOfLatestGet = columnIndex;
        return v;
    }

    @Override
    public Object getObject(int columnNumber) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        return this.getObjectImpl(this.fetchColumnIndex(columnNumber));
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        return this.getObjectImpl(this.fetchColumnIndex(columnLabel));
    }

    @Override
    public <T> T getObject(int columnNumber, Class<T> type) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        if (type == null) {
            throw this.getErrorReporter().errorParameterValueNotSupported("type");
        }
        return this.getObjectImpl(this.fetchColumnIndex(columnNumber), type);
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        if (type == null) {
            throw this.getErrorReporter().errorParameterValueNotSupported("type");
        }
        return this.getObjectImpl(this.fetchColumnIndex(columnLabel), type);
    }

    private Object getObjectImpl(int columnIndex) throws SQLException {
        ADBColumn column = this.metadata.getColumnByIndex(columnIndex);
        return this.getObjectImpl(columnIndex, column.getType().getJavaClass());
    }

    private <T> T getObjectImpl(int columnIndex, Class<T> type) throws SQLException {
        T v = this.rowStore.getObject(columnIndex, type);
        this.columnIndexOfLatestGet = columnIndex;
        return v;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "getObject");
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "getObject");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        return this.getBinaryStreamImpl(this.fetchColumnIndex(columnIndex));
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        return this.getBinaryStreamImpl(this.fetchColumnIndex(columnLabel));
    }

    private InputStream getBinaryStreamImpl(int columnIndex) throws SQLException {
        InputStream v = this.rowStore.getInputStream(columnIndex);
        this.columnIndexOfLatestGet = columnIndex;
        return v;
    }

    @Override
    public Reader getCharacterStream(int columnNumber) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        return this.getCharacterStreamImpl(this.fetchColumnIndex(columnNumber));
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        return this.getCharacterStreamImpl(this.fetchColumnIndex(columnLabel));
    }

    private Reader getCharacterStreamImpl(int columnIndex) throws SQLException {
        Reader v = this.rowStore.getCharacterStream(columnIndex);
        this.columnIndexOfLatestGet = columnIndex;
        return v;
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.getCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(columnLabel);
    }

    @Override
    public InputStream getAsciiStream(int columnNumber) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        return this.getAsciiStreamImpl(this.fetchColumnIndex(columnNumber));
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        return this.getAsciiStreamImpl(this.fetchColumnIndex(columnLabel));
    }

    private InputStream getAsciiStreamImpl(int columnIndex) throws SQLException {
        String value = this.getStringImpl(columnIndex);
        return value != null ? new ByteArrayInputStream(value.getBytes(StandardCharsets.US_ASCII)) : null;
    }

    @Override
    public InputStream getUnicodeStream(int columnNumber) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        return this.getUnicodeStreamImpl(this.fetchColumnIndex(columnNumber));
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        this.checkClosed();
        this.checkCursorPosition();
        return this.getUnicodeStreamImpl(this.fetchColumnIndex(columnLabel));
    }

    private InputStream getUnicodeStreamImpl(int columnIndex) throws SQLException {
        String value = this.getStringImpl(columnIndex);
        return value != null ? new ByteArrayInputStream(value.getBytes(StandardCharsets.UTF_16)) : null;
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "getRef");
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "getRef");
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "getRowId");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "getRowId");
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "getURL");
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "getURL");
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "getArray");
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "getArray");
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "getBlob");
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "getBlob");
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "getClob");
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "getClob");
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "getNClob");
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "getNClob");
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "getSQLXML");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "getSQLXML");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateArray");
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateArray");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateAsciiStream");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateAsciiStream");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateAsciiStream");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateAsciiStream");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateAsciiStream");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateAsciiStream");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateBigDecimal");
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateBigDecimal");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateBinaryStream");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateBinaryStream");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateBinaryStream");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateBinaryStream");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateBinaryStream");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateBinaryStream");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateBlob");
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateBlob");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateBlob");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateBlob");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateBlob");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateBlob");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateBoolean");
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateBoolean");
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateByte");
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateByte");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateBytes");
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateBytes");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateCharacterStream");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateCharacterStream");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateCharacterStream");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateCharacterStream");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateCharacterStream");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateCharacterStream");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateClob");
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateClob");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateClob");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateClob");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateClob");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateClob");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateDate");
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateDate");
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateDouble");
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateDouble");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateFloat");
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateFloat");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateInt");
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateInt");
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateLong");
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateLong");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateNCharacterStream");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateNCharacterStream");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateNCharacterStream");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateNCharacterStream");
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateNClob");
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateNClob");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateNClob");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateNClob");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateNClob");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateNClob");
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateNString");
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateNString");
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateNull");
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateNull");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateObject");
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateObject");
    }

    @Override
    public void updateObject(int columnIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateObject");
    }

    @Override
    public void updateObject(String columnLabel, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateObject");
    }

    @Override
    public void updateObject(int columnIndex, Object x, SQLType targetSqlType) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateObject");
    }

    @Override
    public void updateObject(String columnLabel, Object x, SQLType targetSqlType) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateObject");
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateObject");
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateObject");
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateRef");
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateRef");
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateRowId");
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateRowId");
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateSQLXML");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateSQLXML");
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateShort");
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateShort");
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateString");
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateString");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateTime");
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateTime");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateTimestamp");
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateTimestamp");
    }

    @Override
    public void insertRow() throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "insertRow");
    }

    @Override
    public void updateRow() throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "updateRow");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "deleteRow");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "refreshRow");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "moveToInsertRow");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "moveToCurrentRow");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "rowInserted");
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "rowUpdated");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "rowDeleted");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(ResultSet.class, "cancelRowUpdates");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
    }

    @Override
    protected ADBErrorReporter getErrorReporter() {
        return this.metadata.getErrorReporter();
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.checkClosed();
        return this.metadata.statement.getResultSetStatement(this);
    }

    @Override
    public String getCursorName() throws SQLException {
        this.checkClosed();
        return "";
    }

    @Override
    public int getType() throws SQLException {
        this.checkClosed();
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkClosed();
        return 1007;
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkClosed();
        return 1;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return 1000;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkClosed();
        if (direction != 1000) {
            throw this.getErrorReporter().errorParameterValueNotSupported("direction");
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return 1;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
    }
}

