/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.byon;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Node {
    private final String id;
    private final String name;
    private final String description;
    private final String hostname;
    private final String locationId;
    private final String osArch;
    private final String osFamily;
    private final String osDescription;
    private final String osVersion;
    private final int loginPort;
    private final boolean os64Bit;
    private final String group;
    private final Set<String> tags;
    private final Map<String, String> metadata;
    private final String username;
    private final String credential;
    private final URI credentialUrl;
    private final String sudoPassword;

    public static Builder builder() {
        return new Builder();
    }

    public Node(String id, String name, String description, String hostname, String locationId, String osArch, String osFamily, String osDescription, String osVersion, boolean os64Bit, int loginPort, String group, Iterable<String> tags, Map<String, String> metadata, String username, String credential, URI credentialUrl, String sudoPassword) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.hostname = hostname;
        this.locationId = locationId;
        this.osArch = osArch;
        this.osFamily = osFamily;
        this.osDescription = osDescription;
        this.osVersion = osVersion;
        this.os64Bit = os64Bit;
        this.loginPort = loginPort;
        this.group = group;
        this.tags = ImmutableSet.copyOf(tags);
        this.metadata = ImmutableMap.copyOf(metadata);
        this.username = username;
        this.credential = credential;
        this.credentialUrl = credentialUrl;
        this.sudoPassword = sudoPassword;
    }

    public String getId() {
        return this.id;
    }

    public String getLocationId() {
        return this.locationId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getGroup() {
        return this.group;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getOsArch() {
        return this.osArch;
    }

    public String getOsFamily() {
        return this.osFamily;
    }

    public String getOsDescription() {
        return this.osDescription;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public boolean isOs64Bit() {
        return this.os64Bit;
    }

    public int getLoginPort() {
        return this.loginPort;
    }

    public Set<String> getTags() {
        HashSet tagSet = Sets.newHashSet();
        for (String tag : this.tags) {
            tagSet.add(tag);
        }
        return tagSet;
    }

    public Map<String, String> getMetadata() {
        return Maps.newLinkedHashMap(this.metadata);
    }

    public String getUsername() {
        return this.username;
    }

    public String getCredential() {
        return this.credential;
    }

    public URI getCredentialUrl() {
        return this.credentialUrl;
    }

    public String getSudoPassword() {
        return this.sudoPassword;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Node)) {
            return false;
        }
        Node that = (Node)obj;
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.description, (Object)that.description) && Objects.equal((Object)this.hostname, (Object)that.hostname) && Objects.equal((Object)this.locationId, (Object)that.locationId) && Objects.equal((Object)this.osArch, (Object)that.osArch) && Objects.equal((Object)this.osFamily, (Object)that.osFamily) && Objects.equal((Object)this.osDescription, (Object)that.osDescription) && Objects.equal((Object)this.osVersion, (Object)that.osVersion) && Objects.equal((Object)this.loginPort, (Object)that.loginPort) && Objects.equal((Object)this.os64Bit, (Object)that.os64Bit) && Objects.equal((Object)this.group, (Object)that.group) && Objects.equal(this.tags, that.tags) && Objects.equal(this.metadata, that.metadata) && Objects.equal((Object)this.username, (Object)that.username) && Objects.equal((Object)this.sudoPassword, (Object)that.sudoPassword);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("name", (Object)this.name).add("description", (Object)this.description).add("locationId", (Object)this.locationId).add("hostname", (Object)this.hostname).add("osArch", (Object)this.osArch).add("osFamily", (Object)this.osFamily).add("osDescription", (Object)this.osDescription).add("osVersion", (Object)this.osVersion).add("os64Bit", this.os64Bit).add("group", (Object)this.group).add("loginPort", this.loginPort).add("tags", this.tags).add("metadata", this.metadata).add("username", (Object)this.username).add("hasCredential", this.credential != null || this.credentialUrl != null).add("hasSudoPassword", this.sudoPassword != null).toString();
    }

    public static class Builder {
        private String id;
        private String name;
        private String description;
        private String hostname;
        private String locationId;
        private String osArch;
        private String osFamily;
        private String osDescription;
        private String osVersion;
        private boolean os64Bit;
        private int loginPort = 22;
        private String group;
        private Set<String> tags = ImmutableSet.of();
        private Map<String, String> metadata = ImmutableMap.of();
        private String username;
        private String credential;
        private URI credentialUrl;
        private String sudoPassword;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder loginPort(int loginPort) {
            this.loginPort = loginPort;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder osArch(String osArch) {
            this.osArch = osArch;
            return this;
        }

        public Builder osFamily(String osFamily) {
            this.osFamily = osFamily;
            return this;
        }

        public Builder osDescription(String osDescription) {
            this.osDescription = osDescription;
            return this;
        }

        public Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            return this;
        }

        public Builder os64Bit(boolean os64Bit) {
            this.os64Bit = os64Bit;
            return this;
        }

        public Builder group(String group) {
            this.group = group;
            return this;
        }

        public Builder tags(Iterable<String> tags) {
            this.tags = ImmutableSet.copyOf(tags);
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = ImmutableMap.copyOf(metadata);
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder credential(String credential) {
            this.credential = credential;
            return this;
        }

        public Builder credentialUrl(URI credentialUrl) {
            this.credentialUrl = credentialUrl;
            return this;
        }

        public Builder sudoPassword(String sudoPassword) {
            this.sudoPassword = sudoPassword;
            return this;
        }

        public Node build() {
            return new Node(this.id, this.name, this.description, this.hostname, this.locationId, this.osArch, this.osFamily, this.osDescription, this.osVersion, this.os64Bit, this.loginPort, this.group, this.tags, this.metadata, this.username, this.credential, this.credentialUrl, this.sudoPassword);
        }
    }
}

