/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.ConfigMapFluentImpl;

public class ConfigMapBuilder
extends ConfigMapFluentImpl<ConfigMapBuilder>
implements VisitableBuilder<ConfigMap, ConfigMapBuilder> {
    ConfigMapFluent<?> fluent;
    Boolean validationEnabled;

    public ConfigMapBuilder() {
        this(true);
    }

    public ConfigMapBuilder(Boolean validationEnabled) {
        this(new ConfigMap(), validationEnabled);
    }

    public ConfigMapBuilder(ConfigMapFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ConfigMapBuilder(ConfigMapFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ConfigMap(), validationEnabled);
    }

    public ConfigMapBuilder(ConfigMapFluent<?> fluent, ConfigMap instance) {
        this(fluent, instance, true);
    }

    public ConfigMapBuilder(ConfigMapFluent<?> fluent, ConfigMap instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withData(instance.getData());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public ConfigMapBuilder(ConfigMap instance) {
        this(instance, (Boolean)true);
    }

    public ConfigMapBuilder(ConfigMap instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withData(instance.getData());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ConfigMap build() {
        ConfigMap buildable = new ConfigMap(this.fluent.getApiVersion(), this.fluent.getData(), this.fluent.getKind(), this.fluent.getMetadata());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfigMapBuilder that = (ConfigMapBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

