/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.cm.salt;

import com.google.common.annotations.Beta;
import java.util.Set;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.entity.cm.salt.SaltConfig;
import org.apache.brooklyn.entity.cm.salt.SaltEntity;
import org.apache.brooklyn.entity.cm.salt.SaltEntityDriver;
import org.apache.brooklyn.entity.software.base.SoftwareProcessImpl;
import org.apache.brooklyn.util.core.task.system.ProcessTaskWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class SaltEntityImpl
extends SoftwareProcessImpl
implements SaltEntity {
    private static final Logger LOG = LoggerFactory.getLogger(SaltEntityImpl.class);

    public Class getDriverInterface() {
        return SaltEntityDriver.class;
    }

    public SaltEntityDriver getDriver() {
        return (SaltEntityDriver)super.getDriver();
    }

    public void init() {
        super.init();
        Set runList = (Set)this.getConfig((ConfigKey)SaltConfig.START_STATES);
        if (0 == runList.size()) {
            throw new IllegalArgumentException("Must have configuration values for 'start_states' (" + SaltConfig.START_STATES + ")");
        }
        LOG.debug("Run list size is {}", (Object)runList.size());
        for (Object state : runList) {
            LOG.debug("Runlist state: {} ", state);
        }
        Set formulas = (Set)this.getConfig((ConfigKey)SaltConfig.SALT_FORMULAS);
        LOG.debug("Formulas size: {}", (Object)formulas.size());
        for (String formula : formulas) {
            LOG.debug("Formula configured:  {}", (Object)formula);
        }
        SaltConfig.SaltMode mode = (SaltConfig.SaltMode)((Object)this.getConfig(SaltConfig.SALT_MODE));
        LOG.debug("Initialize SaltStack {} mode", (Object)mode.name());
    }

    public void populateServiceNotUpDiagnostics() {
    }

    @Override
    public String saltCall(String spec) {
        ProcessTaskWrapper<Integer> command = this.getDriver().saltCall(spec);
        command.asTask().blockUntilEnded();
        if (0 == command.getExitCode()) {
            return command.getStdout();
        }
        throw new RuntimeException("Command (" + spec + ")  failed with stderr:\n" + command.getStderr() + "\n");
    }
}

