/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.functions;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import java.net.URI;
import javax.inject.Inject;
import org.jclouds.location.functions.RegionToEndpointOrProviderIfNull;
import org.jclouds.s3.Bucket;

public final class AssignCorrectHostnameForBucket
implements Function<Object, URI> {
    private final RegionToEndpointOrProviderIfNull delegate;
    private final Function<String, Optional<String>> bucketToRegion;

    @Inject
    AssignCorrectHostnameForBucket(RegionToEndpointOrProviderIfNull delegate, @Bucket Function<String, Optional<String>> bucketToRegion) {
        this.bucketToRegion = bucketToRegion;
        this.delegate = delegate;
    }

    public URI apply(Object from) {
        String bucket = from.toString();
        Optional region = (Optional)this.bucketToRegion.apply((Object)bucket);
        if (region.isPresent()) {
            return this.delegate.apply(region.get());
        }
        return this.delegate.apply(null);
    }
}

