/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.group.zoneaware;

import com.google.common.base.MoreObjects;
import com.google.common.base.Ticker;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.entity.group.zoneaware.AbstractZoneFailureDetector;
import org.apache.brooklyn.util.time.Duration;

public class ProportionalZoneFailureDetector
extends AbstractZoneFailureDetector {
    protected final int minDatapoints;
    protected final long timeToConsider;
    protected final double maxProportionFailures;

    public ProportionalZoneFailureDetector(int minDatapoints, Duration timeToConsider, double maxProportionFailures) {
        this(minDatapoints, timeToConsider, maxProportionFailures, Ticker.systemTicker());
    }

    public ProportionalZoneFailureDetector(int minDatapoints, Duration timeToConsider, double maxProportionFailures, Ticker ticker) {
        super(ticker);
        this.minDatapoints = minDatapoints;
        this.timeToConsider = timeToConsider.toMilliseconds();
        this.maxProportionFailures = maxProportionFailures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doHasFailed(Location loc, AbstractZoneFailureDetector.ZoneHistory zoneHistory) {
        AbstractZoneFailureDetector.ZoneHistory zoneHistory2 = zoneHistory;
        synchronized (zoneHistory2) {
            zoneHistory.trimOlderThan(this.currentTimeMillis() - this.timeToConsider);
            int numDatapoints = zoneHistory.successes.size() + zoneHistory.failures.size();
            double proportionFailure = (double)zoneHistory.failures.size() / (double)numDatapoints;
            return numDatapoints >= this.minDatapoints && proportionFailure >= this.maxProportionFailures;
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("minDatapoints", this.minDatapoints).add("timeToConsider", this.timeToConsider).add("maxProportionFailures", this.maxProportionFailures).toString();
    }
}

