/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.mongodb.sharding;

import java.util.Collection;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.sensor.DependentConfiguration;
import org.apache.brooklyn.enricher.stock.Enrichers;
import org.apache.brooklyn.entity.group.AbstractGroup;
import org.apache.brooklyn.entity.nosql.mongodb.MongoDBAuthenticationMixins;
import org.apache.brooklyn.entity.nosql.mongodb.MongoDBAuthenticationUtils;
import org.apache.brooklyn.entity.nosql.mongodb.sharding.CoLocatedMongoDBRouter;
import org.apache.brooklyn.entity.nosql.mongodb.sharding.MongoDBConfigServerCluster;
import org.apache.brooklyn.entity.nosql.mongodb.sharding.MongoDBRouter;
import org.apache.brooklyn.entity.software.base.SameServerEntityImpl;

public class CoLocatedMongoDBRouterImpl
extends SameServerEntityImpl
implements CoLocatedMongoDBRouter,
MongoDBAuthenticationMixins {
    public void init() {
        super.init();
        MongoDBRouter router = (MongoDBRouter)this.addChild((EntitySpec)EntitySpec.create(MongoDBRouter.class).configure(MongoDBRouter.CONFIG_SERVERS, DependentConfiguration.attributeWhenReady((Entity)((Entity)this.getConfig(CoLocatedMongoDBRouter.SHARDED_DEPLOYMENT)), MongoDBConfigServerCluster.CONFIG_SERVER_ADDRESSES)));
        for (EntitySpec siblingSpec : (Iterable)this.getConfig(CoLocatedMongoDBRouter.SIBLING_SPECS)) {
            this.addChild(siblingSpec);
        }
        this.sensors().set(ROUTER, (Object)router);
    }

    protected void doStart(Collection<? extends Location> locations) {
        MongoDBRouter router = (MongoDBRouter)this.sensors().get(ROUTER);
        Task clusterTask = DependentConfiguration.attributeWhenReady((Entity)router, (AttributeSensor)AbstractGroup.FIRST);
        Entities.submit((Entity)this, (TaskAdaptable)clusterTask);
        clusterTask.getUnchecked();
        MongoDBAuthenticationUtils.setAuthenticationConfig(router, (Entity)this);
        router.sensors().set(MongoDBAuthenticationMixins.ROOT_PASSWORD, router.config().get(MongoDBAuthenticationMixins.ROOT_PASSWORD));
        router.sensors().set(MongoDBAuthenticationMixins.ROOT_USERNAME, router.config().get(MongoDBAuthenticationMixins.ROOT_USERNAME));
        router.sensors().set(MongoDBAuthenticationMixins.AUTHENTICATION_DATABASE, router.config().get(MongoDBAuthenticationMixins.AUTHENTICATION_DATABASE));
        this.enrichers().add(((Enrichers.PropagatorBuilder)Enrichers.builder().propagating(new Sensor[]{MongoDBRouter.PORT}).from((Entity)router)).build());
        super.doStart(locations);
        this.sensors().set(Startable.SERVICE_UP, (Object)true);
    }
}

