/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.entitlement;

import com.google.common.annotations.Beta;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementClass;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementContext;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementManager;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public abstract class EntitlementManagerAdapter
implements EntitlementManager {
    private static final Logger log = LoggerFactory.getLogger(EntitlementManagerAdapter.class);

    public <T> boolean isEntitled(EntitlementContext context, EntitlementClass<T> entitlementClass, T entitlementClassArgument) {
        if (log.isTraceEnabled()) {
            log.trace("Checking entitlement of " + context + " to " + entitlementClass + " " + entitlementClassArgument);
        }
        if (this.isEntitledToRoot(context)) {
            return true;
        }
        Handler handler = new Handler(context);
        return Entitlements.EntitlementClassesEnum.of(entitlementClass).handle(handler, entitlementClassArgument);
    }

    protected abstract boolean isEntitledToSeeCatalogItem(EntitlementContext var1, String var2);

    protected abstract boolean isEntitledToAddCatalogItem(EntitlementContext var1, Object var2);

    protected abstract boolean isEntitledToModifyCatalogItem(EntitlementContext var1, String var2, Object var3);

    protected abstract boolean isEntitledToSeeSensor(EntitlementContext var1, Entity var2, String var3);

    protected abstract boolean isEntitledToSeeEntity(EntitlementContext var1, Entity var2);

    protected abstract boolean isEntitledToInvokeEffector(EntitlementContext var1, Entity var2, String var3, Object var4);

    protected abstract boolean isEntitledToModifyEntity(EntitlementContext var1, Entity var2);

    protected abstract boolean isEntitledToDeployApplication(EntitlementContext var1, Object var2);

    protected abstract boolean isEntitledToAddJava(EntitlementContext var1, Object var2);

    protected abstract boolean isEntitledToAddBom(EntitlementContext var1, Object var2);

    protected abstract boolean isEntitledToSeeAllServerInfo(EntitlementContext var1);

    protected abstract boolean isEntitledToSeeServerStatus(EntitlementContext var1);

    protected abstract boolean isEntitledToExecuteGroovyScripts(EntitlementContext var1);

    protected abstract boolean isEntitledToExecuteScripts(EntitlementContext var1);

    protected abstract boolean isEntitledToRoot(EntitlementContext var1);

    protected class Handler
    implements Entitlements.EntitlementClassesHandler<Boolean> {
        final EntitlementContext context;

        protected Handler(EntitlementContext context) {
            this.context = context;
        }

        @Override
        public Boolean handleSeeCatalogItem(String catalogItemId) {
            return EntitlementManagerAdapter.this.isEntitledToSeeCatalogItem(this.context, catalogItemId);
        }

        @Override
        public Boolean handleAddCatalogItem(Object catalogItemBeingAdded) {
            return EntitlementManagerAdapter.this.isEntitledToAddCatalogItem(this.context, catalogItemBeingAdded);
        }

        @Override
        public Boolean handleModifyCatalogItem(Entitlements.StringAndArgument catalogItemIdAndModification) {
            return EntitlementManagerAdapter.this.isEntitledToModifyCatalogItem(this.context, catalogItemIdAndModification == null ? null : catalogItemIdAndModification.getString(), catalogItemIdAndModification == null ? null : catalogItemIdAndModification.getArgument());
        }

        @Override
        public Boolean handleSeeEntity(Entity entity) {
            return EntitlementManagerAdapter.this.isEntitledToSeeEntity(this.context, entity);
        }

        @Override
        public Boolean handleSeeSensor(Entitlements.EntityAndItem<String> sensorInfo) {
            return EntitlementManagerAdapter.this.isEntitledToSeeSensor(this.context, sensorInfo.getEntity(), sensorInfo.getItem());
        }

        @Override
        public Boolean handleInvokeEffector(Entitlements.EntityAndItem<Entitlements.StringAndArgument> effectorInfo) {
            Entitlements.StringAndArgument item = effectorInfo.getItem();
            return EntitlementManagerAdapter.this.isEntitledToInvokeEffector(this.context, effectorInfo.getEntity(), item == null ? null : item.getString(), item == null ? null : item.getArgument());
        }

        @Override
        public Boolean handleModifyEntity(Entity entity) {
            return EntitlementManagerAdapter.this.isEntitledToModifyEntity(this.context, entity);
        }

        @Override
        public Boolean handleDeployApplication(Object app) {
            return EntitlementManagerAdapter.this.isEntitledToDeployApplication(this.context, app);
        }

        @Override
        public Boolean handleAddJava(Object app) {
            return EntitlementManagerAdapter.this.isEntitledToAddJava(this.context, app);
        }

        @Override
        public Boolean handleSeeAllServerInfo() {
            return EntitlementManagerAdapter.this.isEntitledToSeeAllServerInfo(this.context);
        }

        @Override
        public Boolean handleSeeServerStatus() {
            return EntitlementManagerAdapter.this.isEntitledToSeeServerStatus(this.context);
        }

        @Override
        public Boolean handleExecuteGroovyScript() {
            return EntitlementManagerAdapter.this.isEntitledToExecuteGroovyScripts(this.context);
        }

        @Override
        public Boolean handleExecuteScript() {
            return EntitlementManagerAdapter.this.isEntitledToExecuteScripts(this.context);
        }

        @Override
        public Boolean handleRoot() {
            return EntitlementManagerAdapter.this.isEntitledToRoot(this.context);
        }
    }
}

