/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.datanode;

import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import org.apache.cayenne.access.dbsync.CreateIfNoSchemaStrategy;
import org.apache.cayenne.access.dbsync.SkipSchemaUpdateStrategy;
import org.apache.cayenne.access.dbsync.ThrowOnPartialOrCreateSchemaStrategy;
import org.apache.cayenne.access.dbsync.ThrowOnPartialSchemaStrategy;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.event.DataNodeEvent;
import org.apache.cayenne.configuration.runtime.XMLPoolingDataSourceFactory;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.pref.PreferenceDialog;
import org.apache.cayenne.modeler.editor.datanode.CustomDataSourceEditor;
import org.apache.cayenne.modeler.editor.datanode.DataNodeEditor;
import org.apache.cayenne.modeler.editor.datanode.DataSourceEditor;
import org.apache.cayenne.modeler.editor.datanode.JDBCDataSourceEditor;
import org.apache.cayenne.modeler.editor.datanode.MainDataNodeView;
import org.apache.cayenne.modeler.pref.DBConnectionInfo;
import org.apache.cayenne.modeler.pref.DataNodeDefaults;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.modeler.util.ProjectUtil;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.cayenne.swing.BindingDelegate;
import org.apache.cayenne.swing.ObjectBinding;
import org.apache.cayenne.validation.ValidationException;

public class MainDataNodeEditor
extends CayenneController {
    protected static final String NO_LOCAL_DATA_SOURCE = "Select DataSource for Local Work...";
    private static final String XML_POOLING_DATA_SOURCE_FACTORY = XMLPoolingDataSourceFactory.class.getName();
    private static final String[] STANDARD_DATA_SOURCE_FACTORIES = new String[]{DataSourceFactoryType.CAYENNE.getLabel(), DataSourceFactoryType.CUSTOM.getLabel()};
    private static final String[] STANDARD_SCHEMA_UPDATE_STRATEGY = new String[]{SkipSchemaUpdateStrategy.class.getName(), CreateIfNoSchemaStrategy.class.getName(), ThrowOnPartialSchemaStrategy.class.getName(), ThrowOnPartialOrCreateSchemaStrategy.class.getName()};
    protected MainDataNodeView view;
    protected DataNodeEditor tabbedPaneController;
    protected DataNodeDescriptor node;
    protected Map<String, DataSourceEditor> datasourceEditors;
    protected CustomDataSourceEditor defaultSubeditor;
    protected BindingDelegate nodeChangeProcessor;
    protected ObjectBinding[] bindings;
    protected ObjectBinding localDataSourceBinding;

    public MainDataNodeEditor(ProjectController parent, DataNodeEditor tabController) {
        super(parent);
        this.tabbedPaneController = tabController;
        this.view = new MainDataNodeView();
        this.datasourceEditors = new HashMap<String, DataSourceEditor>();
        this.nodeChangeProcessor = (binding, oldValue, newValue) -> {
            DataNodeEvent e = new DataNodeEvent((Object)this, this.node);
            if (binding != null && binding.getView() == this.view.getDataNodeName()) {
                e.setOldName(oldValue != null ? oldValue.toString() : null);
            }
            ((ProjectController)this.getParent()).fireDataNodeEvent(e);
        };
        this.defaultSubeditor = new CustomDataSourceEditor(parent, this.nodeChangeProcessor);
        this.initController();
    }

    @Override
    public Component getView() {
        return this.view;
    }

    public String getFactoryName() {
        return XML_POOLING_DATA_SOURCE_FACTORY.equals(this.node.getDataSourceFactoryType()) ? DataSourceFactoryType.CAYENNE.getLabel() : DataSourceFactoryType.CUSTOM.getLabel();
    }

    public void setFactoryName(String factoryName) {
        if (this.node != null) {
            if (DataSourceFactoryType.CAYENNE.getLabel().equals(factoryName)) {
                this.node.setDataSourceFactoryType(XML_POOLING_DATA_SOURCE_FACTORY);
            } else {
                this.node.setDataSourceFactoryType(this.defaultSubeditor.getFactoryName());
            }
            this.showDataSourceSubview(factoryName);
        }
    }

    public String getSchemaUpdateStrategy() {
        return this.node != null ? this.node.getSchemaUpdateStrategyType() : null;
    }

    public void setSchemaUpdateStrategy(String schemaUpdateStrategy) {
        if (this.node != null) {
            this.node.setSchemaUpdateStrategyType(schemaUpdateStrategy);
        }
    }

    public String getNodeName() {
        return this.node != null ? this.node.getName() : null;
    }

    public void setNodeName(String newName) {
        if (this.node == null) {
            return;
        }
        if (newName == null) {
            throw new ValidationException("Empty DataNode Name", new Object[0]);
        }
        ProjectController parent = (ProjectController)this.getParent();
        DataNodeDefaults oldPref = parent.getDataNodePreferences();
        DataChannelDescriptor dataChannelDescriptor = (DataChannelDescriptor)this.getApplication().getProject().getRootNode();
        Collection<DataNodeDescriptor> matchingNode = dataChannelDescriptor.getNodeDescriptors();
        for (DataNodeDescriptor node : matchingNode) {
            if (!node.getName().equals(newName)) continue;
            throw new ValidationException("There is another DataNode named '" + newName + "'. Use a different name.", new Object[0]);
        }
        ProjectUtil.setDataNodeName(this.node, newName);
        oldPref.copyPreferences(newName);
    }

    protected void initController() {
        this.view.getDataSourceDetail().add((Component)this.defaultSubeditor.getView(), "default");
        this.view.getFactories().setEditable(false);
        this.view.getFactories().setModel(new DefaultComboBoxModel<String>(STANDARD_DATA_SOURCE_FACTORIES));
        this.view.getSchemaUpdateStrategy().setEditable(true);
        this.view.getSchemaUpdateStrategy().setModel(new DefaultComboBoxModel<String>(STANDARD_SCHEMA_UPDATE_STRATEGY));
        ((ProjectController)this.getParent()).addDataNodeDisplayListener(e -> this.refreshView(e.getDataNode()));
        this.getView().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                MainDataNodeEditor.this.refreshView(MainDataNodeEditor.this.node != null ? MainDataNodeEditor.this.node : ((ProjectController)MainDataNodeEditor.this.getParent()).getCurrentDataNode());
            }
        });
        BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), this);
        this.localDataSourceBinding = builder.bindToComboSelection(this.view.getLocalDataSources(), "parent.dataNodePreferences.localDataSource", NO_LOCAL_DATA_SOURCE);
        builder.setDelegate(this.nodeChangeProcessor);
        this.bindings = new ObjectBinding[4];
        this.bindings[0] = builder.bindToTextField(this.view.getDataNodeName(), "nodeName");
        this.bindings[1] = builder.bindToComboSelection(this.view.getFactories(), "factoryName");
        this.bindings[2] = builder.bindToComboSelection(this.view.getSchemaUpdateStrategy(), "schemaUpdateStrategy");
        this.bindings[3] = builder.bindToTextField(this.view.getCustomAdapter(), "adapterName");
        builder.bindToAction(this.view.getConfigLocalDataSources(), "dataSourceConfigAction()");
    }

    public void dataSourceConfigAction() {
        PreferenceDialog prefs = new PreferenceDialog(this);
        prefs.showDataSourceEditorAction(this.view.getLocalDataSources().getSelectedItem());
        this.refreshLocalDataSources();
    }

    protected void refreshLocalDataSources() {
        Map sources = this.getApplication().getCayenneProjectPreferences().getDetailObject(DBConnectionInfo.class).getChildrenPreferences();
        int len = sources.size();
        String[] keys = new String[len + 1];
        keys[0] = NO_LOCAL_DATA_SOURCE;
        String[] dataSources = sources.keySet().toArray(new String[0]);
        System.arraycopy(dataSources, 0, keys, 1, dataSources.length);
        this.view.getLocalDataSources().setModel(new DefaultComboBoxModel<String>(keys));
        this.localDataSourceBinding.updateView();
    }

    protected void refreshView(DataNodeDescriptor node) {
        this.node = node;
        if (node == null) {
            this.getView().setVisible(false);
            return;
        }
        this.refreshLocalDataSources();
        for (ObjectBinding binding : this.bindings) {
            binding.updateView();
        }
        this.showDataSourceSubview(this.getFactoryName());
    }

    protected void showDataSourceSubview(String factoryName) {
        DataSourceEditor c = this.datasourceEditors.get(factoryName);
        if (c == null) {
            if (!DataSourceFactoryType.CAYENNE.getLabel().equals(factoryName)) {
                this.defaultSubeditor.setNode(this.node);
                this.view.getDataSourceDetailLayout().show(this.view.getDataSourceDetail(), "default");
                return;
            }
            c = new JDBCDataSourceEditor((ProjectController)this.getParent(), this.nodeChangeProcessor);
            this.datasourceEditors.put(factoryName, c);
            this.view.getDataSourceDetail().add(c.getView(), factoryName);
            this.view.getDataSourceDetail().getParent().validate();
        }
        c.setNode(this.node);
        this.view.getDataSourceDetailLayout().show(this.view.getDataSourceDetail(), factoryName);
    }

    public String getAdapterName() {
        return this.node.getAdapterType();
    }

    public void setAdapterName(String name) {
        this.node.setAdapterType(name);
    }

    static enum DataSourceFactoryType {
        CAYENNE("Cayenne Data Source Factory"),
        CUSTOM("Custom Data Source Factory");

        private final String label;

        private DataSourceFactoryType(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

