/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validation;

import java.util.function.Supplier;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.runtime.XMLPoolingDataSourceFactory;
import org.apache.cayenne.project.validation.ConfigurationNodeValidator;
import org.apache.cayenne.project.validation.Inspection;
import org.apache.cayenne.project.validation.ValidationConfig;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationResult;

class DataNodeValidator
extends ConfigurationNodeValidator<DataNodeDescriptor> {
    public DataNodeValidator(Supplier<ValidationConfig> configSupplier) {
        super(configSupplier);
    }

    @Override
    public void validate(DataNodeDescriptor node, ValidationResult validationResult) {
        this.on(node, validationResult).performIfEnabled(Inspection.DATA_NODE_NO_NAME, this::checkForName).performIfEnabled(Inspection.DATA_NODE_NAME_DUPLICATE, this::checkForNameDuplicates).performIfEnabled(Inspection.DATA_NODE_CONNECTION_PARAMS, this::validateConnection);
    }

    private void checkForName(DataNodeDescriptor node, ValidationResult validationResult) {
        String name = node.getName();
        if (Util.isEmptyString(name)) {
            this.addFailure(validationResult, node, "Unnamed DataNode", new Object[0]);
        }
    }

    private void checkForNameDuplicates(DataNodeDescriptor node, ValidationResult validationResult) {
        String name = node.getName();
        if (Util.isEmptyString(name)) {
            return;
        }
        DataChannelDescriptor dataChannelDescriptor = node.getDataChannelDescriptor();
        for (DataNodeDescriptor otherNode : dataChannelDescriptor.getNodeDescriptors()) {
            if (otherNode == node || !name.equals(otherNode.getName())) continue;
            this.addFailure(validationResult, node, "Duplicate DataNode name: %s", name);
            return;
        }
    }

    private void validateConnection(DataNodeDescriptor node, ValidationResult validationResult) {
        String factory = node.getDataSourceFactoryType();
        if (factory == null || XMLPoolingDataSourceFactory.class.getName().equals(factory)) {
            return;
        }
        String parameters = node.getParameters();
        if (Util.isEmptyString(parameters)) {
            this.addFailure(validationResult, node, "DataNode has empty 'parameters' string", new Object[0]);
        }
    }
}

