/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.List;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.QueryLogger;
import org.apache.cayenne.access.ResultIterator;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.query.BatchQuery;
import org.apache.cayenne.query.InsertBatchQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DataDomainFlushObserver
implements OperationObserver {
    DataDomainFlushObserver() {
    }

    @Override
    public void nextQueryException(Query query, Exception ex) {
        throw new CayenneRuntimeException("Raising from query exception.", Util.unwindException(ex));
    }

    @Override
    public void nextGlobalException(Exception ex) {
        throw new CayenneRuntimeException("Raising from underlyingQueryEngine exception.", Util.unwindException(ex));
    }

    @Override
    public void nextGeneratedRows(Query query, ResultIterator keysIterator) {
        List<?> keys;
        try {
            keys = keysIterator.allRows();
        }
        catch (CayenneException ex) {
            throw new CayenneRuntimeException("Error reading primary key", Util.unwindException(ex));
        }
        finally {
            try {
                keysIterator.close();
            }
            catch (CayenneException e) {
                throw new CayenneRuntimeException("Error closing primary key result set", Util.unwindException(e));
            }
        }
        if (!(query instanceof InsertBatchQuery)) {
            throw new CayenneRuntimeException("Generated keys only supported for InsertBatchQuery, instead got " + query);
        }
        BatchQuery batch = (BatchQuery)query;
        ObjectId id = batch.getObjectId();
        if (id == null || !id.isTemporary()) {
            return;
        }
        if (keys.size() != 1) {
            throw new CayenneRuntimeException("One and only one PK row is expected, instead got " + keys.size());
        }
        DataRow key = (DataRow)keys.get(0);
        if (key.size() == 0) {
            throw new CayenneRuntimeException("Empty key generated.");
        }
        if (key.size() > 1) {
            throw new CayenneRuntimeException("Only a single column autogenerated PK is supported. Generated key: " + key);
        }
        for (DbAttribute attribute : batch.getDbEntity().getGeneratedAttributes()) {
            if (!attribute.isPrimaryKey()) continue;
            Object value = key.values().iterator().next();
            QueryLogger.logGeneratedKey(attribute, value);
            id.getReplacementIdMap().put(attribute.getName(), value);
            break;
        }
    }

    @Override
    public void nextBatchCount(Query query, int[] resultCount) {
    }

    @Override
    public void nextCount(Query query, int resultCount) {
    }

    @Override
    public void nextRows(Query query, List<?> dataRows) {
    }

    @Override
    public void nextRows(Query q, ResultIterator it) {
        throw new UnsupportedOperationException("'nextDataRows(Query,ResultIterator)' is unsupported (and unexpected) on commit.");
    }

    @Override
    public boolean isIteratedResult() {
        return false;
    }
}

