/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.cayenne.conf.ResourceFinder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceLocator
implements ResourceFinder {
    private static Log logObj = LogFactory.getLog(ResourceLocator.class);
    protected boolean skipAbsolutePath;
    protected boolean skipClasspath;
    protected boolean skipCurrentDirectory;
    protected boolean skipHomeDirectory;
    protected List<String> additionalClassPaths = new ArrayList<String>();
    protected List<String> additionalFilesystemPaths = new ArrayList<String>();
    protected ClassLoader classLoader;

    public static InputStream findResourceInClasspath(String name) {
        try {
            URL url = ResourceLocator.findURLInClasspath(name);
            if (url != null) {
                logObj.debug((Object)("resource found in classpath: " + url));
                return url.openStream();
            }
            logObj.debug((Object)("resource not found in classpath: " + name));
            return null;
        }
        catch (IOException ioex) {
            return null;
        }
    }

    public static InputStream findResourceInFileSystem(String name) {
        try {
            File file = ResourceLocator.findFileInFileSystem(name);
            if (file != null) {
                logObj.debug((Object)("resource found in file system: " + file));
                return new FileInputStream(file);
            }
            logObj.debug((Object)("resource not found in file system: " + name));
            return null;
        }
        catch (IOException ioex) {
            return null;
        }
    }

    public static File findFileInFileSystem(String name) {
        File file = ResourceLocator.findFileInHomeDirectory(name);
        if (file == null) {
            file = ResourceLocator.findFileInCurrentDirectory(name);
        }
        if (file != null) {
            logObj.debug((Object)("file found in file system: " + file));
        } else {
            logObj.debug((Object)("file not found in file system: " + name));
        }
        return file;
    }

    public static File findFileInHomeDirectory(String name) {
        String homeDirPath = System.getProperty("user.home") + File.separator + name;
        try {
            File file = new File(homeDirPath);
            if (file.exists() && file.canRead()) {
                logObj.debug((Object)("file found in home directory: " + file));
            } else {
                file = null;
                logObj.debug((Object)("file not found in home directory: " + name));
            }
            return file;
        }
        catch (SecurityException se) {
            logObj.debug((Object)("permission denied reading file: " + homeDirPath), (Throwable)se);
            return null;
        }
    }

    public static File findFileInCurrentDirectory(String name) {
        String currentDirPath = System.getProperty("user.dir") + File.separator + name;
        try {
            File file = new File(currentDirPath);
            if (file.exists() && file.canRead()) {
                logObj.debug((Object)("file found in current directory: " + file));
            } else {
                logObj.debug((Object)("file not found in current directory: " + name));
                file = null;
            }
            return file;
        }
        catch (SecurityException se) {
            logObj.debug((Object)("permission denied reading file: " + currentDirPath), (Throwable)se);
            return null;
        }
    }

    public static URL findURLInClasspath(String name) {
        ClassLoader classLoader = ResourceLocator.class.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return ResourceLocator.findURLInClassLoader(name, classLoader);
    }

    public static URL findURLInClassLoader(String name, ClassLoader loader) {
        URL url = loader.getResource(name);
        if (url != null) {
            logObj.debug((Object)("URL found with classloader: " + url));
        } else {
            logObj.debug((Object)("URL not found with classloader: " + name));
        }
        return url;
    }

    public static String classBaseUrl(Class<?> aClass) {
        URL selfUrl;
        String pathToClass = aClass.getName().replace('.', '/') + ".class";
        ClassLoader classLoader = aClass.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if ((selfUrl = classLoader.getResource(pathToClass)) == null) {
            return null;
        }
        String urlString = selfUrl.toExternalForm();
        return urlString.substring(0, urlString.length() - pathToClass.length());
    }

    public InputStream findResourceStream(String name) {
        URL url = this.findResource(name);
        if (url == null) {
            return null;
        }
        try {
            return url.openStream();
        }
        catch (IOException ioex) {
            logObj.debug((Object)"Error reading URL, ignoring", (Throwable)ioex);
            return null;
        }
    }

    @Override
    public URL getResource(String name) {
        return this.findResource(name);
    }

    @Override
    public Collection<URL> getResources(String name) {
        URL resource = this.getResource(name);
        return resource != null ? Collections.singleton(resource) : Collections.emptySet();
    }

    public URL findResource(String name) {
        File f;
        if (!this.willSkipAbsolutePath()) {
            f = new File(name);
            if (f.isAbsolute() && f.exists()) {
                logObj.debug((Object)("File found at absolute path: " + name));
                try {
                    return f.toURL();
                }
                catch (MalformedURLException ex) {
                    logObj.debug((Object)"Malformed url, ignoring.", (Throwable)ex);
                }
            } else {
                logObj.debug((Object)("No file at absolute path: " + name));
            }
        }
        if (!this.willSkipHomeDirectory() && (f = ResourceLocator.findFileInHomeDirectory(name)) != null) {
            try {
                return f.toURL();
            }
            catch (MalformedURLException ex) {
                logObj.debug((Object)"Malformed url, ignoring", (Throwable)ex);
            }
        }
        if (!this.willSkipCurrentDirectory() && (f = ResourceLocator.findFileInCurrentDirectory(name)) != null) {
            try {
                return f.toURL();
            }
            catch (MalformedURLException ex) {
                logObj.debug((Object)"Malformed url, ignoring", (Throwable)ex);
            }
        }
        if (!this.additionalFilesystemPaths.isEmpty()) {
            logObj.debug((Object)("searching additional paths: " + this.additionalFilesystemPaths));
            for (String filePath : this.additionalFilesystemPaths) {
                File f2 = new File(filePath, name);
                logObj.debug((Object)("searching for: " + f2.getAbsolutePath()));
                if (!f2.exists()) continue;
                try {
                    return f2.toURL();
                }
                catch (MalformedURLException ex) {
                    logObj.debug((Object)"Malformed URL, ignoring.", (Throwable)ex);
                }
            }
        }
        if (!this.willSkipClasspath()) {
            URL url;
            if (!this.additionalClassPaths.isEmpty()) {
                logObj.debug((Object)("searching additional classpaths: " + this.additionalClassPaths));
                for (String classPath : this.additionalClassPaths) {
                    String fullName = classPath + "/" + name;
                    logObj.debug((Object)("searching for: " + fullName));
                    URL url2 = ResourceLocator.findURLInClassLoader(fullName, this.getClassLoader());
                    if (url2 == null) continue;
                    return url2;
                }
            }
            if ((url = ResourceLocator.findURLInClassLoader(name, this.getClassLoader())) != null) {
                return url;
            }
        }
        return null;
    }

    public URL findDirectoryResource(String name) {
        URL url = this.findResource(name);
        if (url == null) {
            return null;
        }
        try {
            String urlSt = url.toExternalForm();
            return urlSt.endsWith("/") ? url : new URL(urlSt + "/");
        }
        catch (MalformedURLException ex) {
            logObj.debug((Object)"Malformed URL, ignoring.", (Throwable)ex);
            return null;
        }
    }

    public boolean willSkipHomeDirectory() {
        return this.skipHomeDirectory;
    }

    public void setSkipHomeDirectory(boolean skipHomeDir) {
        this.skipHomeDirectory = skipHomeDir;
    }

    public boolean willSkipCurrentDirectory() {
        return this.skipCurrentDirectory;
    }

    public void setSkipCurrentDirectory(boolean skipCurDir) {
        this.skipCurrentDirectory = skipCurDir;
    }

    public boolean willSkipClasspath() {
        return this.skipClasspath;
    }

    public void setSkipClasspath(boolean skipClasspath) {
        this.skipClasspath = skipClasspath;
    }

    public ClassLoader getClassLoader() {
        ClassLoader loader = this.classLoader;
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        return loader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public boolean willSkipAbsolutePath() {
        return this.skipAbsolutePath;
    }

    public void setSkipAbsolutePath(boolean skipAbsPath) {
        this.skipAbsolutePath = skipAbsPath;
    }

    public void addClassPath(String customPath) {
        this.additionalClassPaths.add(customPath);
    }

    public void addFilesystemPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Path must not be null.");
        }
        this.additionalFilesystemPaths.add(path);
    }

    public void addFilesystemPath(File path) {
        if (path == null || !path.isDirectory()) {
            throw new IllegalArgumentException("Path '" + path + "' is not a directory.");
        }
        this.addFilesystemPath(path.getPath());
    }
}

