/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.beanutils;

import java.util.Map;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.commons.configuration.beanutils.BeanDeclaration;
import org.apache.commons.configuration.beanutils.XMLBeanDeclaration;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.junit.Assert;
import org.junit.Test;

public class TestXMLBeanDeclaration {
    static final String[] TEST_PROPS = new String[]{"firstName", "lastName", "department", "age", "hobby"};
    static final String[] TEST_VALUES = new String[]{"John", "Smith", "Engineering", "42", "TV"};
    static final String[] COMPLEX_PROPS = new String[]{"address", "car"};
    static final String[] COMPLEX_CLASSES = new String[]{"org.apache.commons.configuration.test.AddressTest", "org.apache.commons.configuration.test.CarTest"};
    static final String[][] COMPLEX_ATTRIBUTES = new String[][]{{"street", "zip", "city", "country"}, {"brand", "color"}};
    static final String[][] COMPLEX_VALUES = new String[][]{{"Baker Street", "12354", "London", "UK"}, {"Bentley", "silver"}};
    static final String KEY = "myBean";
    static final String VARS = "variables.";
    XMLBeanDeclaration decl;

    @Test(expected=IllegalArgumentException.class)
    public void testInitFromNullNode() {
        this.decl = new XMLBeanDeclaration(new HierarchicalConfiguration().configurationAt(null), (ConfigurationNode)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInitFromNullConfiguration() {
        this.decl = new XMLBeanDeclaration((HierarchicalConfiguration)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInitFromNullConfigurationAndKey() {
        this.decl = new XMLBeanDeclaration(null, KEY);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInitFromNullConfigurationAndNode() {
        this.decl = new XMLBeanDeclaration(null, (ConfigurationNode)new HierarchicalConfiguration().getRoot());
    }

    @Test
    public void testGetBeanClassName() {
        HierarchicalConfiguration config = new HierarchicalConfiguration();
        config.addProperty("myBean[@config-class]", (Object)this.getClass().getName());
        this.decl = new XMLBeanDeclaration(config, KEY);
        Assert.assertEquals((String)"Wrong class name", (Object)this.getClass().getName(), (Object)this.decl.getBeanClassName());
    }

    @Test
    public void testGetBeanClassNameUndefined() {
        this.decl = new XMLBeanDeclaration(new HierarchicalConfiguration());
        Assert.assertNull((Object)this.decl.getBeanClassName());
    }

    @Test
    public void testGetBeanFactoryName() {
        HierarchicalConfiguration config = new HierarchicalConfiguration();
        config.addProperty("myBean[@config-factory]", (Object)"myFactory");
        this.decl = new XMLBeanDeclaration(config, KEY);
        Assert.assertEquals((String)"Wrong factory name", (Object)"myFactory", (Object)this.decl.getBeanFactoryName());
    }

    @Test
    public void testGetBeanFactoryNameUndefined() {
        this.decl = new XMLBeanDeclaration(new HierarchicalConfiguration());
        Assert.assertNull((Object)this.decl.getBeanFactoryName());
    }

    @Test
    public void testGetBeanFactoryParameter() {
        HierarchicalConfiguration config = new HierarchicalConfiguration();
        config.addProperty("myBean[@config-factoryParam]", (Object)"myFactoryParameter");
        this.decl = new XMLBeanDeclaration(config, KEY);
        Assert.assertEquals((String)"Wrong factory parameter", (Object)"myFactoryParameter", (Object)this.decl.getBeanFactoryParameter());
    }

    @Test
    public void testGetBeanFactoryParameterUndefined() {
        this.decl = new XMLBeanDeclaration(new HierarchicalConfiguration());
        Assert.assertNull((Object)this.decl.getBeanFactoryParameter());
    }

    @Test
    public void testGetBeanProperties() {
        HierarchicalConfiguration config = new HierarchicalConfiguration();
        this.setupBeanDeclaration(config, KEY, TEST_PROPS, TEST_VALUES);
        this.decl = new XMLBeanDeclaration(config, KEY);
        this.checkProperties((BeanDeclaration)this.decl, TEST_PROPS, TEST_VALUES);
    }

    @Test
    public void testGetBeanPropertiesWithReservedAttributes() {
        HierarchicalConfiguration config = new HierarchicalConfiguration();
        this.setupBeanDeclaration(config, KEY, TEST_PROPS, TEST_VALUES);
        config.addProperty("myBean[@config-testattr]", (Object)"yes");
        config.addProperty("myBean[@config-anothertest]", (Object)"this, too");
        this.decl = new XMLBeanDeclaration(config, KEY);
        this.checkProperties((BeanDeclaration)this.decl, TEST_PROPS, TEST_VALUES);
    }

    @Test
    public void testGetBeanPropertiesEmpty() {
        this.decl = new XMLBeanDeclaration(new HierarchicalConfiguration());
        Map props = this.decl.getBeanProperties();
        Assert.assertTrue((String)"Properties found", (props == null || props.isEmpty() ? 1 : 0) != 0);
    }

    private HierarchicalConfiguration prepareNestedBeanDeclarations() {
        HierarchicalConfiguration config = new HierarchicalConfiguration();
        this.setupBeanDeclaration(config, KEY, TEST_PROPS, TEST_VALUES);
        for (int i = 0; i < COMPLEX_PROPS.length; ++i) {
            this.setupBeanDeclaration(config, "myBean." + COMPLEX_PROPS[i], COMPLEX_ATTRIBUTES[i], COMPLEX_VALUES[i]);
            config.addProperty("myBean." + COMPLEX_PROPS[i] + "[@config-class]", (Object)COMPLEX_CLASSES[i]);
        }
        return config;
    }

    @Test
    public void testGetNestedBeanDeclarations() {
        HierarchicalConfiguration config = this.prepareNestedBeanDeclarations();
        this.decl = new XMLBeanDeclaration(config, KEY);
        this.checkProperties((BeanDeclaration)this.decl, TEST_PROPS, TEST_VALUES);
        Map nested = this.decl.getNestedBeanDeclarations();
        Assert.assertEquals((String)"Wrong number of nested declarations", (long)COMPLEX_PROPS.length, (long)nested.size());
        for (int i = 0; i < COMPLEX_PROPS.length; ++i) {
            XMLBeanDeclaration d = (XMLBeanDeclaration)nested.get(COMPLEX_PROPS[i]);
            Assert.assertNotNull((String)("No declaration found for " + COMPLEX_PROPS[i]), (Object)d);
            this.checkProperties((BeanDeclaration)d, COMPLEX_ATTRIBUTES[i], COMPLEX_VALUES[i]);
            Assert.assertEquals((String)"Wrong bean class", (Object)COMPLEX_CLASSES[i], (Object)d.getBeanClassName());
        }
    }

    @Test
    public void testGetNestedBeanDeclarationsFactoryMethod() {
        HierarchicalConfiguration config = this.prepareNestedBeanDeclarations();
        this.decl = new XMLBeanDeclaration(config, KEY){

            protected BeanDeclaration createBeanDeclaration(ConfigurationNode node) {
                return new XMLBeanDeclarationTestImpl(this.getConfiguration().configurationAt(node.getName()), node);
            }
        };
        Map nested = this.decl.getNestedBeanDeclarations();
        for (int i = 0; i < COMPLEX_PROPS.length; ++i) {
            Object d = nested.get(COMPLEX_PROPS[i]);
            Assert.assertTrue((String)("Wrong class for bean declaration: " + d), (boolean)(d instanceof XMLBeanDeclarationTestImpl));
        }
    }

    @Test
    public void testGetNestedBeanDeclarationsEmpty() {
        HierarchicalConfiguration config = new HierarchicalConfiguration();
        this.setupBeanDeclaration(config, KEY, TEST_PROPS, TEST_VALUES);
        this.decl = new XMLBeanDeclaration(config, KEY);
        Map nested = this.decl.getNestedBeanDeclarations();
        Assert.assertTrue((String)"Found nested declarations", (nested == null || nested.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testGetInterpolatedBeanProperties() {
        HierarchicalConfiguration config = new HierarchicalConfiguration();
        String[] varValues = new String[TEST_PROPS.length];
        for (int i = 0; i < TEST_PROPS.length; ++i) {
            varValues[i] = "${variables." + TEST_PROPS[i] + "}";
            config.addProperty(VARS + TEST_PROPS[i], (Object)TEST_VALUES[i]);
        }
        this.setupBeanDeclaration(config, KEY, TEST_PROPS, varValues);
        this.decl = new XMLBeanDeclaration(config, KEY);
        this.checkProperties((BeanDeclaration)this.decl, TEST_PROPS, TEST_VALUES);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInitFromUndefinedKey() {
        HierarchicalConfiguration config = new HierarchicalConfiguration();
        this.setupBeanDeclaration(config, KEY, TEST_PROPS, TEST_VALUES);
        this.decl = new XMLBeanDeclaration(config, "undefined_key");
    }

    @Test
    public void testInitFromUndefinedKeyOptional() {
        HierarchicalConfiguration config = new HierarchicalConfiguration();
        this.setupBeanDeclaration(config, KEY, TEST_PROPS, TEST_VALUES);
        this.decl = new XMLBeanDeclaration(config, "undefined_key", true);
        Assert.assertNull((String)"Found a bean class", (Object)this.decl.getBeanClassName());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInitFromMultiValueKey() {
        HierarchicalConfiguration config = new HierarchicalConfiguration();
        config.addProperty(KEY, (Object)"myFirstKey");
        config.addProperty(KEY, (Object)"mySecondKey");
        this.decl = new XMLBeanDeclaration(config, KEY);
    }

    private void setupBeanDeclaration(HierarchicalConfiguration config, String key, String[] names, String[] values) {
        for (int i = 0; i < names.length; ++i) {
            config.addProperty(key + "[@" + names[i] + "]", (Object)values[i]);
        }
    }

    private void checkProperties(BeanDeclaration beanDecl, String[] names, String[] values) {
        Map props = beanDecl.getBeanProperties();
        Assert.assertEquals((String)"Wrong number of properties", (long)names.length, (long)props.size());
        for (int i = 0; i < names.length; ++i) {
            Assert.assertTrue((String)("Property " + names[i] + " not contained"), (boolean)props.containsKey(names[i]));
            Assert.assertEquals((String)("Wrong value for property " + names[i]), (Object)values[i], props.get(names[i]));
        }
    }

    private static class XMLBeanDeclarationTestImpl
    extends XMLBeanDeclaration {
        public XMLBeanDeclarationTestImpl(SubnodeConfiguration config, ConfigurationNode node) {
            super(config, node);
        }
    }
}

