/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Timestamp;
import java.util.Date;
import junit.framework.TestCase;
import org.apache.commons.dbutils.MockResultSet;
import org.apache.commons.dbutils.MockResultSetMetaData;

public class BaseTestCase
extends TestCase {
    private static final String[] columnNames = new String[]{"one", "two", "three", "notInBean", "intTest", "integerTest", "nullObjectTest", "nullPrimitiveTest", "notDate", "columnProcessorDoubleTest", null};
    protected static final int COLS = columnNames.length;
    protected static final ResultSetMetaData metaData = MockResultSetMetaData.create(columnNames);
    static final Timestamp ts789456123 = new Timestamp(new Date().getTime());
    private static final Object[] row1;
    private static final Object[] row2;
    private static final Object[][] rows;
    protected static final int ROWS;
    protected ResultSet rs = null;
    protected ResultSet emptyResultSet = null;

    protected ResultSet createMockResultSet() {
        return MockResultSet.create(metaData, rows);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.rs = this.createMockResultSet();
        this.emptyResultSet = MockResultSet.create(metaData, null);
    }

    public void testCheckDataSizes() {
        BaseTestCase.assertEquals((String)"Row 1 must contain correct number of columns", (int)columnNames.length, (int)row1.length);
        BaseTestCase.assertEquals((String)"Row 1 must contain correct number of columns", (int)columnNames.length, (int)row2.length);
    }

    public void testResultSets() throws Exception {
        BaseTestCase.assertFalse((String)"emptyResultSet should be empty", (boolean)this.emptyResultSet.next());
    }

    static {
        ts789456123.setNanos(789456123);
        row1 = new Object[]{"1", "2", "THREE", "  notInBean  ", 1, 2, null, null, new Date(), BigInteger.valueOf(13L), null};
        row2 = new Object[]{"4", "5", "SIX", "  notInBean  ", 3, 4, null, null, ts789456123, BigInteger.valueOf(13L), null};
        rows = new Object[][]{row1, row2};
        ROWS = rows.length;
    }
}

