/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.threed;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.geometry.core.Transform;
import org.apache.commons.geometry.core.partitioning.Hyperplane;
import org.apache.commons.geometry.core.partitioning.Split;
import org.apache.commons.geometry.core.partitioning.bsp.BSPTree;
import org.apache.commons.geometry.euclidean.threed.AbstractEmbeddedRegionPlaneSubset;
import org.apache.commons.geometry.euclidean.threed.Bounds3D;
import org.apache.commons.geometry.euclidean.threed.EmbeddingPlane;
import org.apache.commons.geometry.euclidean.threed.Plane;
import org.apache.commons.geometry.euclidean.threed.PlaneConvexSubset;
import org.apache.commons.geometry.euclidean.threed.PlaneSubset;
import org.apache.commons.geometry.euclidean.threed.Planes;
import org.apache.commons.geometry.euclidean.threed.Triangle3D;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.euclidean.twod.ConvexArea;
import org.apache.commons.geometry.euclidean.twod.RegionBSPTree2D;
import org.apache.commons.geometry.euclidean.twod.Vector2D;
import org.apache.commons.geometry.euclidean.twod.rotation.Rotation2D;
import org.apache.commons.numbers.core.Precision;

public final class EmbeddedTreePlaneSubset
extends AbstractEmbeddedRegionPlaneSubset {
    private final RegionBSPTree2D region;

    public EmbeddedTreePlaneSubset(EmbeddingPlane plane) {
        this(plane, false);
    }

    public EmbeddedTreePlaneSubset(EmbeddingPlane plane, boolean full) {
        this(plane, new RegionBSPTree2D(full));
    }

    public EmbeddedTreePlaneSubset(EmbeddingPlane plane, RegionBSPTree2D region) {
        super(plane);
        this.region = region;
    }

    @Override
    public PlaneSubset.Embedded getEmbedded() {
        return this;
    }

    public RegionBSPTree2D getSubspaceRegion() {
        return this.region;
    }

    @Override
    public List<PlaneConvexSubset> toConvex() {
        List<ConvexArea> areas = this.region.toConvex();
        ArrayList<PlaneConvexSubset> facets = new ArrayList<PlaneConvexSubset>(areas.size());
        for (ConvexArea area : areas) {
            facets.add(Planes.subsetFromConvexArea(this.getPlane(), area));
        }
        return facets;
    }

    @Override
    public List<Triangle3D> toTriangles() {
        EmbeddingPlane plane = this.getPlane();
        ArrayList<Triangle3D> triangles = new ArrayList<Triangle3D>();
        for (ConvexArea area : this.region.toConvex()) {
            if (area.isInfinite()) {
                throw new IllegalStateException("Cannot convert infinite plane subset to triangles: " + this);
            }
            List vertices = plane.toSpace(area.getVertices());
            triangles.addAll(Planes.convexPolygonToTriangleFan(plane, vertices));
        }
        return triangles;
    }

    @Override
    public Bounds3D getBounds() {
        return this.getBoundsFromSubspace(this.region);
    }

    public Split<EmbeddedTreePlaneSubset> split(Hyperplane<Vector3D> splitter) {
        return Planes.subspaceSplit((Plane)splitter, this, (p, r) -> new EmbeddedTreePlaneSubset((EmbeddingPlane)((Object)p), (RegionBSPTree2D)r));
    }

    public EmbeddedTreePlaneSubset transform(Transform<Vector3D> transform) {
        EmbeddingPlane.SubspaceTransform subTransform = this.getPlane().getEmbedding().subspaceTransform(transform);
        RegionBSPTree2D tRegion = RegionBSPTree2D.empty();
        tRegion.copy((BSPTree)this.region);
        tRegion.transform(subTransform.getTransform());
        return new EmbeddedTreePlaneSubset(subTransform.getPlane(), tRegion);
    }

    public void add(PlaneConvexSubset subset) {
        Planes.validatePlanesEquivalent(this.getPlane(), subset.getPlane());
        PlaneConvexSubset.Embedded embedded = subset.getEmbedded();
        Rotation2D rot = this.getEmbeddedRegionRotation(embedded);
        ConvexArea subspaceArea = embedded.getSubspaceRegion();
        ConvexArea toAdd = rot != null ? subspaceArea.transform(rot) : subspaceArea;
        this.region.add(toAdd);
    }

    public void add(EmbeddedTreePlaneSubset subset) {
        RegionBSPTree2D regionToAdd;
        Planes.validatePlanesEquivalent(this.getPlane(), subset.getPlane());
        RegionBSPTree2D otherTree = subset.getSubspaceRegion();
        Rotation2D rot = this.getEmbeddedRegionRotation(subset);
        if (rot != null) {
            regionToAdd = otherTree.copy();
            regionToAdd.transform(rot);
        } else {
            regionToAdd = otherTree;
        }
        this.region.union(regionToAdd);
    }

    private Rotation2D getEmbeddedRegionRotation(PlaneSubset.Embedded embedded) {
        double uDot;
        EmbeddingPlane thisPlane = this.getPlane();
        EmbeddingPlane otherPlane = embedded.getPlane();
        Precision.DoubleEquivalence precision = thisPlane.getPrecision();
        if (!precision.eq(uDot = thisPlane.getU().dot(otherPlane.getU()), 1.0)) {
            Vector2D otherPlaneU = thisPlane.toSubspace(otherPlane.getOrigin().add(otherPlane.getU()));
            double angle = Math.atan2(otherPlaneU.getY(), otherPlaneU.getX());
            return Rotation2D.of(angle);
        }
        return null;
    }
}

