/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.expression;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.expression.CompositeExpression;
import org.apache.commons.jelly.expression.Expression;
import org.apache.commons.jelly.expression.ExpressionFactory;
import org.apache.commons.jelly.expression.jexl.JexlExpressionFactory;

public class TestExpressions
extends TestCase {
    protected JellyContext context = new JellyContext();
    protected ExpressionFactory factory = new JexlExpressionFactory();

    public static void main(String[] args) {
        TestRunner.run((Test)TestExpressions.suite());
    }

    public static Test suite() {
        return new TestSuite(TestExpressions.class);
    }

    public TestExpressions(String testName) {
        super(testName);
    }

    public void testExpresssions() throws Exception {
        this.context.setVariable("topping", (Object)"cheese");
        this.context.setVariable("type", (Object)"deepPan");
        this.assertExpression("foo", "foo");
        this.assertExpression("${topping}", "cheese");
        this.assertExpression("some${topping}", "somecheese");
        this.assertExpression(" some ${topping} ", " some cheese ");
        this.assertExpression("${topping}y", "cheesey");
        this.assertExpression("A ${topping} ${type} pizza", "A cheese deepPan pizza");
        this.assertExpression("${topping}-${type}", "cheese-deepPan");
    }

    public void testAntExpresssions() throws Exception {
        this.context.setVariable("maven.home.foo", (Object)"cheese");
        this.assertExpression("${maven.home.foo}", "cheese");
        this.assertExpression("${maven.some.madeup.name}", null);
        this.assertExpression("cheese ${maven.some.madeup.name}pizza", "cheese pizza");
        this.assertExpression("ham and ${maven.home.foo} pizza", "ham and cheese pizza");
        this.assertExpression("${maven.home.foo.length()}", new Integer(6));
    }

    public void testNotConditions() throws Exception {
        this.context.setVariable("a", (Object)Boolean.TRUE);
        this.context.setVariable("b", (Object)Boolean.FALSE);
        this.context.setVariable("c", (Object)"true");
        this.context.setVariable("d", (Object)"false");
        this.assertExpression("${a}", Boolean.TRUE);
        this.assertExpression("${!a}", Boolean.FALSE);
        this.assertExpression("${b}", Boolean.FALSE);
        this.assertExpression("${!b}", Boolean.TRUE);
        this.assertExpression("${c}", "true");
        this.assertExpression("${!c}", Boolean.FALSE);
        this.assertExpression("${d}", "false");
        this.assertExpression("${!d}", Boolean.TRUE);
    }

    public void testNotConditionsWithDot() throws Exception {
        this.context.setVariable("x.a", (Object)Boolean.TRUE);
        this.context.setVariable("x.b", (Object)Boolean.FALSE);
        this.context.setVariable("x.c", (Object)"true");
        this.context.setVariable("x.d", (Object)"false");
        this.assertExpression("${x.a}", Boolean.TRUE);
        this.assertExpression("${!x.a}", Boolean.FALSE);
        this.assertExpression("${x.b}", Boolean.FALSE);
        this.assertExpression("${!x.b}", Boolean.TRUE);
        this.assertExpression("${x.c}", "true");
        this.assertExpression("${!x.c}", Boolean.FALSE);
        this.assertExpression("${x.d}", "false");
        this.assertExpression("${!x.d}", Boolean.TRUE);
    }

    public void testNull() throws Exception {
        this.context.setVariable("something.blank", (Object)"");
        this.context.setVariable("something.ok", (Object)"cheese");
        this.assertExpression("${something.blank.length() == 0}", Boolean.TRUE);
        this.assertExpression("${something.blank == ''}", Boolean.TRUE);
        this.assertExpression("${something.ok != null}", Boolean.TRUE);
        this.assertExpression("${something.ok != ''}", Boolean.TRUE);
        this.assertExpression("${unknown == null}", Boolean.TRUE);
    }

    protected void assertExpression(String expressionText, Object expectedValue) throws Exception {
        Expression expression = CompositeExpression.parse((String)expressionText, (ExpressionFactory)this.factory);
        TestExpressions.assertTrue((String)("Created a valid expression for: " + expressionText), (expression != null ? 1 : 0) != 0);
        Object value = expression.evaluate(this.context);
        TestExpressions.assertEquals((String)("Wrong result for expression: " + expressionText), (Object)expectedValue, (Object)value);
        String text = expression.getExpressionText();
        TestExpressions.assertEquals((String)"Wrong textual representation for expression text: ", (String)expressionText, (String)text);
    }
}

