/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlFeatures;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.internal.ArrayBuilder;
import org.apache.commons.jexl3.internal.introspection.ClassMisc;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ArrayTypeTest {
    ArrayTypeTest() {
    }

    @Test
    void testArrayTypes() {
        ArrayBuilder ab = new ArrayBuilder(1);
        JexlFeatures features = JexlFeatures.createScript().script(false);
        JexlEngine jexl = new JexlBuilder().features(features).create();
        Set superSet = ClassMisc.getSuperClasses(ClassC.class, (Class[])new Class[0]);
        Assertions.assertTrue((superSet.size() > 0 ? 1 : 0) != 0);
        List<Class> ordered = Arrays.asList(ClassB.class, ClassA.class, Class0.class, InterC.class, InterX.class, InterB.class, InterA.class, Inter0.class);
        int i = 0;
        for (Class clazz : superSet) {
            Assertions.assertEquals((Object)clazz, (Object)ordered.get(i++), (String)("order " + i));
        }
        Class inter = ClassMisc.getCommonSuperClass(ClassC.class, ClassX.class);
        Assertions.assertEquals(Class0.class, (Object)inter);
        Assertions.assertEquals(Object.class, (Object)ClassMisc.getCommonSuperClass(ClassC.class, Object.class));
        Assertions.assertNull((Object)ClassMisc.getCommonSuperClass(ClassC.class, null));
        Assertions.assertNull((Object)ClassMisc.getCommonSuperClass(null, ClassC.class));
        inter = ClassMisc.getCommonSuperClass(ClassC.class, ClassB.class);
        Assertions.assertEquals(ClassB.class, (Object)inter);
        Class list = ClassMisc.getCommonSuperClass(ArrayList.class, ArrayDeque.class);
        Assertions.assertEquals((Object)list, AbstractCollection.class);
        Set sset = ClassMisc.getSuperClasses(ArrayList.class, (Class[])new Class[]{ArrayDeque.class});
        Assertions.assertFalse((boolean)sset.isEmpty());
        List<Class> expected = Arrays.asList(AbstractCollection.class, Collection.class, Iterable.class, Cloneable.class, Serializable.class);
        Assertions.assertTrue((boolean)sset.containsAll(expected));
        Class<Object> collection = ClassMisc.getCommonSuperClass(ArrayList.class, Collections.emptyList().getClass());
        Assertions.assertEquals(AbstractList.class, (Object)collection);
        collection = ClassMisc.getSuperClasses(ArrayList.class, (Class[])new Class[]{Collections.emptyList().getClass()}).stream().findFirst().orElse(Object.class);
        ClassA a = new ClassA(1);
        ClassB b = new ClassB(2);
        ClassC c = new ClassC(3);
        ClassX x = new ClassX(4);
        JexlScript script = jexl.createScript("[ a, b, c, d ]", new String[]{"a", "b", "c", "d"});
        Object result = script.execute(null, new Object[]{a, b, c, c});
        Assertions.assertTrue((result.getClass().isArray() && result.getClass().getComponentType().equals(ClassA.class) ? 1 : 0) != 0);
        result = script.execute(null, new Object[]{a, b, c, x});
        Assertions.assertTrue((result.getClass().isArray() && result.getClass().getComponentType().equals(Class0.class) ? 1 : 0) != 0);
        result = script.execute(null, new Object[]{x, c, b, a});
        Assertions.assertTrue((boolean)(result.getClass().isArray() & result.getClass().getComponentType().equals(Class0.class)));
        ClassD d = new ClassD();
        result = script.execute(null, new Object[]{a, b, c, d});
        Assertions.assertTrue((result.getClass().isArray() && result.getClass().getComponentType().equals(Inter0.class) ? 1 : 0) != 0);
        script = jexl.createScript("[ a, b, c, d, ... ]", new String[]{"a", "b", "c", "d"});
        result = script.execute(null, new Object[]{a, b, c, c});
        Assertions.assertInstanceOf(List.class, (Object)result);
    }

    public static class ClassC
    extends ClassB
    implements InterC,
    InterX {
        public ClassC(int v) {
            super(v);
        }
    }

    public static class ClassB
    extends ClassA
    implements InterB {
        public ClassB(int v) {
            super(v);
        }
    }

    public static class ClassA
    extends Class0
    implements InterA {
        public ClassA(int v) {
            super(v);
        }
    }

    public static abstract class Class0
    implements Inter0 {
        private final int value;

        public Class0(int v) {
            this.value = v;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{" + this.value + "}";
        }
    }

    public static interface InterC {
    }

    public static interface InterX
    extends InterB {
    }

    public static interface InterB {
    }

    public static interface InterA {
    }

    public static interface Inter0 {
    }

    public static class ClassX
    extends Class0
    implements InterX {
        public ClassX(int v) {
            super(v);
        }
    }

    public static class ClassD
    implements InterB,
    Inter0 {
        public String toString() {
            return this.getClass().getSimpleName() + "{" + Integer.toHexString(this.hashCode()) + "}";
        }
    }
}

