/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.function.Supplier;
import org.junit.jupiter.api.AssertionFailureBuilder;
import org.junit.jupiter.api.AssertionUtils;
import org.junit.jupiter.api.function.Executable;
import org.junit.platform.commons.util.UnrecoverableExceptions;

class AssertThrowsExactly {
    private AssertThrowsExactly() {
    }

    static <T extends Throwable> T assertThrowsExactly(Class<T> expectedType, Executable executable) {
        return AssertThrowsExactly.assertThrowsExactly(expectedType, executable, null);
    }

    static <T extends Throwable> T assertThrowsExactly(Class<T> expectedType, Executable executable, String message) {
        return AssertThrowsExactly.assertThrowsExactly(expectedType, executable, (Object)message);
    }

    static <T extends Throwable> T assertThrowsExactly(Class<T> expectedType, Executable executable, Supplier<String> messageSupplier) {
        return AssertThrowsExactly.assertThrowsExactly(expectedType, executable, messageSupplier);
    }

    private static <T extends Throwable> T assertThrowsExactly(Class<T> expectedType, Executable executable, Object messageOrSupplier) {
        try {
            executable.execute();
        }
        catch (Throwable actualException) {
            if (expectedType.equals(actualException.getClass())) {
                return (T)actualException;
            }
            UnrecoverableExceptions.rethrowIfUnrecoverable(actualException);
            throw AssertionFailureBuilder.assertionFailure().message(messageOrSupplier).expected(expectedType).actual(actualException.getClass()).reason("Unexpected exception type thrown").cause(actualException).build();
        }
        throw AssertionFailureBuilder.assertionFailure().message(messageOrSupplier).reason(String.format("Expected %s to be thrown, but nothing was thrown.", AssertionUtils.getCanonicalName(expectedType))).build();
    }
}

