/*
 * Decompiled with CFR 0.152.
 */
package org.apache.creadur.tentacles;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.creadur.tentacles.IOSystem;
import org.apache.creadur.tentacles.License;
import org.apache.creadur.tentacles.Platform;

public class Licenses {
    private final IOSystem ioSystem;
    private final Map<String, String> licenses;

    public Licenses(Map<String, String> licenses, Platform platform) {
        this.ioSystem = platform.getIoSystem();
        this.licenses = Collections.unmodifiableMap(licenses);
    }

    public License from(File document) throws IOException {
        return this.license(this.ioSystem.slurp(document));
    }

    private License license(String text) {
        String key = this.toKey(text);
        return new License(key, this.normalize(text));
    }

    private String toKey(String text) {
        return text.replaceAll("[ \\n\\t\\r]+", "").toLowerCase().intern();
    }

    private String normalize(String text) {
        for (Map.Entry<String, String> license : this.licenses.entrySet()) {
            text = text.replace(license.getValue(), String.format("---[%s - full text]---\n\n", license.getKey()));
        }
        text = text.intern();
        return text;
    }
}

