/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.timeml.tlink;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.feature.syntax.SyntacticFirstChildOfGrandparentOfLeafExtractor;
import org.cleartk.feature.syntax.SyntacticLeafToLeafPathPartsExtractor;
import org.cleartk.ml.feature.extractor.CleartkExtractor;
import org.cleartk.ml.feature.extractor.CoveredTextExtractor;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;
import org.cleartk.ml.feature.extractor.TypePathExtractor;
import org.cleartk.ml.liblinear.LibLinearStringOutcomeDataWriter;
import org.cleartk.syntax.constituent.type.TreebankNode;
import org.cleartk.syntax.constituent.type.TreebankNodeUtil;
import org.cleartk.timeml.tlink.TemporalLinkAnnotator_ImplBase;
import org.cleartk.timeml.type.Anchor;
import org.cleartk.timeml.type.Event;
import org.cleartk.timeml.util.CleartkInternalModelFactory;
import org.cleartk.token.type.Sentence;
import org.cleartk.token.type.Token;

public class TemporalLinkEventToSubordinatedEventAnnotator
extends TemporalLinkAnnotator_ImplBase<Event, Event> {
    public static final CleartkInternalModelFactory FACTORY = new CleartkInternalModelFactory(){

        @Override
        public Class<?> getAnnotatorClass() {
            return TemporalLinkEventToSubordinatedEventAnnotator.class;
        }

        @Override
        public Class<?> getDataWriterClass() {
            return LibLinearStringOutcomeDataWriter.class;
        }

        @Override
        public AnalysisEngineDescription getBaseDescription() throws ResourceInitializationException {
            return AnalysisEngineFactory.createEngineDescription(TemporalLinkEventToSubordinatedEventAnnotator.class, (Object[])new Object[0]);
        }
    };
    private static final Pattern SUBORDINATE_PATH_PATTERN = Pattern.compile("^(VP>|ADJP>|NP>)?(VP|ADJP|S|SBAR)(<(S|SBAR|PP))*((<VP|<ADJP)*|(<NP)*)$");

    public TemporalLinkEventToSubordinatedEventAnnotator() {
        super(Event.class, Event.class, "BEFORE", "AFTER");
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        ArrayList extractors = Lists.newArrayList();
        extractors.add(new TypePathExtractor(Event.class, "tense"));
        extractors.add(new TypePathExtractor(Event.class, "aspect"));
        extractors.add(new TypePathExtractor(Event.class, "eventClass"));
        extractors.add(new SyntacticFirstChildOfGrandparentOfLeafExtractor());
        this.setSourceExtractors(extractors);
        this.setTargetExtractors(extractors);
        ArrayList btweenExtractors = Lists.newArrayList();
        btweenExtractors.add(new SyntacticLeafToLeafPathPartsExtractor());
        btweenExtractors.add(new CleartkExtractor(Token.class, (FeatureExtractor1)new CoveredTextExtractor(), new CleartkExtractor.Context[]{new CleartkExtractor.Bag(new CleartkExtractor.Context[]{new CleartkExtractor.Covered()})}));
        this.setBetweenExtractors(btweenExtractors);
    }

    @Override
    protected List<TemporalLinkAnnotator_ImplBase.SourceTargetPair> getSourceTargetPairs(JCas jCas) {
        ArrayList pairs = Lists.newArrayList();
        for (Sentence sentence : JCasUtil.select((JCas)jCas, Sentence.class)) {
            for (Event source : JCasUtil.selectCovered((JCas)jCas, Event.class, (AnnotationFS)sentence)) {
                for (Event target : this.getSubordinateEvents(jCas, source, sentence)) {
                    pairs.add(new TemporalLinkAnnotator_ImplBase.SourceTargetPair((TemporalLinkAnnotator_ImplBase)this, (Anchor)source, (Anchor)target));
                }
            }
        }
        return pairs;
    }

    private List<Event> getSubordinateEvents(JCas jCas, Event source, Sentence sentence) {
        ArrayList<Event> targets = new ArrayList<Event>();
        TreebankNode sourceNode = TreebankNodeUtil.selectMatchingLeaf((JCas)jCas, (Annotation)source);
        for (Event target : JCasUtil.selectCovered((JCas)jCas, Event.class, (AnnotationFS)sentence)) {
            String path;
            if (target.equals((Object)source)) continue;
            TreebankNode targetNode = TreebankNodeUtil.selectMatchingLeaf((JCas)jCas, (Annotation)target);
            if (sourceNode == null || targetNode == null || !SUBORDINATE_PATH_PATTERN.matcher(path = TemporalLinkEventToSubordinatedEventAnnotator.noLeavesPath(TreebankNodeUtil.getPath((TreebankNode)sourceNode, (TreebankNode)targetNode))).matches()) continue;
            targets.add(target);
        }
        return targets;
    }
}

