/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.kernel.metric;

import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ctakes.ytex.kernel.metric.ConceptPair;
import org.apache.ctakes.ytex.kernel.metric.ConceptPairSimilarity;
import org.apache.ctakes.ytex.kernel.metric.LCSPath;
import org.apache.ctakes.ytex.kernel.model.ConceptGraph;

public interface ConceptSimilarityService {
    public String getConceptGraphName();

    public int lcs(String var1, String var2, List<LCSPath> var3);

    public ConceptGraph getConceptGraph();

    public Map<String, BitSet> getCuiTuiMap();

    public List<String> getTuiList();

    public double loadConceptFilter(String var1, int var2, Map<String, Double> var3);

    public int getLCS(String var1, String var2, Set<String> var3, List<LCSPath> var4);

    public Object[] getBestLCS(Set<String> var1, boolean var2, Map<String, Double> var3);

    public double getIC(String var1, boolean var2);

    public ConceptPairSimilarity similarity(List<SimilarityMetricEnum> var1, String var2, String var3, Map<String, Double> var4, boolean var5);

    public List<ConceptPairSimilarity> similarity(List<ConceptPair> var1, List<SimilarityMetricEnum> var2, Map<String, Double> var3, boolean var4);

    public int getDepth(String var1);

    public static enum SimilarityMetricEnum {
        LCH(false, false),
        INTRINSIC_LCH(true, false),
        LIN(false, true),
        INTRINSIC_LIN(true, false),
        PATH(false, false),
        INTRINSIC_PATH(true, false),
        JACCARD(true, false),
        SOKAL(true, false),
        RADA(false, false),
        INTRINSIC_RADA(true, false),
        WUPALMER(false, false),
        PAGERANK(false, false);

        boolean intrinsicIC = false;
        boolean corpusIC = false;

        public boolean isTaxonomy() {
            return !this.intrinsicIC && !this.corpusIC;
        }

        public boolean isIntrinsicIC() {
            return this.intrinsicIC;
        }

        public boolean isCorpusIC() {
            return this.corpusIC;
        }

        private SimilarityMetricEnum(boolean intrinsicIC, boolean corpusIC) {
            this.intrinsicIC = intrinsicIC;
            this.corpusIC = corpusIC;
        }
    }
}

