/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.liblinear;

import com.google.common.collect.Maps;
import de.bwaldvogel.liblinear.FeatureNode;
import de.bwaldvogel.liblinear.Linear;
import de.bwaldvogel.liblinear.Model;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cleartk.ml.CleartkProcessingException;
import org.cleartk.ml.Feature;
import org.cleartk.ml.encoder.features.FeaturesEncoder;
import org.cleartk.ml.encoder.outcome.OutcomeEncoder;
import org.cleartk.ml.jar.Classifier_ImplBase;

public class GenericLibLinearClassifier<OUTCOME_TYPE>
extends Classifier_ImplBase<FeatureNode[], OUTCOME_TYPE, Integer> {
    private Model model;

    public GenericLibLinearClassifier(FeaturesEncoder<FeatureNode[]> featuresEncoder, OutcomeEncoder<OUTCOME_TYPE, Integer> outcomeEncoder, Model model) {
        super(featuresEncoder, outcomeEncoder);
        this.model = model;
    }

    public OUTCOME_TYPE classify(List<Feature> features) throws CleartkProcessingException {
        FeatureNode[] encodedFeatures = (FeatureNode[])this.featuresEncoder.encodeAll(features);
        int encodedOutcome = (int)Linear.predict((Model)this.model, (de.bwaldvogel.liblinear.Feature[])encodedFeatures);
        return (OUTCOME_TYPE)this.outcomeEncoder.decode((Object)encodedOutcome);
    }

    public Map<OUTCOME_TYPE, Double> score(List<Feature> features) throws CleartkProcessingException {
        FeatureNode[] encodedFeatures = (FeatureNode[])this.featuresEncoder.encodeAll(features);
        int[] encodedOutcomes = this.model.getLabels();
        double[] scores = new double[encodedOutcomes.length];
        if (this.model.isProbabilityModel()) {
            Linear.predictProbability((Model)this.model, (de.bwaldvogel.liblinear.Feature[])encodedFeatures, (double[])scores);
        } else {
            Linear.predictValues((Model)this.model, (de.bwaldvogel.liblinear.Feature[])encodedFeatures, (double[])scores);
        }
        if (this.model.getNrClass() == 2 && scores[1] == 0.0) {
            scores[1] = -scores[0];
        }
        HashMap scoredOutcomes = Maps.newHashMap();
        for (int i = 0; i < encodedOutcomes.length; ++i) {
            Object outcome = this.outcomeEncoder.decode((Object)encodedOutcomes[i]);
            scoredOutcomes.put(outcome, scores[i]);
        }
        return scoredOutcomes;
    }
}

