/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.constituent;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntOpenHashSet;
import com.googlecode.clearnlp.conversion.C2DInfo;
import com.googlecode.clearnlp.morphology.MPLib;
import com.googlecode.clearnlp.propbank.PBLoc;
import com.googlecode.clearnlp.util.pair.StringIntPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class CTNode
implements Comparable<CTNode> {
    public String pTag;
    protected Set<String> s_fTags;
    public int coIndex = -1;
    public int gapIndex = -1;
    public String form = null;
    protected CTNode parent = null;
    protected CTNode antecedent = null;
    protected List<CTNode> ls_children;
    protected int i_terminalId = -1;
    protected int i_tokenId = -1;
    protected int i_siblingId = -1;
    protected PBLoc pb_loc = null;
    public C2DInfo c2d = null;
    public List<StringIntPair> pbArgs = null;

    public CTNode(String tags) {
        this.setTags(tags);
        this.ls_children = new ArrayList<CTNode>();
    }

    public CTNode(String tags, String form) {
        this(tags);
        this.form = form;
    }

    public String getTags() {
        StringBuilder build = new StringBuilder();
        build.append(this.pTag);
        for (String fTag : this.s_fTags) {
            build.append("-");
            build.append(fTag);
        }
        if (this.coIndex != -1) {
            build.append("-");
            build.append(this.coIndex);
        }
        if (this.gapIndex != -1) {
            build.append("=");
            build.append(this.gapIndex);
        }
        return build.toString();
    }

    public Set<String> getFTags() {
        return this.s_fTags;
    }

    public int getTerminalId() {
        return this.i_terminalId;
    }

    public int getTokenId() {
        return this.i_tokenId;
    }

    public int getSiblingId() {
        return this.i_siblingId;
    }

    public PBLoc getPBLoc() {
        return this.pb_loc;
    }

    public CTNode getParent() {
        return this.parent;
    }

    public CTNode getAntecedent() {
        return this.antecedent;
    }

    public List<CTNode> getChildren() {
        return this.ls_children;
    }

    public List<CTNode> getChildren(int fstId) {
        return this.ls_children.subList(fstId, this.ls_children.size());
    }

    public List<CTNode> getChildren(int fstId, int lstId) {
        return this.ls_children.subList(fstId, lstId);
    }

    public CTNode getChild(int childId) {
        return 0 <= childId && childId < this.ls_children.size() ? this.ls_children.get(childId) : null;
    }

    public CTNode getFirstChild(String ... tags) {
        for (CTNode child : this.ls_children) {
            if (!child.isTag(tags)) continue;
            return child;
        }
        return null;
    }

    public CTNode getLastChild(String ... tags) {
        for (int i = this.ls_children.size() - 1; i >= 0; --i) {
            CTNode child = this.ls_children.get(i);
            if (!child.isTag(tags)) continue;
            return child;
        }
        return null;
    }

    public List<CTNode> getAllChildren(String ... tags) {
        ArrayList<CTNode> list = new ArrayList<CTNode>();
        for (CTNode child : this.ls_children) {
            if (!child.isTag(tags)) continue;
            list.add(child);
        }
        return list;
    }

    public CTNode getFirstDescendant(String ... tags) {
        return this.getFirstDescendantAux(this.ls_children, tags);
    }

    private CTNode getFirstDescendantAux(List<CTNode> nodes, String ... tags) {
        for (CTNode node : nodes) {
            if (node.isTag(tags)) {
                return node;
            }
            CTNode desc = this.getFirstDescendantAux(node.ls_children, tags);
            if (desc == null) continue;
            return desc;
        }
        return null;
    }

    public CTNode getPrevSibling() {
        List<CTNode> siblings = this.parent.ls_children;
        return 0 <= this.i_siblingId - 1 ? siblings.get(this.i_siblingId - 1) : null;
    }

    public CTNode getPrevSibling(String ... tags) {
        if (this.parent == null) {
            return null;
        }
        List<CTNode> siblings = this.parent.ls_children;
        for (int i = this.i_siblingId - 1; i >= 0; --i) {
            CTNode node = siblings.get(i);
            if (!node.isTag(tags)) continue;
            return node;
        }
        return null;
    }

    public List<CTNode> getPrevSiblings() {
        return this.parent != null ? this.parent.getChildren(0, this.i_siblingId) : new ArrayList<CTNode>(0);
    }

    public CTNode getNextSibling() {
        List<CTNode> siblings = this.parent.ls_children;
        return this.i_siblingId + 1 < siblings.size() ? siblings.get(this.i_siblingId + 1) : null;
    }

    public CTNode getNextSibling(String ... tags) {
        if (this.parent == null) {
            return null;
        }
        List<CTNode> siblings = this.parent.ls_children;
        int size = siblings.size();
        for (int i = this.i_siblingId + 1; i < size; ++i) {
            CTNode node = siblings.get(i);
            if (!node.isTag(tags)) continue;
            return node;
        }
        return null;
    }

    public CTNode getNearestAncestor(String ... tags) {
        CTNode curr = this;
        while (curr.parent != null) {
            curr = curr.parent;
            if (!curr.isTag(tags)) continue;
            return curr;
        }
        return null;
    }

    public CTNode getFirstChainedDescendant(String ... tags) {
        CTNode child;
        CTNode desc = this;
        while ((child = desc.getFirstChild(tags)) != null) {
            desc = child;
        }
        return desc != this ? desc : null;
    }

    public CTNode getHighestChainedAncestor(String ... tags) {
        CTNode curr = this;
        while (curr.parent != null && curr.parent.isTag(tags)) {
            curr = curr.parent;
        }
        return curr == this ? null : curr;
    }

    public List<CTNode> getIncludedEmptyCategory(String regex) {
        ArrayList<CTNode> list = new ArrayList<CTNode>();
        this.getIncludedEmptyCategoriesAux(this, list, regex);
        return list;
    }

    private void getIncludedEmptyCategoriesAux(CTNode curr, List<CTNode> list, String regex) {
        if (curr.isEmptyCategory() && curr.form.matches(regex)) {
            list.add(curr);
        }
        for (CTNode child : curr.ls_children) {
            this.getIncludedEmptyCategoriesAux(child, list, regex);
        }
    }

    public List<CTNode> getSubTerminals() {
        ArrayList<CTNode> terminals = new ArrayList<CTNode>();
        this.getSubTerminals(this, terminals);
        return terminals;
    }

    private void getSubTerminals(CTNode curr, List<CTNode> terminals) {
        if (curr.isPhrase()) {
            for (CTNode child : curr.ls_children) {
                this.getSubTerminals(child, terminals);
            }
        } else {
            terminals.add(curr);
        }
    }

    public IntArrayList getSubTerminalIdList() {
        IntArrayList list = new IntArrayList();
        for (CTNode node : this.getSubTerminals()) {
            list.add(node.getTerminalId());
        }
        return list;
    }

    public IntOpenHashSet getSubTerminalIdSet() {
        IntOpenHashSet set = new IntOpenHashSet();
        for (CTNode node : this.getSubTerminals()) {
            set.add(node.getTerminalId());
        }
        return set;
    }

    public List<CTNode> getSubTokens() {
        ArrayList<CTNode> tokens = new ArrayList<CTNode>();
        this.getSubTokens(this, tokens);
        return tokens;
    }

    private void getSubTokens(CTNode curr, List<CTNode> tokens) {
        if (curr.isPhrase()) {
            for (CTNode child : curr.ls_children) {
                this.getSubTokens(child, tokens);
            }
        } else if (!curr.isEmptyCategory()) {
            tokens.add(curr);
        }
    }

    public CTNode getFirstTerminal() {
        return this.getFirstTerminalAux(this);
    }

    private CTNode getFirstTerminalAux(CTNode node) {
        List<CTNode> children = node.getChildren();
        if (children.isEmpty()) {
            return node;
        }
        return this.getFirstTerminalAux(children.get(0));
    }

    public int getChildrenSize() {
        return this.ls_children.size();
    }

    public CTNode getLowestCommonAncestor(CTNode node) {
        if (this.isDescendantOf(node)) {
            return node;
        }
        if (node.isDescendantOf(this)) {
            return this;
        }
        for (CTNode parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!node.isDescendantOf(parent)) continue;
            return parent;
        }
        return null;
    }

    public void setTags(String tags) {
        this.s_fTags = new TreeSet<String>();
        if (tags.charAt(0) == '-') {
            this.pTag = tags;
            return;
        }
        StringTokenizer tok = new StringTokenizer(tags, "-=", true);
        this.pTag = tok.nextToken();
        while (tok.hasMoreTokens()) {
            String delim = tok.nextToken();
            if (!tok.hasMoreTokens()) {
                System.err.println("Error: illegal tag \"" + tags + "\"");
                break;
            }
            String tag = tok.nextToken();
            if (delim.equals("-")) {
                if (MPLib.containsOnlyDigits(tag)) {
                    if (this.coIndex == -1) {
                        this.coIndex = Integer.parseInt(tag);
                        continue;
                    }
                    this.gapIndex = Integer.parseInt(tag);
                    continue;
                }
                this.s_fTags.add(tag);
                continue;
            }
            this.gapIndex = Integer.parseInt(tag);
        }
    }

    public void addFTag(String fTag) {
        this.s_fTags.add(fTag);
    }

    public void addFTags(Collection<String> fTags) {
        this.s_fTags.addAll(fTags);
    }

    public void removeFTag(String fTag) {
        this.s_fTags.remove(fTag);
    }

    public void removeFTagAll() {
        this.s_fTags.clear();
    }

    public void setAntecedent(CTNode ante) {
        this.antecedent = ante;
    }

    public void addChild(CTNode child) {
        child.parent = this;
        child.i_siblingId = this.ls_children.size();
        this.ls_children.add(child);
    }

    public void addChild(int index, CTNode child) {
        this.ls_children.add(index, child);
        child.parent = this;
        this.resetSiblingIDs(index);
    }

    public void setChild(int index, CTNode child) {
        this.ls_children.set((int)index, (CTNode)child).parent = null;
        child.parent = this;
        child.i_siblingId = index;
    }

    public void removeChild(int index) {
        if (!this.isChildrenRange(index)) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        this.ls_children.remove((int)index).parent = null;
        this.resetSiblingIDs(index);
    }

    private void resetSiblingIDs(int index) {
        int size = this.ls_children.size();
        for (int i = index; i < size; ++i) {
            this.ls_children.get((int)i).i_siblingId = i;
        }
    }

    public void removeChild(CTNode child) {
        this.removeChild(this.ls_children.indexOf(child));
    }

    public void resetChildren(Collection<CTNode> children) {
        this.ls_children.clear();
        for (CTNode child : children) {
            this.addChild(child);
        }
    }

    public boolean isPTag(String pTag) {
        return this.pTag.equals(pTag);
    }

    public boolean isPTagAny(String ... pTags) {
        for (String pTag : pTags) {
            if (!this.isPTag(pTag)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesPTag(String regex) {
        return this.pTag.matches("^" + regex + "$");
    }

    public boolean isFTag(String fTag) {
        return this.s_fTags.size() == 1 && this.s_fTags.contains(fTag);
    }

    public boolean hasFTag(String fTag) {
        return this.s_fTags.contains(fTag);
    }

    public boolean hasFTagAll(Collection<String> fTags) {
        return this.s_fTags.containsAll(fTags);
    }

    public boolean hasFTagAny(Collection<String> fTags) {
        for (String fTag : fTags) {
            if (!this.s_fTags.contains(fTag)) continue;
            return true;
        }
        return false;
    }

    public boolean hasFTagAny(String ... fTags) {
        for (String fTag : fTags) {
            if (!this.s_fTags.contains(fTag)) continue;
            return true;
        }
        return false;
    }

    public boolean isTag(String ... tags) {
        String pTag = null;
        String pRex = null;
        HashSet<String> fTags = new HashSet<String>();
        block4: for (String tag : tags) {
            if (tag.equals("-NONE-") || tag.equals("-LRB-") || tag.equals("-RRB-")) {
                pTag = tag;
                continue;
            }
            switch (tag.charAt(0)) {
                case '-': {
                    fTags.add(tag.substring(1));
                    continue block4;
                }
                case '+': {
                    pRex = tag.substring(1);
                    continue block4;
                }
                default: {
                    pTag = tag;
                }
            }
        }
        return !(pTag != null && !this.isPTag(pTag) || pRex != null && !this.matchesPTag(pRex) || !this.hasFTagAll(fTags));
    }

    public boolean isForm(String form) {
        return this.form != null && this.form.equals(form);
    }

    public boolean isPhrase() {
        return !this.ls_children.isEmpty();
    }

    public boolean isEmptyCategory() {
        return this.pTag.equals("-NONE-");
    }

    public boolean isEmptyCategoryRec() {
        CTNode curr = this;
        while (curr.isPhrase()) {
            if (curr.ls_children.size() > 1) {
                return false;
            }
            curr = curr.getChild(0);
        }
        return curr.isEmptyCategory();
    }

    public boolean isDescendantOf(CTNode node) {
        for (CTNode parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent != node) continue;
            return true;
        }
        return false;
    }

    public boolean containsTags(String ... tags) {
        for (CTNode child : this.ls_children) {
            if (!child.isTag(tags)) continue;
            return true;
        }
        return false;
    }

    public boolean isChildrenRange(int index) {
        return 0 <= index && index < this.ls_children.size();
    }

    public String toForms(boolean includeNulls, String delim) {
        StringBuilder build = new StringBuilder();
        for (CTNode node : this.getSubTerminals()) {
            if (!includeNulls && node.isEmptyCategory()) continue;
            build.append(delim);
            build.append(node.form);
        }
        return build.length() == 0 ? "" : build.substring(delim.length());
    }

    public String toString() {
        return this.toString(false, false);
    }

    public String toString(boolean ... args) {
        boolean includeLineNumbers = args.length > 0 ? args[0] : false;
        boolean includeAntePointers = args.length > 1 ? args[1] : false;
        ArrayList<String> lTree = new ArrayList<String>();
        this.toStringAux(this, lTree, "", includeAntePointers);
        StringBuilder build = new StringBuilder();
        for (int i = 0; i < lTree.size(); ++i) {
            if (includeLineNumbers) {
                build.append(String.format("%3d: %s\n", i, lTree.get(i)));
                continue;
            }
            build.append(lTree.get(i) + "\n");
        }
        build.deleteCharAt(build.length() - 1);
        return build.toString();
    }

    public String toStringLine() {
        ArrayList<String> lTree = new ArrayList<String>();
        this.toStringAux(this, lTree, "", false);
        StringBuilder build = new StringBuilder();
        for (int i = 0; i < lTree.size(); ++i) {
            build.append(lTree.get(i).trim() + " ");
        }
        build.deleteCharAt(build.length() - 1);
        return build.toString();
    }

    private void toStringAux(CTNode curr, ArrayList<String> lTree, String sTags, boolean includeAntePointers) {
        if (curr.isPhrase()) {
            sTags = sTags + "(" + curr.getTags() + " ";
            for (CTNode child : curr.ls_children) {
                this.toStringAux(child, lTree, sTags, includeAntePointers);
                if (child.i_siblingId != 0) continue;
                sTags = sTags.replaceAll(".", " ");
            }
            int last = lTree.size() - 1;
            lTree.set(last, lTree.get(last) + ")");
        } else {
            String tag = sTags + "(" + curr.getTags() + " " + curr.form + ")";
            if (includeAntePointers && curr.antecedent != null) {
                tag = tag + "[" + curr.antecedent.getTags() + "]";
            }
            lTree.add(tag);
        }
    }

    @Override
    public int compareTo(CTNode node) {
        return this.i_terminalId - node.i_terminalId;
    }
}

