/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.experiment;

import com.googlecode.clearnlp.constituent.CTNode;
import com.googlecode.clearnlp.constituent.CTReader;
import com.googlecode.clearnlp.constituent.CTTree;
import com.googlecode.clearnlp.io.FileExtFilter;
import com.googlecode.clearnlp.run.AbstractRun;
import com.googlecode.clearnlp.util.UTInput;
import com.googlecode.clearnlp.util.UTOutput;
import java.io.File;
import java.io.PrintStream;
import org.kohsuke.args4j.Option;

public class CT2POS
extends AbstractRun {
    @Option(name="-i", usage="the input directory path (required)", required=true, metaVar="<dirpath>")
    private String s_inputDir;
    @Option(name="-o", usage="the output directory path (required)", required=true, metaVar="<dirpath>")
    private String s_outputDir;
    @Option(name="-e", usage="the treefile extension (required)", required=true, metaVar="<extension>")
    private String s_extension;

    public CT2POS() {
    }

    public CT2POS(String[] args) {
        this.initArgs(args);
        this.run(this.s_inputDir, this.s_outputDir, this.s_extension);
    }

    public void run(String inputDir, String outputDir, String extension) {
        File dir = new File(outputDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        inputDir = inputDir + File.separator;
        outputDir = outputDir + File.separator;
        for (String filename : new File(inputDir).list(new FileExtFilter(extension))) {
            CTTree tree;
            CTReader reader = new CTReader(UTInput.createBufferedFileReader(inputDir + filename));
            PrintStream fout = UTOutput.createPrintBufferedFileStream(outputDir + filename);
            while ((tree = reader.nextTree()) != null) {
                for (CTNode node : tree.getTokens()) {
                    StringBuilder build = new StringBuilder();
                    build.append(node.form);
                    build.append("\t");
                    build.append(node.pTag);
                    fout.println(build.toString());
                }
                fout.println();
            }
            reader.close();
            fout.close();
        }
    }

    public static void main(String[] args) {
        new CT2POS(args);
    }
}

