/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup.ae;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.ctakes.core.resource.FileResource;
import org.apache.ctakes.core.resource.JdbcConnectionResource;
import org.apache.ctakes.core.resource.LuceneIndexReaderResource;
import org.apache.ctakes.dictionary.lookup.AbstractBaseDictionary;
import org.apache.ctakes.dictionary.lookup.DictionaryEngine;
import org.apache.ctakes.dictionary.lookup.ae.LookupConsumer;
import org.apache.ctakes.dictionary.lookup.ae.LookupInitializer;
import org.apache.ctakes.dictionary.lookup.ae.LookupSpec;
import org.apache.ctakes.dictionary.lookup.algorithms.LookupAlgorithm;
import org.apache.ctakes.dictionary.lookup.filter.StringPreLookupFilterImpl;
import org.apache.ctakes.dictionary.lookup.jdbc.JdbcDictionaryImpl;
import org.apache.ctakes.dictionary.lookup.lucene.LuceneDictionaryImpl;
import org.apache.ctakes.dictionary.lookup.strtable.StringTable;
import org.apache.ctakes.dictionary.lookup.strtable.StringTableDictionaryImpl;
import org.apache.ctakes.dictionary.lookup.strtable.StringTableFactory;
import org.apache.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.annotator.AnnotatorContextException;
import org.apache.uima.analysis_engine.annotator.AnnotatorInitializationException;
import org.apache.uima.resource.ResourceAccessException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public final class LookupParseUtilitiesRefactor {
    private static final Logger CLASS_LOGGER = Logger.getLogger(LookupParseUtilitiesRefactor.class);
    private static int MAX_LIST_SIZE = Integer.MAX_VALUE;

    private LookupParseUtilitiesRefactor() {
    }

    public static Set<LookupSpec> parseDescriptor(File descFile, UimaContext aContext, int maxListSize) throws JDOMException, IOException, AnnotatorContextException, ResourceAccessException {
        SAXBuilder saxBuilder = new SAXBuilder();
        Document doc = saxBuilder.build(descFile);
        MAX_LIST_SIZE = maxListSize;
        Map<String, DictionaryEngine> dictMap = LookupParseUtilitiesRefactor.parseDictionaries(aContext, doc.getRootElement().getChild("dictionaries"));
        return LookupParseUtilitiesRefactor.parseLookupBindingXml(aContext, dictMap, doc.getRootElement().getChild("lookupBindings"));
    }

    public static Set<LookupSpec> parseDescriptor(File descFile, UimaContext aContext) throws JDOMException, IOException, AnnotatorContextException, ResourceAccessException {
        return LookupParseUtilitiesRefactor.parseDescriptor(descFile, aContext, Integer.MAX_VALUE);
    }

    private static Map<String, DictionaryEngine> parseDictionaries(UimaContext aContext, Element dictetteersEl) throws AnnotatorContextException, ResourceAccessException {
        HashMap<String, DictionaryEngine> m = new HashMap<String, DictionaryEngine>();
        List dictatteerChildren = dictetteersEl.getChildren();
        for (Element dictEl : dictatteerChildren) {
            String id = dictEl.getAttributeValue("id");
            DictionaryEngine dictEngine = LookupParseUtilitiesRefactor.parseDictionaryXml(aContext, dictEl);
            m.put(id, dictEngine);
        }
        return m;
    }

    private static DictionaryEngine parseDictionaryXml(UimaContext annotCtx, Element rootDictEl) throws ResourceAccessException {
        AbstractBaseDictionary dict;
        String extResrcKey = rootDictEl.getAttributeValue("externalResourceKey");
        Object extResrc = annotCtx.getResourceObject(extResrcKey);
        if (extResrc == null) {
            throw new ResourceAccessException("Unable to find external resource with key:" + extResrcKey, null);
        }
        Element lookupFieldEl = rootDictEl.getChild("lookupField");
        String lookupFieldName = lookupFieldEl.getAttributeValue("fieldName");
        try {
            if (rootDictEl.getChild("implementation").getChildren().isEmpty()) {
                throw new ResourceAccessException((Throwable)new IndexOutOfBoundsException());
            }
            Element implEl = (Element)rootDictEl.getChild("implementation").getChildren().get(0);
            String implType = implEl.getName();
            if (implType.equals("luceneImpl")) {
                if (!(extResrc instanceof LuceneIndexReaderResource)) {
                    throw new ResourceAccessException("Expected external resource to be:" + LuceneIndexReaderResource.class, new Object[]{extResrc});
                }
                IndexReader indexReader = ((LuceneIndexReaderResource)extResrc).getIndexReader();
                IndexSearcher indexSearcher = new IndexSearcher(indexReader);
                dict = new LuceneDictionaryImpl(indexSearcher, lookupFieldName, MAX_LIST_SIZE);
            } else if (implType.equals("jdbcImpl")) {
                String tableName = implEl.getAttributeValue("tableName");
                if (!(extResrc instanceof JdbcConnectionResource)) {
                    throw new ResourceAccessException("Expected external resource to be:" + JdbcConnectionResource.class, new Object[]{extResrc});
                }
                Connection conn = ((JdbcConnectionResource)extResrc).getConnection();
                dict = new JdbcDictionaryImpl(conn, tableName, lookupFieldName);
            } else if (implType.equals("csvImpl")) {
                String fieldDelimiter = implEl.getAttributeValue("delimiter");
                if (!(extResrc instanceof FileResource)) {
                    throw new ResourceAccessException("Expected external resource to be:" + FileResource.class, new Object[]{extResrc});
                }
                String idxFieldNameStr = implEl.getAttributeValue("indexedFieldNames");
                StringTokenizer st = new StringTokenizer(idxFieldNameStr, ",");
                int arrIdx = 0;
                String[] idxFieldNameArr = new String[st.countTokens()];
                while (st.hasMoreTokens()) {
                    idxFieldNameArr[arrIdx++] = st.nextToken().trim();
                }
                File csvFile = ((FileResource)extResrc).getFile();
                try {
                    StringTable strTable = StringTableFactory.build((Reader)new FileReader(csvFile), fieldDelimiter, idxFieldNameArr, true);
                    dict = new StringTableDictionaryImpl(strTable, lookupFieldName);
                }
                catch (FileNotFoundException fnfE) {
                    throw new ResourceAccessException("Could not open csv file", new Object[]{csvFile});
                }
                catch (IOException ioE) {
                    throw new ResourceAccessException("Could not open csv file", new Object[]{csvFile});
                }
            } else {
                throw new ResourceAccessException("Unsupported impl type:" + implType, new Object[]{implType});
            }
            List rootDictChildren = rootDictEl.getChild("metaFields").getChildren();
            for (Element metaFieldEl : rootDictChildren) {
                String metaFieldName = metaFieldEl.getAttributeValue("fieldName");
                dict.retainMetaData(metaFieldName);
            }
        }
        catch (NullPointerException npE) {
            throw new ResourceAccessException((Throwable)npE);
        }
        boolean keepCase = Boolean.parseBoolean(rootDictEl.getAttributeValue("caseSensitive"));
        DictionaryEngine dictEngine = new DictionaryEngine(dict, keepCase);
        Element excludeList = rootDictEl.getChild("excludeList");
        if (excludeList != null && excludeList.getChildren() != null && !excludeList.getChildren().isEmpty()) {
            LookupParseUtilitiesRefactor.addExcludeList(dictEngine, excludeList.getChildren());
        }
        return dictEngine;
    }

    private static void addExcludeList(DictionaryEngine dictionaryEngine, List<Element> elementList) {
        HashSet<String> excludeValues = new HashSet<String>(elementList.size());
        for (Element item : elementList) {
            String excludeValue = item.getAttributeValue("value");
            CLASS_LOGGER.info((Object)("Adding exclude value[" + excludeValue + "]"));
            excludeValues.add(excludeValue);
        }
        StringPreLookupFilterImpl filter = new StringPreLookupFilterImpl(excludeValues);
        dictionaryEngine.addPreLookupFilter(filter);
    }

    private static Set<LookupSpec> parseLookupBindingXml(UimaContext annotCtx, Map<String, DictionaryEngine> dictMap, Element lookupBindingsEl) throws AnnotatorContextException {
        Class[] constrArgs = new Class[]{UimaContext.class, Properties.class};
        Object[] constrArgsConsum = new Class[]{UimaContext.class, Properties.class, Integer.TYPE};
        Object[] constrArgsConsumB = new Class[]{UimaContext.class, Properties.class};
        HashSet<LookupSpec> lsSet = new HashSet<LookupSpec>();
        List bindingChildren = lookupBindingsEl.getChildren();
        try {
            for (Element bindingEl : bindingChildren) {
                Element dictEl = bindingEl.getChild("dictionaryRef");
                String dictID = dictEl.getAttributeValue("idRef");
                DictionaryEngine dictEngine = dictMap.get(dictID);
                if (dictEngine == null) {
                    throw new AnnotatorContextException("Dictionary undefined: " + dictID, null);
                }
                Element lookupInitEl = bindingEl.getChild("lookupInitializer");
                String liClassName = lookupInitEl.getAttributeValue("className");
                Element liPropertiesEl = lookupInitEl.getChild("properties");
                Properties liProps = LookupParseUtilitiesRefactor.parsePropertiesXml(liPropertiesEl);
                Class<?> liClass = Class.forName(liClassName);
                Constructor<?> liConstr = liClass.getConstructor(constrArgs);
                Object[] liArgs = new Object[]{annotCtx, liProps};
                LookupInitializer li = (LookupInitializer)liConstr.newInstance(liArgs);
                Element lookupConsumerEl = bindingEl.getChild("lookupConsumer");
                String lcClassName = lookupConsumerEl.getAttributeValue("className");
                Element lcPropertiesEl = lookupConsumerEl.getChild("properties");
                Properties lcProps = LookupParseUtilitiesRefactor.parsePropertiesXml(lcPropertiesEl);
                Class<?> lcClass = Class.forName(lcClassName);
                Constructor<?>[] consts = lcClass.getConstructors();
                Constructor<?> lcConstr = null;
                Object[] lcArgs = null;
                for (Constructor<?> constConstr : consts) {
                    lcConstr = constConstr;
                    if (Arrays.equals(constrArgsConsum, lcConstr.getParameterTypes())) {
                        lcConstr = lcClass.getConstructor((Class<?>[])constrArgsConsum);
                        lcArgs = new Object[]{annotCtx, lcProps, MAX_LIST_SIZE};
                        continue;
                    }
                    if (!Arrays.equals(constrArgsConsumB, lcConstr.getParameterTypes())) continue;
                    lcConstr = lcClass.getConstructor((Class<?>[])constrArgsConsumB);
                    lcArgs = new Object[]{annotCtx, lcProps};
                }
                LookupConsumer lc = (LookupConsumer)lcConstr.newInstance(lcArgs);
                LookupAlgorithm la = li.getLookupAlgorithm(dictEngine);
                LookupSpec ls = new LookupSpec(la, li, lc);
                lsSet.add(ls);
            }
        }
        catch (ClassNotFoundException cnfE) {
            throw new AnnotatorContextException((Throwable)cnfE);
        }
        catch (NoSuchMethodException nsmE) {
            throw new AnnotatorContextException((Throwable)nsmE);
        }
        catch (SecurityException secE) {
            throw new AnnotatorContextException((Throwable)secE);
        }
        catch (InstantiationException instE) {
            throw new AnnotatorContextException((Throwable)instE);
        }
        catch (IllegalAccessException iaE) {
            throw new AnnotatorContextException((Throwable)iaE);
        }
        catch (InvocationTargetException itE) {
            throw new AnnotatorContextException((Throwable)itE);
        }
        catch (AnnotatorInitializationException aiE) {
            throw new AnnotatorContextException((Throwable)aiE);
        }
        catch (ClassCastException ccE) {
            throw new AnnotatorContextException((Throwable)ccE);
        }
        catch (NullPointerException npE) {
            throw new AnnotatorContextException((Throwable)npE);
        }
        return lsSet;
    }

    private static Properties parsePropertiesXml(Element propsEl) {
        Properties props = new Properties();
        List propertyChildren = propsEl.getChildren();
        for (Element propEl : propertyChildren) {
            String key = propEl.getAttributeValue("key");
            String value = propEl.getAttributeValue("value");
            props.put(key, value);
        }
        return props;
    }
}

