/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.classify.tui;

import cc.mallet.classify.Classifier;
import cc.mallet.pipe.iterator.SelectiveFileLineIterator;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.Labeling;
import cc.mallet.util.CommandOption;
import cc.mallet.util.MalletLogger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.logging.Logger;

public class SvmLight2Classify {
    private static Logger logger = MalletLogger.getLogger(SvmLight2Classify.class.getName());
    static CommandOption.File inputFile = new CommandOption.File(SvmLight2Classify.class, "input", "FILE", true, null, "The file containing data to be classified, one instance per line", null);
    static CommandOption.File outputFile = new CommandOption.File(SvmLight2Classify.class, "output", "FILE", true, new File("text.vectors"), "Write predictions to this file; Using - indicates stdout.", null);
    static CommandOption.File classifierFile = new CommandOption.File(SvmLight2Classify.class, "classifier", "FILE", true, new File("classifier"), "Use the pipe and alphabets from a previously created vectors file.\n   Allows the creation, for example, of a test set of vectors that are\n   compatible with a previously created set of training vectors", null);
    static CommandOption.String encoding = new CommandOption.String(SvmLight2Classify.class, "encoding", "STRING", true, Charset.defaultCharset().displayName(), "Character encoding for input file", null);

    public static void main(String[] args) throws FileNotFoundException, IOException {
        CommandOption.setSummary(SvmLight2Classify.class, "A tool for classifying a stream of unlabeled instances");
        CommandOption.process(SvmLight2Classify.class, args);
        if (args.length == 0) {
            CommandOption.getList(SvmLight2Classify.class).printUsage(false);
            System.exit(-1);
        }
        if (inputFile == null) {
            throw new IllegalArgumentException("You must include `--input FILE ...' in order to specify afile containing the instances, one per line.");
        }
        Classifier classifier = null;
        try {
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(SvmLight2Classify.classifierFile.value)));
            classifier = (Classifier)ois.readObject();
            ois.close();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Problem loading classifier from file " + SvmLight2Classify.classifierFile.value + ": " + e.getMessage());
        }
        classifier.getInstancePipe().getDataAlphabet().stopGrowth();
        classifier.getInstancePipe().getTargetAlphabet().stopGrowth();
        InstanceList instances = new InstanceList(classifier.getInstancePipe());
        InputStreamReader fileReader = inputFile.equals("-") ? new InputStreamReader(System.in) : new InputStreamReader((InputStream)new FileInputStream(SvmLight2Classify.inputFile.value), SvmLight2Classify.encoding.value);
        instances.addThruPipe(new SelectiveFileLineIterator(fileReader, "^\\s*#.+"));
        Iterator iterator = instances.iterator();
        PrintStream out = null;
        out = SvmLight2Classify.outputFile.value.toString().equals("-") ? System.out : new PrintStream(SvmLight2Classify.outputFile.value, SvmLight2Classify.encoding.value);
        while (iterator.hasNext()) {
            Instance instance = (Instance)iterator.next();
            Labeling labeling = classifier.classify(instance).getLabeling();
            StringBuilder output = new StringBuilder();
            output.append(instance.getName());
            for (int location = 0; location < labeling.numLocations(); ++location) {
                output.append("\t" + labeling.labelAtLocation(location));
                output.append("\t" + labeling.valueAtLocation(location));
            }
            out.println(output);
        }
        if (!SvmLight2Classify.outputFile.value.toString().equals("-")) {
            out.close();
        }
    }
}

