/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.sideeffect.ae;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ctakes.core.resource.FileResource;
import org.apache.ctakes.core.util.DocumentIDAnnotationUtil;
import org.apache.ctakes.core.util.FSUtil;
import org.apache.ctakes.drugner.type.SubSectionAnnotation;
import org.apache.ctakes.sideeffect.type.SESentence;
import org.apache.ctakes.sideeffect.type.SideEffectAnnotation;
import org.apache.ctakes.sideeffect.util.PatternMatch;
import org.apache.ctakes.sideeffect.util.SEUtil;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Segment;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.resource.ResourceInitializationException;

public class SideEffectAnnotator
extends JCasAnnotator_ImplBase {
    private Map<String, String> keyDrugMap = new HashMap<String, String>();
    private Map<String, Set<String>> sideEffectMap = new HashMap<String, Set<String>>();
    private Set<String> setionsToIgnore = new HashSet<String>();
    private List<String> causeVerb = new ArrayList<String>();
    private List<String> causeWord1 = new ArrayList<String>();
    private List<String> causeWord2 = new ArrayList<String>();
    private List<String> discontVerb = new ArrayList<String>();
    private List<String> sideEffectWord = new ArrayList<String>();
    private List<String> noteVerb = new ArrayList<String>();
    private List<String> madeVerb = new ArrayList<String>();
    private List<String> afterWord = new ArrayList<String>();

    public void initialize(UimaContext annotCtx) throws ResourceInitializationException {
        super.initialize(annotCtx);
        FileResource fResrc = null;
        try {
            fResrc = (FileResource)this.getContext().getResourceObject("sideEffectTable");
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        this.setMap(fResrc.getFile(), this.keyDrugMap, this.sideEffectMap);
        try {
            int i;
            String[] str = (String[])this.getContext().getConfigParameterValue("sectionsToIgnore");
            for (i = 0; i < str.length; ++i) {
                this.setionsToIgnore.add(str[i]);
            }
            str = (String[])this.getContext().getConfigParameterValue("hasPatternOfDrugCauseVerbPse");
            for (i = 0; i < str.length; ++i) {
                this.causeVerb.add(str[i]);
            }
            str = (String[])this.getContext().getConfigParameterValue("hasPatternOfPseDueToDrug");
            for (i = 0; i < str.length; ++i) {
                this.causeWord1.add(str[i]);
            }
            str = (String[])this.getContext().getConfigParameterValue("hasPatternOfDrugDueToPse");
            for (i = 0; i < str.length; ++i) {
                this.causeWord2.add(str[i]);
            }
            str = (String[])this.getContext().getConfigParameterValue("hasPatternOfDiscontDrugBecausePse");
            for (i = 0; i < str.length; ++i) {
                this.discontVerb.add(str[i]);
            }
            str = (String[])this.getContext().getConfigParameterValue("sideEffectWord");
            for (i = 0; i < str.length; ++i) {
                this.sideEffectWord.add(str[i]);
            }
            str = (String[])this.getContext().getConfigParameterValue("hasPatternOfNotePseWithDrug");
            for (i = 0; i < str.length; ++i) {
                this.noteVerb.add(str[i]);
            }
            str = (String[])this.getContext().getConfigParameterValue("hasPatternOfDrugMadePse");
            for (i = 0; i < str.length; ++i) {
                this.madeVerb.add(str[i]);
            }
            str = (String[])this.getContext().getConfigParameterValue("hasPatternOfPseAfterDrug");
            for (i = 0; i < str.length; ++i) {
                this.afterWord.add(str[i]);
            }
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        String docName = DocumentIDAnnotationUtil.getDocumentID((JCas)jcas);
        System.out.println("---" + docName + " processed---");
        this.removeDuplicatedNEs(jcas);
        List<PotentialSideEffect> potentialSideEffectLst = this.getPotentialSideEffects(jcas);
        List<SideEffect> sideEffectLst = this.getSideEffectsWithPrioritizedRule(jcas, potentialSideEffectLst);
        this.annotateSideEffects(jcas, sideEffectLst);
    }

    private void removeDuplicatedNEs(JCas jcas) {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator neItr = indexes.getAnnotationIndex(IdentifiedAnnotation.type).iterator();
        HashSet<String> spanSet = new HashSet<String>();
        ArrayList<IdentifiedAnnotation> duplicatedNE = new ArrayList<IdentifiedAnnotation>();
        while (neItr.hasNext()) {
            IdentifiedAnnotation nea = (IdentifiedAnnotation)((Object)neItr.next());
            String span = Integer.toString(nea.getTypeID()) + "|" + Integer.toString(nea.getBegin()) + "|" + Integer.toString(nea.getEnd());
            if (spanSet.contains(span)) {
                duplicatedNE.add(nea);
            }
            spanSet.add(span);
        }
        for (IdentifiedAnnotation ne : duplicatedNE) {
            ne.removeFromIndexes();
        }
    }

    private List<IdentifiedAnnotation> getSideEffectNEs(JCas jcas) {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator neItr = indexes.getAnnotationIndex(IdentifiedAnnotation.type).iterator();
        ArrayList<IdentifiedAnnotation> l = new ArrayList<IdentifiedAnnotation>();
        while (neItr.hasNext()) {
            IdentifiedAnnotation nea = (IdentifiedAnnotation)((Object)neItr.next());
            if (this.setionsToIgnore.contains(nea.getSegmentID()) || nea.getPolarity() == -1) continue;
            boolean addFlag = true;
            if (nea.getTypeID() != 3 && nea.getTypeID() != 2) continue;
            if (l.size() == 0) {
                l.add(nea);
                continue;
            }
            for (int i = 0; i < l.size(); ++i) {
                IdentifiedAnnotation x = (IdentifiedAnnotation)((Object)l.get(i));
                int j = SEUtil.contains(nea.getBegin(), nea.getEnd(), x.getBegin(), x.getEnd());
                if (j == 1) {
                    l.remove(i);
                    --i;
                    continue;
                }
                if (j != 2) continue;
                addFlag = false;
                break;
            }
            if (!addFlag) continue;
            l.add(nea);
        }
        return l;
    }

    private List<PotentialSideEffect> getPotentialSideEffects(JCas jcas) {
        List<IdentifiedAnnotation> l = this.getSideEffectNEs(jcas);
        ArrayList<PotentialSideEffect> ll = new ArrayList<PotentialSideEffect>();
        for (int i = 0; i < l.size(); ++i) {
            int num;
            int[] previousSenSpan;
            IdentifiedAnnotation ne = l.get(i);
            int[] senSpan = SEUtil.getSentenceSpanContainingGivenSpan(jcas, ne.getBegin(), ne.getEnd());
            String sentence = SEUtil.getSentenceTextContainingGivenSpan(jcas, ne.getBegin(), ne.getEnd()).trim();
            boolean foundDrug = false;
            FSIterator neIter = FSUtil.getAnnotationsInSpanIterator((JCas)jcas, (int)IdentifiedAnnotation.type, (int)senSpan[0], (int)(senSpan[1] + 1));
            while (neIter.hasNext()) {
                IdentifiedAnnotation n = (IdentifiedAnnotation)((Object)neIter.next());
                if (n.getTypeID() != 1) continue;
                PotentialSideEffect pse = new PotentialSideEffect();
                pse.ne = ne;
                pse.sentence = sentence;
                pse.senBegin = senSpan[0];
                pse.senEnd = senSpan[1];
                pse.drug = n;
                ll.add(pse);
                foundDrug = true;
            }
            if (foundDrug || ne.getSegmentID().equals("20105") || !SEUtil.isSpanInSameLine(jcas, (previousSenSpan = SEUtil.getSentenceSpanOfGivenSentenceNum(jcas, num = (num = SEUtil.getSentenceNumContainingGivenSpan(jcas, ne.getBegin(), ne.getEnd())) > 0 ? num - 1 : num))[0], senSpan[1])) continue;
            neIter = FSUtil.getAnnotationsInSpanIterator((JCas)jcas, (int)IdentifiedAnnotation.type, (int)previousSenSpan[0], (int)(previousSenSpan[1] + 1));
            while (neIter.hasNext()) {
                IdentifiedAnnotation n = (IdentifiedAnnotation)((Object)neIter.next());
                if (n.getTypeID() != 1) continue;
                PotentialSideEffect pse = new PotentialSideEffect();
                pse.ne = ne;
                pse.sentence = SEUtil.getSentenceTextContainingGivenSpan(jcas, n.getBegin(), n.getEnd()) + " " + sentence;
                pse.senBegin = previousSenSpan[0];
                pse.senEnd = senSpan[1];
                pse.drug = n;
                ll.add(pse);
            }
        }
        return ll;
    }

    private List<SideEffect> getSideEffectsWithPrioritizedRule(JCas jcas, List<PotentialSideEffect> pseLst) {
        ArrayList<SideEffect> seLst = new ArrayList<SideEffect>();
        for (PotentialSideEffect pse : pseLst) {
            String input = this.getRegexInput(jcas, pse);
            SideEffect se = new SideEffect();
            if (this.isInAllergySection(jcas, pse)) {
                se.pse = pse;
                se.rule = "isInAllergySection";
                seLst.add(se);
                continue;
            }
            if (this.hasPatternOfDrugDueToPse(jcas, pse, input)) {
                se.pse = pse;
                se.rule = "hasPatternOfDrugDueToPse";
                seLst.add(se);
                continue;
            }
            if (this.hasPatternOfDrugCausePse(jcas, pse, input)) {
                se.pse = pse;
                se.rule = "hasPatternOfDrugCausePse";
                seLst.add(se);
                continue;
            }
            if (this.hasPatternOfDrugMadePse(jcas, pse, input)) {
                se.pse = pse;
                se.rule = "hasPatternOfDrugMadePse";
                seLst.add(se);
                continue;
            }
            if (this.hasWordOfSideEffect(jcas, pse, input)) {
                se.pse = pse;
                se.rule = "hasWordOfSideEffect";
                seLst.add(se);
                continue;
            }
            if (this.hasPatternOfPseDueToDrug(jcas, pse, input)) {
                se.pse = pse;
                se.rule = "hasPatternOfPseDueToDrug";
                seLst.add(se);
                continue;
            }
            if (this.hasSideEffectAsPse(jcas, pse, input)) {
                se.pse = pse;
                se.rule = "hasSideEffectAsPse";
                seLst.add(se);
                continue;
            }
            if (this.hasPatternOfNotePseWithDrug(jcas, pse, input)) {
                se.pse = pse;
                se.rule = "hasPatternOfNotePseWithDrug";
                seLst.add(se);
                continue;
            }
            if (this.hasPatternOfDiscontDrugBecausePse(jcas, pse, input)) {
                se.pse = pse;
                se.rule = "hasPatternOfDiscontDrugBecausePse";
                seLst.add(se);
                continue;
            }
            if (this.hasPatternOfDrugDiscontBecausePse(jcas, pse, input)) {
                se.pse = pse;
                se.rule = "hasPatternOfDrugDiscontBecausePse";
                seLst.add(se);
                continue;
            }
            if (this.hasPatternOfPseAfterDrug(jcas, pse, input)) {
                se.pse = pse;
                se.rule = "hasPatternOfPseAfterDrug";
                seLst.add(se);
                continue;
            }
            if (this.isInParenthesis(jcas, pse, input)) {
                se.pse = pse;
                se.rule = "isInParenthesis";
                seLst.add(se);
                continue;
            }
            if (!this.isInDictionary(jcas, pse)) continue;
            se.pse = pse;
            se.rule = "isInDictionary";
            seLst.add(se);
        }
        return seLst;
    }

    private void annotateSideEffects(JCas jcas, List<SideEffect> seLst) {
        for (int i = 0; i < seLst.size(); ++i) {
            SideEffect se = seLst.get(i);
            SideEffectAnnotation sea = new SideEffectAnnotation(jcas);
            sea.setSideEffect(se.pse.ne);
            if (se.pse.ne != null) {
                sea.setBegin(se.pse.ne.getBegin());
                sea.setEnd(se.pse.ne.getEnd());
            } else {
                sea.setBegin(se.pse.senBegin);
                sea.setEnd(se.pse.senEnd);
            }
            sea.setDrug(se.pse.drug);
            SESentence ses = new SESentence(jcas);
            ses.setBegin(se.pse.senBegin);
            ses.setEnd(se.pse.senEnd);
            sea.setSentence(ses);
            sea.addToIndexes();
        }
    }

    private void setMap(File file, Map<String, String> keyMap, Map<String, Set<String>> seMap) {
        try {
            BufferedReader fileReader = new BufferedReader(new FileReader(file));
            String line = "";
            while ((line = fileReader.readLine()) != null) {
                int i;
                if (line.startsWith("//")) continue;
                line = line.toLowerCase();
                String[] str = line.split("\\|");
                String genericDrug = str[0].trim();
                String[] brandDrugs = str[1].split(",");
                String[] sideEffects = str[2].split(",");
                HashSet<String> seSet = new HashSet<String>();
                keyMap.put(genericDrug, genericDrug);
                for (i = 0; i < brandDrugs.length; ++i) {
                    keyMap.put(brandDrugs[i].trim(), genericDrug);
                }
                for (i = 0; i < sideEffects.length; ++i) {
                    seSet.add(sideEffects[i].trim());
                }
                seMap.put(genericDrug, seSet);
            }
            fileReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean hasPatternOfPseDueToDrug(JCas jcas, PotentialSideEffect pse, String input) {
        if (pse.drug.getPolarity() == -1) {
            return false;
        }
        PatternMatch pm = new PatternMatch("(<@PSE>).*(KW).*(<@DRUG>)", input, this.causeWord1);
        if (!pm.mat.find()) {
            return false;
        }
        if (pm.isDrugBetween(pm.mat.end(1), pm.mat.start(2))) {
            return false;
        }
        if (pm.isPseBetween(pm.mat.end(2), pm.mat.start(3))) {
            return false;
        }
        int[] drugSpan = new int[]{-1, -1};
        return !pm.isDrugBetween(pm.mat.end(2), pm.mat.start(3), drugSpan) || !pm.isDistantBetween(drugSpan[1], pm.mat.start(3));
    }

    private boolean hasPatternOfDrugDueToPse(JCas jcas, PotentialSideEffect pse, String input) {
        PatternMatch pm = new PatternMatch("(<@DRUG>).*(KW).*(<@PSE>)", input, this.causeWord2);
        if (!pm.mat.find()) {
            return false;
        }
        if (pm.isPseBetween(pm.mat.end(1), pm.mat.start(2))) {
            return false;
        }
        if (pm.isDrugBetween(pm.mat.end(2), pm.mat.start(3))) {
            return false;
        }
        return !pm.isDrugBetween(pm.mat.end(1), pm.mat.start(2)) || !pm.isDistantBetween(pm.mat.end(1), pm.mat.start(2));
    }

    private boolean hasPatternOfDiscontDrugBecausePse(JCas jcas, PotentialSideEffect pse, String input) {
        PatternMatch pm = new PatternMatch("(KW).*(<@DRUG>).*(because|after).*(<@PSE>)", input, this.discontVerb);
        if (!pm.mat.find()) {
            return false;
        }
        if (pm.isPseBetween(pm.mat.end(1), pm.mat.start(2))) {
            return false;
        }
        if (pm.isPseBetween(pm.mat.end(2), pm.mat.start(3))) {
            return false;
        }
        if (pm.isDrugBetween(pm.mat.end(3), pm.mat.start(4))) {
            return false;
        }
        int[] drugSpan = new int[]{-1, -1};
        return !pm.isDrugBetween(pm.mat.end(1), pm.mat.start(2), drugSpan) || !pm.isDistantBetween(drugSpan[1], pm.mat.start(2));
    }

    private boolean hasPatternOfDrugDiscontBecausePse(JCas jcas, PotentialSideEffect pse, String input) {
        PatternMatch pm = new PatternMatch("(<@DRUG>).*(KW).*(because|after).*(<@PSE>)", input, this.discontVerb);
        if (!pm.mat.find()) {
            return false;
        }
        if (pm.isPseBetween(pm.mat.end(2), pm.mat.start(3))) {
            return false;
        }
        if (pm.isDrugBetween(pm.mat.end(2), pm.mat.start(3))) {
            return false;
        }
        if (pm.isDrugBetween(pm.mat.end(3), pm.mat.start(4))) {
            return false;
        }
        int[] drugSpan = new int[]{-1, -1};
        return !pm.isDrugBetween(pm.mat.end(1), pm.mat.start(2), drugSpan) || !pm.isDistantBetween(pm.mat.end(1), drugSpan[0]);
    }

    private boolean hasPatternOfNotePseWithDrug(JCas jcas, PotentialSideEffect pse, String input) {
        PatternMatch pm = new PatternMatch("(KW).*(<@PSE>).*(with).*(<@DRUG>)", input, this.noteVerb);
        if (!pm.mat.find()) {
            return false;
        }
        if (pm.isDrugBetween(pm.mat.end(1), pm.mat.start(2))) {
            return false;
        }
        if (pm.isDrugBetween(pm.mat.end(2), pm.mat.start(3))) {
            return false;
        }
        if (pm.isPseBetween(pm.mat.end(3), pm.mat.start(4))) {
            return false;
        }
        int[] drugSpan = new int[]{-1, -1};
        return !pm.isDrugBetween(pm.mat.end(3), pm.mat.start(4), drugSpan) || !pm.isDistantBetween(drugSpan[1], pm.mat.start(4));
    }

    private boolean hasPatternOfDrugCausePse(JCas jcas, PotentialSideEffect pse, String input) {
        PatternMatch pm = new PatternMatch("(<@DRUG>).*(KW).*(<@PSE>)", input, this.causeVerb);
        if (!pm.mat.find()) {
            return false;
        }
        if (pm.isDrugBetween(pm.mat.end(2), pm.mat.start(3))) {
            return false;
        }
        int[] drugSpan = new int[]{-1, -1};
        return !pm.isDrugBetween(pm.mat.end(1), pm.mat.start(2), drugSpan) || !pm.isDistantBetween(pm.mat.end(1), drugSpan[0]);
    }

    private boolean hasPatternOfDrugMadePse(JCas jcas, PotentialSideEffect pse, String input) {
        PatternMatch pm = new PatternMatch("(<@DRUG>).*(KW)\\s(him|her)\\s(<@PSE>)", input, this.madeVerb);
        if (!pm.mat.find()) {
            return false;
        }
        int[] drugSpan = new int[]{-1, -1};
        return !pm.isDrugBetween(pm.mat.end(1), pm.mat.start(2), drugSpan) || !pm.isDistantBetween(pm.mat.end(1), drugSpan[0]);
    }

    private boolean hasWordOfSideEffect(JCas jcas, PotentialSideEffect pse, String input) {
        String pseStr = pse.ne.getCoveredText().replace('-', ' ').toLowerCase().trim();
        if (this.sideEffectWord.contains(pseStr)) {
            return false;
        }
        String pseSen = pse.sentence.replace('-', ' ').toLowerCase().trim();
        PatternMatch pm = new PatternMatch("(KW)", pseSen, this.sideEffectWord);
        if (!pm.mat.find()) {
            return false;
        }
        FSIterator neIter = FSUtil.getAnnotationsInSpanIterator((JCas)jcas, (int)IdentifiedAnnotation.type, (int)pse.senBegin, (int)(pse.senEnd + 1));
        while (neIter.hasNext()) {
            IdentifiedAnnotation ne = (IdentifiedAnnotation)((Object)neIter.next());
            if (ne.getCoveredText().replace('-', ' ').toLowerCase().trim().indexOf(pm.mat.group(1)) == -1 || ne.getPolarity() != -1) continue;
            return false;
        }
        return true;
    }

    private boolean hasSideEffectAsPse(JCas jcas, PotentialSideEffect pse, String input) {
        if (input.matches(".*(dicussed|concerned).*")) {
            return false;
        }
        String str = pse.ne.getCoveredText().replace('-', ' ').toLowerCase().trim();
        if (!this.sideEffectWord.contains(str)) {
            return false;
        }
        return !input.matches(".*(<PSE>).*");
    }

    private boolean hasPatternOfPseAfterDrug(JCas jcas, PotentialSideEffect pse, String input) {
        if (input.matches(".*(check).*")) {
            return false;
        }
        PatternMatch pm = new PatternMatch("(<@PSE>).*(KW).*(<@DRUG>)", input, this.afterWord);
        if (!pm.mat.find()) {
            return false;
        }
        if (pm.isDrugBetween(pm.mat.end(1), pm.mat.start(2))) {
            return false;
        }
        if (pm.isPseBetween(pm.mat.end(2), pm.mat.start(3))) {
            return false;
        }
        int[] drugSpan = new int[]{-1, -1};
        return !pm.isDrugBetween(pm.mat.end(2), pm.mat.start(3), drugSpan) || !pm.isDistantBetween(drugSpan[1], pm.mat.start(3));
    }

    private boolean isInAllergySection(JCas jcas, PotentialSideEffect pse) {
        if (!pse.ne.getSegmentID().equals("20105")) {
            return false;
        }
        boolean inMedication = false;
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        block0: for (Segment sa : indexes.getAnnotationIndex(Segment.type)) {
            if (sa.getBegin() >= pse.ne.getBegin() || sa.getEnd() <= pse.ne.getEnd()) continue;
            FSIterator ssIter = FSUtil.getAnnotationsInSpanIterator((JCas)jcas, (int)SubSectionAnnotation.type, (int)sa.getBegin(), (int)sa.getEnd());
            while (ssIter.hasNext()) {
                SubSectionAnnotation ss = (SubSectionAnnotation)ssIter.next();
                if (!ss.getCoveredText().toLowerCase().trim().startsWith("medication") || ss.getSubSectionHeaderBegin() >= pse.ne.getBegin() || ss.getSubSectionBodyEnd() <= pse.ne.getEnd()) continue;
                inMedication = true;
                continue block0;
            }
        }
        return inMedication;
    }

    private boolean isInParenthesis(JCas jcas, PotentialSideEffect pse, String input) {
        PatternMatch pm = new PatternMatch("(<@DRUG>)\\s(\\(.*<@PSE>.*\\))", input);
        if (!pm.mat.find()) {
            return false;
        }
        if (pm.mat.group(2).matches("\\(.*((for)|(treated with)).*\\)")) {
            return false;
        }
        if (pm.mat.group(2).matches("\\(.*(made|got).*\\)")) {
            return true;
        }
        return input.matches(".*trial.*");
    }

    private boolean isInDictionary(JCas jcas, PotentialSideEffect pse) {
        String pseStr;
        Set<String> seSet;
        String drug = pse.drug.getCoveredText().toLowerCase().trim();
        return this.keyDrugMap.containsKey(drug) && (seSet = this.sideEffectMap.get(this.keyDrugMap.get(drug))).contains(pseStr = pse.ne.getCoveredText().toLowerCase().trim());
    }

    private String getRegexInput(JCas jcas, PotentialSideEffect pse) {
        String str = pse.sentence.toLowerCase();
        FSIterator neIter = FSUtil.getAnnotationsInSpanIterator((JCas)jcas, (int)IdentifiedAnnotation.type, (int)pse.senBegin, (int)(pse.senEnd + 1));
        while (neIter.hasNext()) {
            IdentifiedAnnotation nea = (IdentifiedAnnotation)((Object)neIter.next());
            if (nea.getTypeID() == 1) {
                String drug = "";
                drug = nea.getBegin() == pse.drug.getBegin() && nea.getEnd() == pse.drug.getEnd() ? "<@DRUG>" : "<DRUG>";
                str = str.replaceFirst(nea.getCoveredText().replaceAll("[\\<\\(\\[\\{\\\\^\\-\\=\\$\\!\\|\\]\\}\\)\\?\\*\\+\\.\\>]", "").toLowerCase(), drug);
                continue;
            }
            if (nea.getTypeID() != 2 && nea.getTypeID() != 3) continue;
            String ps = "";
            ps = nea.getBegin() == pse.ne.getBegin() && nea.getEnd() == pse.ne.getEnd() ? "<@PSE>" : "<PSE>";
            str = str.replaceFirst(nea.getCoveredText().replaceAll("[\\<\\(\\[\\{\\\\^\\-\\=\\$\\!\\|\\]\\}\\)\\?\\*\\+\\.\\>]", "").toLowerCase(), ps);
        }
        return str.trim();
    }

    private class SideEffect {
        PotentialSideEffect pse;
        String rule;

        private SideEffect() {
        }
    }

    private class PotentialSideEffect {
        IdentifiedAnnotation ne;
        IdentifiedAnnotation drug;
        String sentence;
        int senBegin;
        int senEnd;

        private PotentialSideEffect() {
        }
    }
}

