/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.uima.UIMAFramework;
import org.apache.uima.util.Level;

public abstract class InputStreamHandler<T>
extends Thread {
    private BufferedReader reader;
    private T buffer = null;

    InputStreamHandler(T buffer, InputStream stream) {
        this.reader = new BufferedReader(new InputStreamReader(stream));
        this.buffer = buffer;
        this.start();
    }

    InputStreamHandler(T buffer, BufferedReader reader) {
        this.reader = reader;
        this.buffer = buffer;
        this.start();
    }

    public T getBuffer() {
        return this.buffer;
    }

    @Override
    public void run() {
        try {
            String nextLine;
            while ((nextLine = this.reader.readLine()) != null) {
                this.addToBuffer(nextLine);
            }
        }
        catch (IOException ioe) {
            UIMAFramework.getLogger(InputStreamHandler.class).log(Level.WARNING, ioe.getMessage());
        }
    }

    public abstract void addToBuffer(String var1);

    public static InputStreamHandler<StringBuffer> getInputStreamAsBufferedString(InputStream stream) {
        return new InputStreamHandler<StringBuffer>(new StringBuffer(), stream){

            @Override
            public synchronized void addToBuffer(String line) {
                ((StringBuffer)this.getBuffer()).append(line.trim());
            }
        };
    }

    public static InputStreamHandler<List<String>> getInputStreamAsList(InputStream stream) {
        return new InputStreamHandler<List<String>>(new ArrayList(), stream){

            @Override
            public synchronized void addToBuffer(String line) {
                ((List)this.getBuffer()).add(line);
            }
        };
    }
}

