/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.util.ae;

import java.io.File;
import java.io.IOException;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.FileUtils;
import org.cleartk.util.ViewUriUtil;

public class PlainTextWriter
extends JCasAnnotator_ImplBase {
    public static final String PARAM_OUTPUT_DIRECTORY_NAME = "outputDirectoryName";
    @ConfigurationParameter(name="outputDirectoryName", mandatory=true, description="takes a path to directory into which output files will be written.")
    private String outputDirectoryName;
    private File outputDirectory;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.outputDirectory = new File(this.outputDirectoryName);
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        String id = new File(ViewUriUtil.getURI(jCas)).getName();
        File outFile = new File(this.outputDirectory, id + ".txt");
        try {
            FileUtils.saveString2File((String)jCas.getDocumentText(), (File)outFile);
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    public void setOutputDirectoryName(String outputDirectoryName) {
        this.outputDirectoryName = outputDirectoryName;
    }
}

