/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.fsm.condition;

import net.openai.util.fsm.Condition;
import org.apache.ctakes.core.fsm.token.WordToken;

public class HourMinuteCondition
extends Condition {
    private int iv_minMinute;
    private int iv_maxMinute;
    private int iv_minHour;
    private int iv_maxHour;

    public HourMinuteCondition(int minHour, int maxHour, int minMinute, int maxMinute) {
        this.iv_minMinute = minMinute;
        this.iv_maxMinute = maxMinute;
        this.iv_minHour = minHour;
        this.iv_maxHour = maxHour;
    }

    public boolean satisfiedBy(Object conditional) {
        if (conditional instanceof WordToken) {
            int colonIndex;
            WordToken wt = (WordToken)conditional;
            String text = wt.getText();
            if (wt.getNumPosition() == 1 && (colonIndex = text.indexOf(58)) != -1) {
                String hourStr = text.substring(0, colonIndex);
                String minuteStr = text.substring(colonIndex + 1, text.length());
                try {
                    int hour = Integer.parseInt(hourStr);
                    int minutes = Integer.parseInt(minuteStr);
                    if (hour >= this.iv_minHour && hour <= this.iv_maxHour && minutes >= this.iv_minMinute && minutes <= this.iv_maxMinute) {
                        return true;
                    }
                }
                catch (NumberFormatException nfe) {
                    return false;
                }
            }
        }
        return false;
    }
}

