/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Db;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.InflectionRecord;
import gov.nih.nlm.nls.lvg.Db.InflectionVector;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class DbInflectionUtil {
    public static Vector<InflectionRecord> GetRecordsByIfTermCatInfl(String ifTerm, int cat, long infl, Connection conn, boolean isUniqueEui) throws SQLException {
        PreparedStatement ps = null;
        String query = "SELECT ifTerm, termCat, termInfl, eui, unTerm, ctTerm FROM Inflection WHERE ifTermLC = ? ";
        if (cat >= 0 && infl >= 0L) {
            query = query + " AND termCat = ? AND termInfl = ?";
            ps = conn.prepareStatement(query);
            ps.setString(1, ifTerm.toLowerCase());
            ps.setInt(2, cat);
            ps.setLong(3, infl);
        } else if (cat >= 0) {
            query = query + " AND termCat = ?";
            ps = conn.prepareStatement(query);
            ps.setString(1, ifTerm.toLowerCase());
            ps.setInt(2, cat);
        } else if (infl >= 0L) {
            query = query + " AND termInfl = ?";
            ps = conn.prepareStatement(query);
            ps.setString(1, ifTerm.toLowerCase());
            ps.setLong(2, infl);
        } else {
            ps = conn.prepareStatement(query);
            ps.setString(1, ifTerm.toLowerCase());
        }
        return DbInflectionUtil.GetRecordsByPreparedStatement(ps, isUniqueEui);
    }

    static Vector<InflectionRecord> GetRecordsByIfTermCat(String ifTerm, int cat, Connection conn) throws SQLException {
        String query = "SELECT ifTerm, termCat, termInfl, eui, unTerm, ctTerm FROM Inflection WHERE ifTermLC=? AND termCat=?";
        PreparedStatement ps = conn.prepareStatement(query);
        ps.setString(1, ifTerm.toLowerCase());
        ps.setInt(2, cat);
        return DbInflectionUtil.GetRecordsByPreparedStatement(ps, false);
    }

    static Vector<InflectionRecord> GetRecordsByIfTermInfl(String ifTerm, long infl, Connection conn) throws SQLException {
        String query = "SELECT ifTerm, termCat, termInfl, eui, unTerm, ctTerm FROM Inflection WHERE ifTermLC = ? AND termInfl = ?";
        PreparedStatement ps = conn.prepareStatement(query);
        ps.setString(1, ifTerm.toLowerCase());
        ps.setLong(2, infl);
        return DbInflectionUtil.GetRecordsByPreparedStatement(ps, false);
    }

    static Vector<InflectionRecord> GetRecordsByIfTermInfl(String ifTerm, long infl, Connection conn, boolean isUniqueEui) throws SQLException {
        PreparedStatement ps = null;
        String query = "SELECT ifTerm, termCat, termInfl, eui, unTerm, ctTerm FROM Inflection WHERE ifTermLC = ?";
        if (infl >= 0L) {
            query = query + " AND termInfl = ?";
            ps = conn.prepareStatement(query);
            ps.setString(1, ifTerm.toLowerCase());
            ps.setLong(2, infl);
        } else {
            ps = conn.prepareStatement(query);
            ps.setString(1, ifTerm.toLowerCase());
        }
        return DbInflectionUtil.GetRecordsByPreparedStatement(ps, isUniqueEui);
    }

    static InflectionRecord GetRecordByIfTerm(String ifTerm, Connection conn) throws SQLException {
        String query = "SELECT ifTerm, termCat, termInfl, eui, unTerm, ctTerm FROM Inflection WHERE ifTermLC = ?";
        PreparedStatement ps = conn.prepareStatement(query);
        ps.setString(1, ifTerm.toLowerCase());
        return DbInflectionUtil.GetRecordByPreparedStatement(ps);
    }

    static Vector<InflectionRecord> GetRecordsByIfTerm(String ifTerm, Connection conn, boolean isUniqueEui) throws SQLException {
        String query = "SELECT ifTerm, termCat, termInfl, eui, unTerm, ctTerm FROM Inflection WHERE ifTermLC = '" + DbBase.FormatSqlStr(ifTerm.toLowerCase()) + "'";
        return DbInflectionUtil.GetRecords(query, conn, isUniqueEui);
    }

    static Vector<InflectionRecord> GetRecordsBeginWithIfTerm(String ifTermBegin, Connection conn, boolean isUniqueEui) throws SQLException {
        String query = "SELECT ifTerm, termCat, termInfl, eui, unTerm, ctTerm FROM Inflection WHERE ifTermLC LIKE ?";
        PreparedStatement ps = conn.prepareStatement(query);
        ps.setString(1, ifTermBegin.toLowerCase() + "%");
        return DbInflectionUtil.GetRecordsByPreparedStatement(ps, isUniqueEui);
    }

    static InflectionRecord GetRecordByPreparedStatement(PreparedStatement ps) throws SQLException {
        InflectionRecord inflection = null;
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            inflection = DbInflectionUtil.GetOneInflectionRecord(rs);
        }
        rs.close();
        ps.close();
        return inflection;
    }

    static Vector<InflectionRecord> GetRecords(String query, Connection conn, boolean isUniqueEui) throws SQLException {
        InflectionVector<InflectionRecord> inflections = new InflectionVector<InflectionRecord>();
        Statement statement = conn.createStatement();
        ResultSet rs = statement.executeQuery(query);
        while (rs.next()) {
            InflectionRecord inflection = DbInflectionUtil.GetOneInflectionRecord(rs);
            if (isUniqueEui && inflections.ContainEui(inflection.GetEui())) continue;
            inflections.addElement(inflection);
        }
        rs.close();
        statement.close();
        return inflections;
    }

    static Vector<InflectionRecord> GetRecordsByPreparedStatement(PreparedStatement ps, boolean isUniqueEui) throws SQLException {
        InflectionVector<InflectionRecord> inflections = new InflectionVector<InflectionRecord>();
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            InflectionRecord inflection = DbInflectionUtil.GetOneInflectionRecord(rs);
            if (isUniqueEui && inflections.ContainEui(inflection.GetEui())) continue;
            inflections.addElement(inflection);
        }
        rs.close();
        ps.close();
        return inflections;
    }

    static InflectionRecord GetOneInflectionRecord(ResultSet rs) throws SQLException {
        InflectionRecord inflection = new InflectionRecord();
        inflection.SetInflectedTerm(rs.getString(1));
        inflection.SetCategory(rs.getInt(2));
        inflection.SetInflection(rs.getLong(3));
        inflection.SetEui(rs.getString(4));
        inflection.SetUnInflectedTerm(rs.getString(5));
        inflection.SetCitationTerm(rs.getString(6));
        return inflection;
    }
}

