/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Util;

import gov.nih.nlm.nls.lvg.Util.StrTokenObject;
import java.util.StringTokenizer;
import java.util.Vector;

public class StripToken {
    private static final StrTokenObject SPACE_DELIM = new StrTokenObject(" ", 2);

    public static Vector<StrTokenObject> Tokenize(String inStr) {
        return StripToken.Tokenize(inStr, "({[<\"'", ")}]>!?", ",.:;", " \t");
    }

    public static Vector<StrTokenObject> Tokenize(String inStr, String restoreD, String strippingD, String strippableD, String spaceD) {
        Vector<StrTokenObject> tokenList = new Vector<StrTokenObject>();
        StringTokenizer buf = new StringTokenizer(inStr, spaceD);
        while (buf.hasMoreTokens()) {
            String cur = buf.nextToken();
            Vector<StrTokenObject> curList = StripToken.Tokenize(cur, restoreD, strippingD, strippableD);
            tokenList.addAll(curList);
            tokenList.addElement(SPACE_DELIM);
        }
        int lastIndex = tokenList.size() - 1;
        if (lastIndex >= 0) {
            tokenList.remove(lastIndex);
        }
        return tokenList;
    }

    public static Vector<StrTokenObject> Tokenize(String inStr, String restoreD, String strippingD, String strippableD) {
        Vector<StrTokenObject> tokenList = new Vector<StrTokenObject>();
        String allDelim = restoreD + strippingD + strippableD;
        StringTokenizer buf = new StringTokenizer(inStr, allDelim, true);
        while (buf.hasMoreTokens()) {
            String cur = buf.nextToken();
            if (restoreD.indexOf(cur) != -1) {
                StripToken.AddToList(cur, 4, tokenList);
                continue;
            }
            if (strippingD.indexOf(cur) != -1) {
                StripToken.AddToList(cur, 5, tokenList);
                continue;
            }
            if (strippableD.indexOf(cur) != -1) {
                StripToken.AddToList(cur, 6, tokenList);
                continue;
            }
            StripToken.AddToList(cur, 1, tokenList);
        }
        return tokenList;
    }

    public static Vector<StrTokenObject> CleanUpToken(Vector<StrTokenObject> list) {
        return StripToken.CleanUpToken(list, " -,:;");
    }

    public static Vector<StrTokenObject> CleanUpToken(Vector<StrTokenObject> list, String confList) {
        Vector<StrTokenObject> newList = new Vector<StrTokenObject>();
        int lastDelimType = 0;
        block8: for (int i = 0; i < list.size(); ++i) {
            StrTokenObject cur = list.elementAt(i);
            String curToken = cur.GetTokenStr();
            int curDelimType = cur.GetTokenType();
            switch (curDelimType) {
                case 1: {
                    newList.addElement(cur);
                    lastDelimType = curDelimType;
                    continue block8;
                }
                case 2: {
                    if (lastDelimType != 1 && lastDelimType != 4 && lastDelimType != 5 && lastDelimType != 6) continue block8;
                    newList.addElement(cur);
                    lastDelimType = curDelimType;
                    continue block8;
                }
                case 3: {
                    lastDelimType = curDelimType;
                    continue block8;
                }
                case 4: {
                    newList.addElement(cur);
                    lastDelimType = curDelimType;
                    continue block8;
                }
                case 5: {
                    if (newList.size() > 0) {
                        int prevIndex = newList.size() - 1;
                        StrTokenObject prev = newList.elementAt(prevIndex);
                        int prevTokenType = prev.GetTokenType();
                        String prevTokenStr = prev.GetTokenStr();
                        while (prevTokenType == 3 || prevTokenStr.length() == 1 && confList.indexOf(prevTokenStr.charAt(0)) != -1) {
                            newList.remove(prevIndex);
                            prevIndex = newList.size() - 1;
                            prev = newList.elementAt(prevIndex);
                            prevTokenStr = prev.GetTokenStr();
                            prevTokenType = prev.GetTokenType();
                        }
                    }
                    newList.addElement(cur);
                    lastDelimType = curDelimType;
                    continue block8;
                }
                case 6: {
                    if (lastDelimType == 3) continue block8;
                    newList.addElement(cur);
                    lastDelimType = curDelimType;
                }
            }
        }
        return newList;
    }

    public static Vector<StrTokenObject> CleanUpEnd(Vector<StrTokenObject> list) {
        return StripToken.CleanUpEnd(list, " -,:;");
    }

    public static Vector<StrTokenObject> CleanUpEnd(Vector<StrTokenObject> list, String badEndList) {
        Vector<StrTokenObject> newList = new Vector<StrTokenObject>(list);
        if (newList.size() > 0) {
            int lastIndex = newList.size() - 1;
            StrTokenObject last = newList.elementAt(lastIndex);
            String lastTokenStr = last.GetTokenStr();
            while (lastTokenStr.length() == 1 && badEndList.indexOf(lastTokenStr.charAt(0)) != -1) {
                newList.remove(lastIndex);
                lastIndex = newList.size() - 1;
                last = newList.elementAt(lastIndex);
                lastTokenStr = last.GetTokenStr();
            }
        }
        return newList;
    }

    public static String ComposeString(Vector<StrTokenObject> list) {
        String out = new String();
        for (int i = 0; i < list.size(); ++i) {
            StrTokenObject temp = list.elementAt(i);
            out = out + temp.GetTokenStr();
        }
        return out;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("** Usage: java Str <inWord>");
        } else {
            String inWord = args[0];
            Vector<StrTokenObject> tokenList = StripToken.Tokenize(inWord);
            System.out.println("---------------------------------------------");
            System.out.println("in:  '" + inWord + "'");
            System.out.println("out: '" + StripToken.ComposeString(tokenList) + "'");
            Vector<StrTokenObject> newList = StripToken.CleanUpToken(tokenList);
            System.out.println("new: '" + StripToken.ComposeString(newList) + "'");
        }
    }

    private static void AddToList(String tokenStr, int tokenType, Vector<StrTokenObject> list) {
        if (tokenStr != null) {
            StrTokenObject strTokenObj = new StrTokenObject(tokenStr, tokenType);
            list.addElement(strTokenObj);
        }
    }

    private static void PrintTokenVector(Vector<StrTokenObject> list) {
        System.out.println("===============================================");
        for (int i = 0; i < list.size(); ++i) {
            StrTokenObject temp = list.elementAt(i);
            System.out.println(i + ": [" + temp.GetTokenType() + "]-[" + temp.GetTokenStr() + "]");
        }
    }
}

